#ifndef VSMPG_H
#define VSMPG_H

#include <vstypes.h>

#ifndef ASM

#ifndef __VSDSP__
#define __a
#define __b
#define __c
#define __d
#define __x
#define __y
#define __a0
#define __a1
#define __b0
#define __b1
#define __c0
#define __c1
#define __d0
#define __d1
#define __i0
#define __i1
#define __i2
#define __i3
#define auto
#endif

#ifndef CONST
#define CONST const
#endif

typedef unsigned char byte;

#if 0
#include "audio.h"
#else
/*audio.h*/
struct audio_info_struct {
  u_int16 rate;
  u_int16 channels;
};
auto void AudioSet(u_int16 ch, u_int16 r);
auto void AudioInit(void);
#endif

#endif/*!ASM*/

#define		AUDIOBUFSIZE		64

#define         FALSE                   0
#define         TRUE                    1

#define         MAX_NAME_SIZE           81
#define         SBLIMIT                 32
#define         SCALE_BLOCK             12
#define         SSLIMIT                 18

#define         MPG_MD_STEREO           0
#define         MPG_MD_JOINT_STEREO     1
#define         MPG_MD_DUAL_CHANNEL     2
#define         MPG_MD_MONO             3

#define HYBL_SIZE (2*(SBLIMIT+1)*SSLIMIT)
#ifndef ASM
extern s_int16 hyBlock[2][(SBLIMIT+1)*SSLIMIT];
#endif


/* For Application, general.c/h */

#define APPL_RESET	 0
#define APPL_AUDIO	 1
#define APPL_W0		 2
#define APPL_W1		 3
#define APPL_W2		 4
#define APPL_W3		 5
#define APPL_R0		 6
#define APPL_R1		 7
#define APPL_R2		 8
#define APPL_R3		 9
#define APPL_BITSTREAM	10
#define APPL_OUT_OF_DATA 11


#define EXTRA_QUANT_BITS 8 /* for 32-bit quantization, must be at least 3 */


#ifndef ASM

#ifdef ALLOC_IN_X
#define ALLOC_MEM
#else
#define ALLOC_MEM __y
#endif

#define NEW_ALLOC
struct frame {
#ifdef NEW_ALLOC
    ALLOC_MEM const struct al_table * const *alloc;
#else
    ALLOC_MEM const struct al_table *alloc;
#endif
    int stereo;
    int jsbound;
    int single;
    int II_sblimit;
    int lsf;
    int mpeg25;
    int header_change;
    int lay;
/*    void (*do_layer)(void);*/
    int error_protection;
    int bitrate_index;
    int sFreqIdx;
    int padding;
#if 0
    int private;
#endif
    int mode;
    int mode_ext;
#if 0
    int copyright;
    int original;
    int emphasis;
#endif
    int framesize; /* computed framesize */
};


u_int16 get1bit(void);
auto void rewindbits(register __a1 int number_of_bits);
auto u_int16 getbits(register __a1 int);
auto void SetPointer(s_int16);

extern s_int16 pcm_sample[AUDIOBUFSIZE];
extern s_int16 pcm_point;

struct gr_info_s {
      s_int16 scfsi;
      u_int16 part2_3_length;
      u_int16 big_values;
      u_int16 scalefac_compress;
      u_int16 block_type;
      u_int16 mixed_block_flag;
      u_int16 table_select[3];
      u_int16 subblock_gain[3];
      u_int16 maxband[3];
      u_int16 maxbandl;
      u_int16 maxb;
      u_int16 region1start;
      u_int16 region2start;
      u_int16 preflag;
      u_int16 scalefac_scale;
      u_int16 count1table_select;
#if 1
      u_int16 const __y * __x full_gain[3];
      u_int16 const __y * __x pow2gain;
#else
      s_int16 full_gain[3];
      s_int16 pow2gain;
#endif
};

struct III_sideinfo {
  u_int16 main_data_begin;
#if 0
  u_int16 private_bits;
#endif
  struct {
    struct gr_info_s gr[2];
  } ch[2];
};

extern struct frame __y fr;

void do_layer3(void);
auto void InitLayer3(void);
auto void SetLayer3Acc(u_int16 acc); /* 0 = worst, 3 = best */
void do_layer2(void);
void do_layer1(void);

/* Parameter 1 is in format 1.1.14 for range -2.0 .. 2.0 */
auto void synth(s_int16 *,s_int16,s_int16 *,s_int16 *);
auto void synth_mono(s_int16 *,s_int16 *,s_int16 *);
void InitDecode(void);


auto void synth_mono32(s_int32 *,s_int16 *,s_int16 *);
auto void synth32(s_int32 *bandPtr, s_int16 ch, s_int16 *out, s_int16 *pnt);



auto s_int16 wav_open(const char *wavfilename);
auto s_int16 wav_write(void);
#ifdef STANDALONE
auto s_int16 WmaStereoCopy(s_int16 *p, s_int16 samples);
#else
#define ALWAYS_TWO_CHANNELS
auto s_int16 wav_close(void);
#endif

extern unsigned char *conv16to8;
extern const u_int16 freqs[9];
extern const char * const freqNames[9];
extern CONST u_int16 __y muls[64];  /* Values fit    0 .. 2.0     -> 0.1.15 */
extern CONST s_int16 mulmul[27];    /* Values fit -1.0 .. 1.0     -> 1.0.15 */
extern CONST s_int16 __y decwin[512+32];/* Values fit -32768..32767->1.15.0 */

#if 0
void FltInit(void);
void FltCollect(int context, double value);
void FltPrint(void);
#endif

/* LAYER2 */
#ifdef GRP_TAB_IN_X
/* Only allow packed version now.. */
extern CONST u_int16 grp_3tab[32];     /* used: 27 */
extern CONST u_int16 grp_5tab[128];     /* used: 125 */
extern CONST u_int16 grp_9tab[729];     /* used: 729 */
#else
extern CONST u_int16 __y grp_3tab[32]; /* used: 27 */
extern CONST u_int16 __y grp_5tab[128]; /* used: 125 */
extern CONST u_int16 __y grp_9tab[729]; /* used: 729 */
#endif

/* LAYER3 */
#define GAINPOW_SZ 64
extern CONST u_int16 __y gainpow2[GAINPOW_SZ];
extern CONST u_int16 aa_ca[8],aa_cs[8];
extern CONST s_int16 win[4][36];
extern CONST s_int16 win1[4][36];
extern CONST s_int16 tan1_1[16],tan2_1[16],tan1_2[16],tan2_2[16];
extern CONST s_int16 pow1_1[2][16],pow2_1[2][16],pow1_2[2][16],pow2_2[2][16];

#ifdef LIMITS_IN_Y
extern CONST __y u_int16 longLimit[9][23];
extern CONST __y u_int16 shortLimit[9][14];
#else
extern CONST u_int16 longLimit[9][23];
extern CONST u_int16 shortLimit[9][14];
#endif
extern CONST s_int16 mapbuf0[9][152];
extern CONST s_int16 mapbuf1[9][156];
extern CONST s_int16 mapbuf2[9][44];
extern CONST u_int16 n_slen2[512];
#ifdef ISLEN_IN_Y
extern CONST __y u_int16 i_slen2[256];
#else
extern CONST u_int16 i_slen2[256];
#endif

/* These may be used by layer 1 and 2 for other purposes.
   Size for each table is 1152. */
extern s_int16 hybridIn[2][SBLIMIT][SSLIMIT];
extern s_int16 hybridOut[2][SSLIMIT][SBLIMIT];

extern struct audio_info_struct __y ai;
auto void InitCommon(void);


/* For pow43 */
extern u_int16 const     pow43_1_mant[];
extern u_int16 const __y pow43_1_exp[];
extern u_int16 const     pow43_2_mant[];
extern u_int16 const __y pow43_2_exp[];
extern u_int16 const     pow43_4_mant[];
extern u_int16 const __y pow43_4_exp[];

/* For cos64, imdct36 & imdct12 */
extern s_int16 __y const cos64NewTab[];
extern s_int16 __y const cos36Tab[];
extern s_int16 __y const cos12Tab[];

/* For bit routines */
extern u_int16 __y *wordpointer;
extern u_int16 __y bitindex;
extern s_int16 __y bitsremaining;

/* Decode.c's buffer that must be converted with data */
#define SYNTH_BUF_SIZE 0x110
extern s_int16 synth_buffs[2][2][SYNTH_BUF_SIZE];

struct L3 {
  /* Do *NOT* move layer3.accuracyMode (see decasm.s) */
  u_int16 accuracyMode;		/* 0 = lowest accuracy, 3 = best accuracy */
  u_int16 toShift;		/* 1 for best accuracy, 4 for lowest */
  u_int16 toShiftV;	/* 4 for best accuracy, 1 for lowest */
  u_int16 behaveCount;     /* For how many blocks have we behaved? */
  /* Number of audio channels */
  s_int16 stereo1;
};

extern struct L3 __y layer3;

extern s_int16 __y const micFilt[];
extern s_int16 __y const micFiltHP[];

#ifndef VS1003
extern __y s_int16 _common_y_3136[3072+64];
#endif
#endif




#endif
