#ifndef _IMALIB_H
#define _IMALIB_H

/*
  Note: imalib is not used for older VS10xx chips, and the calling
  convention has changed from the previous one. (The function names
  should've been changed.) The new versions use the ImaEnc structure.
  Used in: VS1033c, vs1053b
 */

#include <vstypes.h>

#define IMA_DELAY_LINE_LEN 16 /*for propagate..*/
struct ImaDelayLine {
  s_int16 val;
  s_int16 minStep;
};
struct ImaEnc {
    s_int16 prevVal;
    s_int16 idx;
    struct ImaDelayLine delay[IMA_DELAY_LINE_LEN];
};


#define ISSTMAX 88
#define IMA_ENCODE_BLOCK_ALIGN 256
#define IMA_ENCODE_SAMPLES (2*IMA_ENCODE_BLOCK_ALIGN-7)
#define IMA_ENCODE_BSSPACE (IMA_ENCODE_BLOCK_ALIGN*4) // must be power of 2

extern const s_int16 imaStepSizeTable[ISSTMAX + 1];
#ifdef __VSDSP__
auto s_int16 ImaUpdateState(register __a0 s_int16 val,
			    register __b0 s_int16 step,
			    register __i3 s_int16 *st,
			    register __c0 s_int16 c);
#else
auto s_int16 ImaUpdateState(register __a0 s_int16 val,
			    register __b0 s_int16 step,
			    register __i3 s_int16 *st,
			    register __c0 s_int16 c);
#endif

void ImaExpand(s_int16 n, register __i0 const u_int16 __y *ip,
    register __i1 s_int16 *op);

#ifdef __VSDSP__
auto s_int16 ImaDiv(register __a0 s_int16 a, register __b0 s_int16 b,
		    register __d1 s_int16 step);
#else
auto s_int16 ImaDiv(register __a0 s_int16 a, register __b0 s_int16 b,
		    register __d1 s_int16 step);
#endif

auto void ImaMash(
    s_int16 n,          /* samples to encode PER channel, REQUIRE n % 8 == 1 */
    struct ImaEnc *iEnc,
    register __i0 const s_int16 *ip,   /* ibuff[] is input samples */
    register __i2 s_int16 *st, /* input/output state, 0 <= *st <= ISSTMAX */
    register __i1 u_int16 __y *op  /* output buffer[blockAlign] */
    );

s_int16 Sat16(register __a s_int32 n); /* NOT auto! */

extern u_int16 __y imaStereoPatch;
void ImaExpandStereo(
    s_int16 n,        /* samples to decode PER channel, REQUIRE n % 8 == 1  */
    register __i3 const __y u_int16 *ip, /* input buffer[blockAlign]   */
    s_int16 *op        /* obuff[2*n] will be output samples */
    );



auto void ImaMashStart(
    s_int16 *st,
    s_int16 *val,
    struct ImaEnc *iEnc,
    register __i0 const s_int16 *ip,   /* ibuff[] is one input sample */
    register __i1 __y u_int16 *op  /* output buffer[blockAlign] */
    );
auto void ImaMashContinue(
    s_int16 n,          /* samples to encode now, should be N*4 or last ones */
    s_int16 *st,
    s_int16 *val,
    struct ImaEnc *iEnc,
    register __i0 const s_int16 *ip,   /* ibuff[] is input samples */
    register __i1 __y u_int16 *op  /* output buffer[blockAlign] */
    );

s_int16 ImaExpandStart(
    s_int16 *st,
    s_int16 *val,
    register __i0 __y const u_int16 *ip, /* input buffer[blockAlign]   */
    register __i1 s_int16 *op        /* obuff[0] will be output sample */
    );
void ImaExpandContinue(
    s_int16 n,        /* samples to decode PER channel, REQUIRE n % 8 == 0 */
    s_int16 *st,
    s_int16 *val,
    register __i0 __y const u_int16 *ip, /* input buffer[blockAlign]   */
    register __i1 s_int16 *op        /* obuff[n] will be output samples */
    );

/* When n is 9, sox stereo patch can be performed */
void ImaExpandStereoStart(
    s_int16 n,        /* samples to decode PER channel, REQUIRE n % 8 == 1  */
    s_int16 state[2],
    s_int16 val[2],
    register __i3 const __y u_int16 *ip, /* input buffer[blockAlign]   */
    s_int16 *out       /* obuff[2*n] will be output samples */
    );
void ImaExpandStereoContinue(
    s_int16 n,        /* samples to decode PER channel, REQUIRE n % 8 == 0  */
    s_int16 state[2],
    s_int16 val[2],
    register __i3 const __y u_int16 *ip, /* input buffer[blockAlign]   */
    s_int16 *out       /* obuff[2*n] will be output samples */
    );




struct AGC {
  s_int16 gain;   /* word  0 */
  u_int32 lpRes;  /* words 1, 2 */
  s_int32 offset; /* words 3, 4*/
};

auto s_int16 AGC(register __i0 struct AGC *agc,
		 register __i1 __y const s_int16 *consts,
		 register __a0 s_int16 sig,
		 register __a1 u_int16 mult);

#endif
