#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "vsmpg.h"
#include "hardware.h"
#include "general.h"
#include "asmfuncs.h"
#include "imalib.h"

/*
  TODO:
  - adjustable speaker-mic gain (and take volume control into account?)
  - AEC on/off control (headphones vs. speaker)
  - AGC after AEC
 */




#define DEBUG_LEVEL 0 /* useful for simulation and running from vs3emu */

//#define AEC_LIB

#ifdef AEC_LIB
#include <aec.h>
/*
  - AEC is tuned for 8000Hz samplerate, with 1024-tap filter, thus 128ms.
  - The worst-case CPU needed by AEC for 8000Hz is about 26MHz. This is over
    95% of total CPU needed, so for example 3.0x clock should be enough.
  - Only LEFT output channel is assumed to be connected to speaker.
  - Only LEFT input channel (mic/line) is filtered.

  - You can run the AEC with 12000Hz rate also. Then you need to use
    at least 3.5x or 4.0x clock. The FIR size is still 1024, so only
    max 85ms echo is processed.
 */
AECSTATE aecState;
#endif

extern __y u_int16 g_dcthi[2048];
extern u_int16 g_dctlo[2048];
extern s_int16 g_yprev0[1024];
extern s_int16 g_yprev1[1024]; /*first half is temp, second half FES */
extern volatile u_int16 __y *bssWp, *bssRp;
extern volatile s_int16 *srcWp, *srcRp;

/*using AGC() */
extern struct AdcControl {
    struct AGC agc[2];
    s_int16 adcMode;
    s_int16 encMode;
} adcControl;


__y s_int16 dummy[256];

#if 1
auto void SetImaFill(void);
#else
auto void SetImaFill(void) {
  register s_int16 imaFill = bssWp-bssRp;
  imaFill &= IMA_ENCODE_BSSPACE-1;
  USEX(SCI_HDAT1) = imaFill;
}
#endif

/*
	f=remez(101, [0 0.3 0.37 1], [1 1 0 0], [1 90]);freqz(f);zoom on 
	f3=round(f*2*32768);
	f4=round(f*2*32768*1.597);

	f=remez(63, [0 0.45 0.56 1], [1 1 0 0], [1 90]);freqz(f);zoom on 
	f4=round(f*2*32768*1.1);
*/
#if 0
/* Coefficients are scaled to fill the 16-bit range. This scaling
   is compensated by a gain value passed to ImaDownSample(). */
const __y s_int16 imaDownSampleBy3[102] = {
     -18,      -43,      -59,      -33,       40,      126,
     155,       87,      -40,     -119,      -64,       95,
     212,      148,      -75,     -263,     -209,       83,
     358,      318,      -63,     -455,     -446,       36,
     578,      618,       16,     -719,     -836,      -92,
     891,     1121,      209,    -1100,    -1499,     -383,
    1370,     2026,      650,    -1742,    -2819,    -1090,
    2324,     4184,     1928,    -3460,    -7246,    -4163,
    7156,    22157,    32766,    32766,    22157,     7156,
   -4163,    -7246,    -3460,     1928,     4184,     2324,
   -1090,    -2819,    -1742,      650,     2026,     1370,
    -383,    -1499,    -1100,      209,     1121,      891,
     -92,     -836,     -719,       16,      618,      578,
      36,     -446,     -455,      -63,      318,      358,
      83,     -209,     -263,      -75,      148,      212,
      95,      -64,     -119,      -40,       87,      155,
     126,       40,      -33,      -59,      -43,      -18
};
const __y s_int16 imaDownSampleBy2[64] = {
      36,      114,      118,      -24,     -129,       15,
     181,        3,     -256,      -36,      350,       87,
    -468,     -161,      612,      264,     -790,     -406,
    1011,      602,    -1294,     -877,     1670,     1280,
   -2208,    -1916,     3080,     3084,    -4852,    -6036,
   11117,    32072,    32072,    11117,    -6036,    -4852,
    3084,     3080,    -1916,    -2208,     1280,     1670,
    -877,    -1294,      602,     1011,     -406,     -790,
     264,      612,     -161,     -468,       87,      350,
     -36,     -256,        3,      181,       15,     -129,
     -24,      118,      114,       36
};
#else
/* In ROM */
extern const __y s_int16 imaDownSampleBy3[102];
extern const __y s_int16 imaDownSampleBy2[64];
#endif

/*
  Downsamples two channels: left returned in a1, right in a0
  Input to ImaDownSample() must be stream buffer or any other
  1024-word aligned 1024-word buffer!
 */
auto s_int32 ImaDownSample(register __i0 const s_int16 *buf,
			   register __i1 const __y s_int16 *coeff,
			   register __a0 s_int16 n,
			   register __a1 u_int16 gain /*32768U = 1.0*/);

/*
  MODE    selects between mic / line 1
  AICTRL0 sample rate (read at startup)
  AICTRL1 gain setting or 0 = AGC
  AICTRL2 max gain for autogain
  AICTRL3 D2:ADPCM/LINEAR mode, D0-1:stereo/l/r mode (read at startup)
 */

#if 0
struct ImaEnc imaEnc; /* 34 words, allocate from stack..? */
struct ImaEnc imaEnc1; /* 34 words, allocate from stack..? */
#else
extern struct ImaEnc imaEnc; /* 34 words, allocate from stack..? */
extern struct ImaEnc imaEnc1; /* 34 words, allocate from stack..? */
extern s_int16 imaBuf[16]; /* imaBuf overlaps pcm_sample!! */
#endif

extern __y s_int16 agcConsts[7]; /* copied to YRAM at IMA startup to allow changes */
extern const s_int16 agcConstsInit[7]
#if 0
#define AGC_SPEED 2 /* 1 = fastest. 7 is max */
 = {
    0x600,
    1, /* DC offset removal speed, 1= slowest, 0 = freeze */
    /* 16= 'stable' in 30000 samples, 32=17000, 10=40000 */
    0x400/*MR_SAT*/, 6-1,
    -AGC_SPEED,
    1024,
    -AGC_SPEED-4
}
#endif
;

#if 0
#define AGC_SPEED 2 /* 1 = fastest. 7 is max */
const s_int16 myAgcConstsInit[7] = {
    0x600,
    4, /* DC offset removal speed, 1= slowest, 0 = freeze */
    0x400/*MR_SAT*/, 6-1,
    -AGC_SPEED, 1024, -AGC_SPEED-4
};
#endif

#if 0 //def __VSDSP__
s_int16 ImaExpandStart(
    s_int16 *st,
    s_int16 *val,
    register __i0 __y const u_int16 *ip, /* input buffer[blockAlign]   */
    register __i1 s_int16 *op        /* obuff[0] will be output sample */
    );
#else
/* Was not referenced in VS1053 ROM, so was not linked in from imalib. */
s_int16 ImaExpandStart(
    s_int16 *st,
    s_int16 *val,
    register __i0 __y const u_int16 *ip, /* input buffer[blockAlign]   */
    register __i1 s_int16 *op        /* obuff[0] will be output sample */
    ) {

    /* 1st output sample for this channel */
    *op = *val = (ip[0]>>8) + (ip[0]<<8);
    ip++;
    *st = ip[0]>>8;
    /* specs say to ignore ip[3] , but write it as 0 */
    if (*st > ISSTMAX || (ip[0] & 0xff)) {
	*st = 0;
	return 0; /* fishy.. */
    }
    return 1; /* ok */
}
#endif

#if 0 //def __VSDSP__
void ImaExpandContinue(
    s_int16 n,        /* samples to decode PER channel, REQUIRE n % 8 == 0  */
    s_int16 *st,
    s_int16 *val,
    register __i0 __y const u_int16 *ip, /* input buffer[blockAlign]   */
    register __i1 s_int16 *op        /* obuff[n] will be output samples */
    );
#else
/* Was not referenced in VS1053 ROM, so was not linked in from imalib. */
void ImaExpandContinue(
    s_int16 n,        /* samples to decode PER channel, REQUIRE n % 8 == 0  */
    s_int16 *st,
    s_int16 *val,
    register __i0 __y const u_int16 *ip, /* input buffer[blockAlign]   */
    register __i1 s_int16 *op        /* obuff[n] will be output samples */
    ) {
    int i;

    /* specs say to ignore ip[3] , but write it as 0 */
    i = 0;
    for (; i < n; i++) {
	register __d1 s_int16 step;
	register __c1 s_int16 c;

	c = *ip;
	c >>= ((i+2)&3)*4;
	if ((i&3)==3)
	    ip++;
	c &= 15;

	step = imaStepSizeTable[*st];
	/* Update the state for the next sample */
	*op++ = *val = ImaUpdateState(*val, step, st, c);
    }
}
#endif

#ifdef AEC_LIB
#define FES_BUF_SIZE 256
volatile s_int16 *fes_rd_pointer = &g_yprev1[512];
volatile s_int16 *fes_wr_pointer = &g_yprev1[512];
/* Get the next far-end signal sample. */
s_int16 AecGetFES(void) {
    register s_int16 val = *fes_rd_pointer;
    if (fes_rd_pointer == fes_wr_pointer) {
    } else {
	if (++fes_rd_pointer >= &g_yprev1[512+FES_BUF_SIZE])
	    fes_rd_pointer = &g_yprev1[512];
    }
    return val;
}
/* Put the next far-end signal sample. */
void PutFES(register __i2 s_int16 *p, s_int16 n) {
    register int i;
    for (i=0;i<n;i++) {
#if 1
	*fes_wr_pointer = p[0];            /*left output*/
#else
	*fes_wr_pointer = p[0]/2 + p[1]/2; /*stereo output*/
#endif
	p += 2;
	if (++fes_wr_pointer >= &g_yprev1[512+FES_BUF_SIZE])
	    fes_wr_pointer = &g_yprev1[512];
    }
}
#endif


auto void MyMain(void) {
    register int cnt = 0, decrate = 1;
    __y u_int16 rate;
    static s_int16 st, st1;
    static s_int16 val, val1;
    __y s_int16 imaSamples = 0;
    __y int decPhase = 0;

//#define LOOPBACK
#ifdef LOOPBACK
    USEX(SCI_CLOCKF) = 0x8000; /*VS1053: 3.5x*/

    USEX(SCI_AICTRL0) = 0x1f40;
    USEX(SCI_AICTRL1) = 0x0400;
    USEX(SCI_AICTRL2) = 0xf000;
/* Something wrong in linear mode: goes haywire after a while. */
//    USEX(SCI_AICTRL3) = 4+2; /*left channel, PCM */
//    USEX(SCI_AICTRL3) = 4+3; /*right channel, PCM */
    USEX(SCI_AICTRL3) = 2; /*left channel, IMA */
    //USEX(SCI_AICTRL3) = 3; /*right channel, IMA */

    USEX(SCI_MODE) &= ~(1<<SCIMB_LINE);
//    USEX(SCI_MODE) |= (1<<SCIMB_LINE);

    InitHardware();
#endif

    /*Set the ADPCM flag so HDAT0/HDAT1 are handled by the firmware ROM.*/
    USEX(SCI_MODE) |= (1<<SCIMB_ADPCM);
    applAddr = NULL; /* So WmaStereoCopy won't cause infinite recursion */

    /* prevent the user from sending data to SDI while we do setup */
    USEX(INT_ENABLE) = 0; //INT_EN_ALL & ~(1<<INT_EN_SDI);
    /* Our code was started from interrupt, so decrease global enable */
    USEX(INT_GLOB_ENA) = 0;
    USEX(INT_GLOB_ENA) = 0;
    /* Set up input data buffer */
    stream_rd_pointer = stream_wr_pointer = (void *)stream_buffer;
    srcWp = srcRp = g_yprev0; /* Set up ADC / sample rate conversion buffer */
    bssWp = bssRp = g_dcthi;  /* Set up output data buffer, size 1024 */
    SetImaFill();
#ifdef AEC_LIB
    /* Initialize Acoustic Echo Cancellation.
       2 is the default value for average speaker gain.
       For higher gain try larger values 3..6. */
    AecInit(2,
	    g_dcthi+1024/*fesDelayY*/, 1024   /*fesDelaySize*/,
	    g_dctlo+1024/*firNlmsX */, 1024-16/*firNlmsSize*/);
#endif

    /* autogain max volume default 0 = 64x */
    if (USEX(SCI_AICTRL2) == 0)
	USEX(SCI_AICTRL2) = 65535U;

    /* must disable analog powerdown if it isn't already! */
    USEX(SCI_STATUS) &= ~((1<<SCIST_APDOWN1) | (1<<SCIST_APDOWN2));

    memcpyXY(agcConsts, agcConstsInit, sizeof(agcConsts));
    memset(&adcControl, 0, sizeof(adcControl));
    /* L/R/stereo,used by interrupt routine. */
    adcControl.adcMode = USEX(SCI_AICTRL3) & 3;
    adcControl.encMode = USEX(SCI_AICTRL3) & 4;
    //adcControl.agc[0].offset = adcControl.agc[1].offset = 0;
    //adcControl.agc[0].lpRes  = adcControl.agc[1].lpRes  = 0;
    //adcControl.agc[0].gain = adcControl.agc[1].gain = -32767;
    //adcControl.agc[0].gain = adcControl.agc[1].gain = 0;//-32767;

    /* Allowed rates with this code are: 8000, 12000, 16000, 24000,
       XTALI must be 12.288MHz. */
    rate = USEX(SCI_AICTRL0);
    if (rate < 8000U)
	rate = 8000U;
#if DEBUG_LEVEL > 0
    printf("adcMode %d\n", adcControl.adcMode);
    printf("encMode %d\n", adcControl.encMode);
    printf("rate %d\n", rate);
#endif

    if (rate == 16000U) {
	/* To get 16kHz we run ADC at 48kHz and downsample by 3. */
	USEX(DECIM_CONTROL) = /*DECIM_MODU2_PD | DECIM_MODU1_PD |*/
	    DECIM_ENABLE | DECIM_FACTOR48K;
	decrate = 3; /*48000/3 = 16000*/
#if DEBUG_LEVEL > 0
	printf("48k, decrate %d\n", decrate);
#endif
    } else {
	USEX(DECIM_CONTROL) = /*DECIM_MODU2_PD | DECIM_MODU1_PD |*/
	    DECIM_ENABLE | DECIM_FACTOR24K;
	if (rate == 8000U) {
	    /* To get 8kHz, run ADC at 24kHz and downsample by 3.*/
	    decrate = 3;
	} else if (rate == 12000U) {
	    /* To get 12kHz, run ADC at 24kHz and downsample by 2.*/
	    decrate = 2;
	} else { /*24000*/
	    /* To get 24kHz, run ADC at 24kHz. */
	    decrate = 1;
	}
#if DEBUG_LEVEL > 0
	printf("24k, decrate %d\n", decrate);
#endif
    }
    //USEX(SCI_DECODE_TIME) = decrate;

    if (USEX(SCI_STATUS) & (1<<SCIST_AD_CLOCK)) {
	/* If AD clock is only 3MHz, drop decimation factor by 2x.
	   Note: normal ROM firmware clears this flag when volume
	   is changed (write to SCI_VOL, SCI_BASS, SCI_STATUS). */
	USEX(DECIM_CONTROL) -= 2;
#if DEBUG_LEVEL > 0
	printf("AD=3MHz\n");
#endif
    }
    /* Set DAC to the desired rate also. */
    SetHardware(2, rate);

#if 0
    /* Debug */
    while (1) {
	USEX(DAC_LEFT) = USEX(DAC_RIGHT) = USEX(DECIM_DATA_LEFT)<<4;
    }
#endif
    pcm_point = 0;
    USEX(SER_DREQ) = 1;
    /* SDI can now be enabled! */
    USEX(INT_ENABLE) = INT_EN_ALL | (1<<INT_EN_MODU);

    decPhase = 0;
    while (1) {
	/* If no ADC sample to process, check stream data. */
	while (srcRp == srcWp) {
	    __y u_int16 streamTmp[8];
	    s_int16 tmpBuf[2*32];
#if 1
	    if (StreamDiff() > 8
		&& AudioBufFill() < 2*32) {
#if 1
		/* If IMA ADPCM format and expecting a header,
		   check synchronization */
		//printf("1 decPhase %d\n", decPhase);
		if (adcControl.encMode==0 && decPhase == 0) {
		    register s_int16 *t = (s_int16 *)stream_rd_pointer;
		    MyGetCPairs(streamTmp, 4); /* peek 8 bytes */
		    stream_rd_pointer = (__x u_int16 *)t; /* UnGetC! */
		    if ((streamTmp[1] & 255) == 0 &&
			streamTmp[1] <= (ISSTMAX<<8) &&
			(adcControl.adcMode > 1 ||
			 (streamTmp[3]&255)==0 &&
			 streamTmp[3] <= (ISSTMAX<<8))) {
#if DEBUG_LEVEL > 0
			printf("imaok\n");
#endif
			goto imaok;
		    }
#if DEBUG_LEVEL > 0
		    printf("Skip1 %04x %04x %04x %04x\n", streamTmp[0], streamTmp[1], streamTmp[2], streamTmp[3]);
#endif
		    MyGetC(); /* skip one byte */
		    continue;
		}
	    imaok:
#endif
		MyGetCPairs(streamTmp, 8);

		/* Use NES mode to decide FES mode */
		if (adcControl.encMode) {
		    /* PCM mode */
		    if (adcControl.adcMode <= 1) { /* stereo */
			/* Stereo */
			register s_int16 *t = g_yprev1;
			register __y s_int16 *s = (__y s_int16 *)streamTmp;
			register int i;
			for (i=0; i<8; i++) {
#if 0
			    register s_int32 w = (s_int32)(u_int16)*s++ << 8;
			    *t++ = (s_int16)w | (s_int16)(w>>16);
#else
			    *t++ = *s++;
#endif
			}
#ifdef AEC_LIB
			PutFES(g_yprev1, 4);
#endif
			WmaStereoCopy(g_yprev1, 4);
		    } else {
			/* Mono */
			register s_int16 *t = g_yprev1;
			register __y s_int16 *s = (__y s_int16 *)streamTmp;
			register int i;
			for (i=0; i<8; i++) {
#if 0
			    register s_int32 w = (s_int32)(u_int16)*s++ << 8;
			    t[1] = t[0] = (s_int16)w | (s_int16)(w>>16);
			    t += 2;
#else
			    t[1] = t[0] = *s++;
			    t += 2;
#endif
			}
#ifdef AEC_LIB
			PutFES(g_yprev1, 8);
#endif
			WmaStereoCopy(g_yprev1, 8);
		    }
		} else {
		    if (adcControl.adcMode <= 1) { /* stereo */
			static s_int16 state[2];
			static s_int16 sval[2];
			//printf("Stereo\n");
			if (decPhase == 0) {
#if DEBUG_LEVEL > 0
			    printf("decPhase=0\n");
#endif
			    /* 1+4*2 samples out */
			    /* Decode linear plus first 8 stereo samples */
			    ImaExpandStereoStart(9, state, sval, streamTmp, tmpBuf);
#ifdef AEC_LIB
			    PutFES(tmpBuf, 9);
#endif
			    WmaStereoCopy(tmpBuf, 9);
			    decPhase += 9;
			} else {
			    ImaExpandStereoContinue(16, state, sval, streamTmp, tmpBuf);
#ifdef AEC_LIB
			    PutFES(tmpBuf, 16);
#endif
			    WmaStereoCopy(tmpBuf, 16);
			    decPhase += 16;
			}
		    } else {
			register s_int16 i;
			static s_int16 state, sval;
			//printf("Mono\n");
			if (decPhase == 0) {
#if DEBUG_LEVEL > 0
			    printf("decPhase=0\n");
#endif
			    /* 1+6*4 = 25 samples out */
			    ImaExpandStart(&state, &sval, streamTmp, tmpBuf);
			    ImaExpandContinue(25-1, &state, &sval, streamTmp+2, tmpBuf+1);
			    i = 25;
			} else {
			    /* 8*4 samples out */
			    ImaExpandContinue(32, &state,&sval, streamTmp, tmpBuf);
			    i = 32;
			}
			{
			    register s_int16 *t = g_yprev1;
			    register s_int16 *s = tmpBuf;
			    register int j;
			    for (j=0; j<i; j++) {
				t[1] = t[0] = *s++;
				t += 2;
			    }
#ifdef AEC_LIB
			    PutFES(g_yprev1, i);
#endif
			    WmaStereoCopy(g_yprev1, i);
			}
			decPhase += i;
		    }
		    if (decPhase >= IMA_ENCODE_SAMPLES)
			decPhase = 0;
		}
	    }
#endif
	    /*Wait for the next interrupt*/
	    Sleep(); /* 20051222 POj: calls the idle handler! */
	}

	/* When we come here, at least one ADC sample is waiting because
	   srcRp pointer is different than srcWp. */
	if (++cnt >= decrate) {
	    register u_int32 t; /* both left and right channels */

	    cnt = 0;
	    if (decrate == 1) {
		/* No decimation, take the sample as-is. */
		t = ((u_int32)srcRp[0]<<16) | (u_int16)srcRp[1];
	    } else if (decrate == 2) {
		/* Decimation by 2. Call the decimation filter.
		   ImaDownSample assumes srcRp points to an aligned buffer
		   of size 1024. */
		t = ImaDownSample(srcRp,
				  imaDownSampleBy2, sizeof(imaDownSampleBy2),
				  29789U); /* 0.909 compensate gain 1.1 */
	    } else {
		/* Decimation by 3. Call the decimation filter.
		   ImaDownSample assumes srcRp points to an aligned buffer
		   of size 1024. */
		t = ImaDownSample(srcRp,
				  imaDownSampleBy3, sizeof(imaDownSampleBy3),
				  20518U); /* 0.626 compensate gain 1.597 */
	    }

//printf("t %d %d\n", (s_int16)(t>>16), (s_int16)t);
#if 1 /* 0 for only IMA ADPCM mode */
	    if (adcControl.encMode) {
		/* PCM mode */
		register __y u_int16 *tp = bssWp + 1;
#ifdef AEC_LIB
		{
		    s_int16 tmp = t>>16;
		    /* Note: overheads would be smaller if AecPerform
		       were called with more than one sample, but the
		       AEC filter takes most of the CPU anyway. */
		    AecPerform(&tmp, 1); /*AEC for left ch only*/
		    bssWp[0] = tmp; /*output the processed sample*/
		}
#else
		bssWp[0] = t>>16; /* left  */
#endif/*AEC_LIB*/
#ifdef LOOPBACK
		*stream_wr_pointer++ = bssWp[0];
		if (stream_wr_pointer >= &stream_buffer[1024])
		    stream_wr_pointer = stream_buffer;

#endif
		if (adcControl.adcMode <= 1) { /* stereo */
		    /*Note: tp=bssWp+1 never wraps, because there are even
		      number of words in the buffer. */
		    *tp++ = t;     /* right channel */
		}
		if (tp >= g_dcthi+IMA_ENCODE_BSSPACE) {
		    bssWp = g_dcthi;
		} else {
		    bssWp = tp;
		}
		SetImaFill(); /*update fill state*/

	    } else
#endif
	    {
		/* IMA ADPCM mode */
		/* insert data */
		imaBuf[pcm_point+8] = t;     /* right */
		imaBuf[pcm_point++] = t>>16; /* left  */
		if (imaSamples == 0 || pcm_point >= 8) {
		    /* 2 words per channel generated (=4 words for stereo) */
		    if (imaSamples == 0) {
#if DEBUG_LEVEL > 0
			printf("IMA ADPCM block start\n");
#endif
#ifdef AEC_LIB
			AecPerform(imaBuf, 1); /*AEC for left ch only*/
#endif/*AEC_LIB*/
			imaSamples = 1;
			ImaMashStart(&st, &val, &imaEnc, imaBuf, bssWp);
			if (adcControl.adcMode <= 1) { /* stereo */
			    ImaMashStart(&st1, &val1, &imaEnc1, imaBuf+8,
					 bssWp+2);
			}
		    }
		    if (pcm_point >= 8) { /* 8 stereo samples */
			/* Note: the buffer is a multiple of
			   IMA_ENCODE_BLOCK_ALIGN
			   thus we do not need to worry about wrapping in
			   ImaMash() */
#ifdef AEC_LIB
			AecPerform(imaBuf, 8); /*AEC for left ch only*/
#endif/*AEC_LIB*/
			imaSamples += 8;
			ImaMashContinue(8, &st, &val, &imaEnc, imaBuf, bssWp);
			if (adcControl.adcMode <= 1) { /* stereo */
			    ImaMashContinue(8, &st1, &val1, &imaEnc1,
					    imaBuf+8, bssWp+2);
			}
		    }
#ifdef LOOPBACK
		    *stream_wr_pointer++ = bssWp[0];
		    *stream_wr_pointer++ = bssWp[1];
		    if (stream_wr_pointer >= &stream_buffer[1024])
			stream_wr_pointer = stream_buffer;

#endif
		    /* update write pointer */
		    {
			register __y u_int16 *tp = bssWp + 2;
			if (adcControl.adcMode <= 1) { /* stereo */
			    tp += 2;
			}
			if (tp >= g_dcthi+IMA_ENCODE_BSSPACE) {
			    tp -= IMA_ENCODE_BSSPACE;
			}
			bssWp = tp;
		    }
		    SetImaFill(); /* set fill state */
		    pcm_point = 0;
		    if (imaSamples >= IMA_ENCODE_SAMPLES)
			imaSamples = 0;
		}
	    }
	}
	srcRp += 2;
	if (srcRp >= &g_yprev0[1024])
	    srcRp -= 1024;
    }
}
