/* User application code loading tables for VS10xx */

#if 0
void LoadUserCode(void) {
  int i = 0;

  while (i<sizeof(plugin)/sizeof(plugin[0])) {
    unsigned short addr, n, val;
    addr = plugin[i++];
    n = plugin[i++];
    if (n & 0x8000U) { /* RLE run, replicate n samples */
      n &= 0x7FFF;
      val = plugin[i++];
      while (n--) {
        WriteVS10xxRegister(addr, val);
      }
    } else {           /* Copy run, copy n samples */
      while (n--) {
        val = plugin[i++];
        WriteVS10xxRegister(addr, val);
      }
    }
  }
}
#endif

#ifndef SKIP_PLUGIN_VARNAME
#define PLUGIN_SIZE 2628
const unsigned short plugin[2628] = { /* Compressed plugin */
#endif
  0x0007, 0x0001, 0x8050, 0x0006, 0x0004, 0x2800, 0x44c0, 0x0006, /*    0 */
  0x2016, 0x0007, 0x0001, 0x8023, 0x0006, 0x0002, 0x2a00, 0x148e, /*    8 */
  0x0007, 0x0001, 0x8052, 0x0006, 0x002c, 0x3e12, 0xb817, 0x3e13, /*   10 */
  0x780f, 0x3e13, 0x8024, 0x0000, 0x004d, 0x0008, 0x418f, 0x2808, /*   18 */
  0x2c00, 0x0000, 0x164e, 0x0007, 0x9717, 0x3704, 0x4024, 0x0020, /*   20 */
  0xffd0, 0x3985, 0x4024, 0x3981, 0x8024, 0x3f04, 0x4024, 0x36f5, /*   28 */
  0x5810, 0x36f1, 0x9811, 0x36f2, 0x5808, 0x36f3, 0x8024, 0x36f3, /*   30 */
  0x580f, 0x3602, 0x8024, 0x0030, 0x0717, 0x2100, 0x0000, 0x3f05, /*   38 */
  0xdbd7, 0x0007, 0x0001, 0x8068, 0x0006, 0x004e, 0x3613, 0x0000, /*   40 */
  0x3e22, 0xb815, 0x3e05, 0xb814, 0x3615, 0x0024, 0x0000, 0x800a, /*   48 */
  0x3e10, 0x7802, 0x0000, 0x4001, 0x0000, 0x0202, 0x3e04, 0x930c, /*   50 */
  0xff82, 0x1052, 0x48b2, 0x0024, 0x4180, 0x8041, 0xa122, 0x0024, /*   58 */
  0x4010, 0x0024, 0x0000, 0x4001, 0x3a00, 0x0024, 0x3900, 0x0000, /*   60 */
  0xff82, 0x1012, 0x48b2, 0x0024, 0x4180, 0x2801, 0x0000, 0x1601, /*   68 */
  0x6012, 0x0024, 0x0000, 0x0000, 0x2800, 0x21d9, 0x0000, 0x3fc1, /*   70 */
  0x3433, 0x0000, 0xb010, 0x0024, 0x0000, 0x0040, 0x2800, 0x2245, /*   78 */
  0x0000, 0x0024, 0xb880, 0x134c, 0x3434, 0x8024, 0x3a00, 0x0024, /*   80 */
  0x36f4, 0x8024, 0x36f0, 0x5802, 0x3405, 0x9014, 0x36e3, 0x0024, /*   88 */
  0x2000, 0x0000, 0x36f2, 0x9815, 0x0007, 0x0001, 0x808f, 0x0006, /*   90 */
  0x0078, 0x3613, 0x0024, 0x3e12, 0xb817, 0x3e12, 0x3815, 0x3e05, /*   98 */
  0xb814, 0x3625, 0x0024, 0x0000, 0x800a, 0x3e10, 0x3801, 0x3e10, /*   a0 */
  0xb804, 0x3e11, 0x7807, 0x3e04, 0xb813, 0xb880, 0x104c, 0x2800, /*   a8 */
  0x2ec0, 0x3cf0, 0x0024, 0x3413, 0x0005, 0x3400, 0x0024, 0x6090, /*   b0 */
  0x0024, 0x6090, 0x0024, 0xb010, 0x0024, 0x4000, 0x0024, 0x4000, /*   b8 */
  0x0024, 0x6800, 0x0024, 0xa50a, 0x13c0, 0xb010, 0x0024, 0x6014, /*   c0 */
  0x0024, 0x0000, 0x03c0, 0x2800, 0x2ad5, 0x0000, 0x0024, 0x3013, /*   c8 */
  0x0024, 0xb50a, 0x130c, 0x001c, 0xf500, 0x34f4, 0x984c, 0x4588, /*   d0 */
  0x0801, 0x4010, 0x4493, 0xf400, 0x4015, 0x3501, 0xc024, 0x4784, /*   d8 */
  0x1152, 0x2914, 0x0440, 0x3200, 0x0024, 0x3a00, 0x104c, 0xf400, /*   e0 */
  0x4512, 0x3910, 0x0024, 0x34f0, 0x0024, 0x6090, 0x0024, 0x3a00, /*   e8 */
  0x0024, 0x3413, 0x0024, 0x34c0, 0x0024, 0x3430, 0x4024, 0x6014, /*   f0 */
  0x0024, 0x0000, 0x00c1, 0x2800, 0x2708, 0x0000, 0x0024, 0x36f4, /*   f8 */
  0x9813, 0x36f1, 0x5807, 0x36f0, 0x9804, 0x36f0, 0x1801, 0x3405, /*  100 */
  0x9014, 0x36f3, 0x0024, 0x36f2, 0x1815, 0x2000, 0x0000, 0x36f2, /*  108 */
  0x9817, 0x0007, 0x0001, 0x80cb, 0x0006, 0x0042, 0x3613, 0x0024, /*  110 */
  0x3e22, 0xb815, 0x3e05, 0xb814, 0x3615, 0x0024, 0x0000, 0x800a, /*  118 */
  0x3e10, 0x7802, 0x3e11, 0x3810, 0x3e04, 0x7812, 0x0006, 0x0451, /*  120 */
  0x0006, 0x0492, 0x3104, 0x0024, 0x3001, 0x0024, 0x3100, 0x0024, /*  128 */
  0x3200, 0x4024, 0x6014, 0x0024, 0x0007, 0x4001, 0x2800, 0x3905, /*  130 */
  0x0000, 0x0024, 0x3100, 0x0024, 0x6090, 0x0024, 0x6014, 0x2400, /*  138 */
  0x0007, 0x0000, 0x2800, 0x3911, 0x0000, 0x0024, 0x3900, 0x0024, /*  140 */
  0x4480, 0x9812, 0x36f4, 0x4024, 0x36f1, 0x1810, 0x36f0, 0x5802, /*  148 */
  0x3405, 0x9014, 0x36e3, 0x0024, 0x2000, 0x0000, 0x36f2, 0x9815, /*  150 */
  0x0007, 0x0001, 0x80ec, 0x0006, 0x004e, 0x3613, 0x0024, 0x3e22, /*  158 */
  0xb815, 0x3e05, 0xb814, 0x3615, 0x0024, 0x0000, 0x800a, 0x3e10, /*  160 */
  0x3801, 0x3e10, 0xb804, 0x3e14, 0x3811, 0x3e13, 0xf80e, 0x3e03, /*  168 */
  0x534c, 0xb888, 0x10c0, 0x6402, 0x0024, 0x0000, 0x0024, 0x2800, /*  170 */
  0x4298, 0x4090, 0x0024, 0x2400, 0x4240, 0x0000, 0x0024, 0x0006, /*  178 */
  0x0491, 0x0007, 0x4001, 0x3220, 0x0024, 0x3104, 0x0024, 0x3800, /*  180 */
  0x0024, 0x3100, 0x0024, 0x6090, 0x0024, 0x6014, 0x2400, 0x0007, /*  188 */
  0x0000, 0x2800, 0x4251, 0x0000, 0x0024, 0x3900, 0x0024, 0x6498, /*  190 */
  0x0024, 0x36f3, 0x4024, 0x36f3, 0xd80e, 0x36f4, 0x1811, 0x36f0, /*  198 */
  0x9804, 0x36f0, 0x1801, 0x3405, 0x9014, 0x36e3, 0x0024, 0x2000, /*  1a0 */
  0x0000, 0x36f2, 0x9815, 0x0007, 0x0001, 0x8113, 0x0006, 0x0482, /*  1a8 */
  0x0030, 0x0692, 0x0007, 0x9251, 0x0004, 0x0001, 0x0030, 0x0010, /*  1b0 */
  0x0000, 0x1117, 0x0000, 0x0013, 0x3e05, 0xb814, 0x3685, 0x0024, /*  1b8 */
  0x0000, 0x800a, 0xb888, 0x108c, 0xb880, 0x184c, 0x3009, 0x3040, /*  1c0 */
  0x3000, 0x3340, 0xc012, 0x0024, 0xb880, 0x2001, 0x0006, 0x9f50, /*  1c8 */
  0x003f, 0xfcc1, 0x3900, 0x2013, 0x0007, 0x9751, 0x0006, 0x9f90, /*  1d0 */
  0x3009, 0x2013, 0x0001, 0x0010, 0x3a20, 0x0024, 0x3a00, 0x0024, /*  1d8 */
  0x3a00, 0x0024, 0x0000, 0x0080, 0x3904, 0x0024, 0x0007, 0x9711, /*  1e0 */
  0x3904, 0x0024, 0x0006, 0xc011, 0x0004, 0x0010, 0x3009, 0x2410, /*  1e8 */
  0x0006, 0xbfd1, 0x2914, 0x40c0, 0x3009, 0x2410, 0x0030, 0x0050, /*  1f0 */
  0x0015, 0xbd51, 0x3613, 0x0024, 0x2900, 0xd500, 0x3e00, 0x0024, /*  1f8 */
  0x3000, 0x1bcc, 0xb012, 0x0024, 0x0000, 0x01c0, 0x3800, 0x4024, /*  200 */
  0x2915, 0x8300, 0x0006, 0xc050, 0x0006, 0x6691, 0x0000, 0x00c1, /*  208 */
  0x0030, 0x03d0, 0x3000, 0x0024, 0xb010, 0x0024, 0x6192, 0x2440, /*  210 */
  0x30f0, 0x0024, 0xb010, 0x0024, 0xbc82, 0x2740, 0x3910, 0x0024, /*  218 */
  0x39a0, 0x4024, 0x3910, 0x0024, 0x3920, 0x4024, 0x3910, 0x0024, /*  220 */
  0x39a0, 0x4024, 0x3910, 0x0024, 0x39f0, 0x4024, 0x3000, 0x0024, /*  228 */
  0x4080, 0x0024, 0x0020, 0x0040, 0x2800, 0x5695, 0x0007, 0xd001, /*  230 */
  0x003f, 0xffc0, 0x3800, 0x0024, 0x0020, 0x0040, 0x3143, 0x038c, /*  238 */
  0x39b0, 0x104c, 0x3900, 0x0024, 0x3000, 0x0024, 0x6012, 0xb3c0, /*  240 */
  0x000f, 0xa001, 0x2800, 0x5901, 0x0000, 0x0024, 0xf210, 0x104c, /*  248 */
  0x3009, 0x33c0, 0x6012, 0x0024, 0x0007, 0xd001, 0x2800, 0x5b15, /*  250 */
  0x0030, 0x1093, 0x0000, 0x00c5, 0x0000, 0x0140, 0x2800, 0x5e80, /*  258 */
  0x3b00, 0x0024, 0x0000, 0x01c0, 0x3b00, 0x104c, 0x3009, 0x13c0, /*  260 */
  0x6012, 0x0024, 0x000b, 0xb801, 0x2800, 0x5d55, 0x0000, 0x0024, /*  268 */
  0x2800, 0x5e80, 0x0000, 0x00c5, 0x6012, 0x0024, 0x0000, 0x0045, /*  270 */
  0x2800, 0x5e95, 0x0000, 0x0024, 0x455a, 0x0024, 0x0000, 0x0081, /*  278 */
  0x0030, 0x0050, 0x3000, 0x184c, 0xb010, 0x904c, 0x0007, 0x9010, /*  280 */
  0x2800, 0x6105, 0x0000, 0x0024, 0x3300, 0x0024, 0x6012, 0x0024, /*  288 */
  0x3b00, 0x4024, 0x3009, 0x3845, 0x3009, 0x3844, 0x3009, 0x13c5, /*  290 */
  0x2908, 0xbe80, 0x0000, 0x0084, 0xb880, 0x9bc4, 0x3800, 0x1bc5, /*  298 */
  0x0030, 0x0490, 0x6890, 0x0b8c, 0x3800, 0x10cc, 0x0000, 0x0fc0, /*  2a0 */
  0xb880, 0x2800, 0x2800, 0xa100, 0x3009, 0x3340, 0x2912, 0x0ec0, /*  2a8 */
  0x3613, 0x0024, 0x6012, 0x0024, 0x0000, 0x1001, 0x2800, 0xa089, /*  2b0 */
  0x0000, 0x0024, 0x2912, 0x0d00, 0x3613, 0x0024, 0x6012, 0x0024, /*  2b8 */
  0x0006, 0x66d0, 0x2800, 0xa098, 0x0000, 0x0024, 0x3000, 0x0024, /*  2c0 */
  0x4080, 0x0024, 0x0000, 0x0024, 0x2800, 0x7415, 0x0000, 0x0024, /*  2c8 */
  0x3433, 0x0024, 0x3009, 0x1340, 0x4080, 0x0024, 0x0000, 0x0100, /*  2d0 */
  0x2800, 0x7415, 0x0000, 0x0024, 0x0000, 0x3fc1, 0x0006, 0x9f91, /*  2d8 */
  0x3443, 0x0412, 0xf400, 0x4510, 0x2912, 0x1f80, 0x34c3, 0x184c, /*  2e0 */
  0x3453, 0x2412, 0xf400, 0x4510, 0x3009, 0x12c0, 0xb010, 0x0024, /*  2e8 */
  0x0016, 0x0000, 0x2800, 0x7355, 0x0000, 0x0024, 0x3009, 0x0001, /*  2f0 */
  0x6014, 0x0024, 0x0000, 0x0024, 0x2800, 0x7351, 0x0000, 0x0024, /*  2f8 */
  0x0006, 0x6693, 0x3300, 0x0024, 0x4090, 0x0024, 0x0000, 0x0024, /*  300 */
  0x2800, 0x7419, 0x0000, 0x0024, 0x0000, 0x3fc1, 0x3023, 0x0024, /*  308 */
  0x3009, 0x0000, 0xb010, 0x0024, 0x0016, 0x0000, 0x2800, 0x7355, /*  310 */
  0x0000, 0x0024, 0x3009, 0x0001, 0x6014, 0x0024, 0x0000, 0x0024, /*  318 */
  0x2800, 0x7401, 0x0000, 0x0024, 0x3613, 0x0024, 0x290c, 0x4840, /*  320 */
  0x0000, 0xa108, 0x0000, 0x0200, 0x3443, 0x184c, 0xf400, 0x4510, /*  328 */
  0x2912, 0x1f80, 0x34c3, 0x0024, 0x0006, 0x66d0, 0x30f0, 0x10cc, /*  330 */
  0x4080, 0x0024, 0x3000, 0x0024, 0x2800, 0x81c5, 0x4090, 0x0024, /*  338 */
  0x0006, 0x8012, 0x0000, 0x01ce, 0x3413, 0x0024, 0x2800, 0x7c59, /*  340 */
  0xf400, 0x4511, 0x2400, 0x788e, 0x34c3, 0x0440, 0x3a10, 0x0440, /*  348 */
  0x0000, 0x0100, 0x3613, 0x07cc, 0x3009, 0x3852, 0x0006, 0x8012, /*  350 */
  0x2900, 0x3b00, 0x3e00, 0x0024, 0x0000, 0x0100, 0x36f3, 0x0024, /*  358 */
  0x3e10, 0x1812, 0x0006, 0x8000, 0x290c, 0x7300, 0x3e10, 0x0024, /*  360 */
  0x2800, 0xa080, 0x36e3, 0x0024, 0x2400, 0x7dce, 0x34c3, 0x0024, /*  368 */
  0xf400, 0x4481, 0x6192, 0x8440, 0xf400, 0x4055, 0x3a20, 0x0024, /*  370 */
  0x3d00, 0x0024, 0x0000, 0x0202, 0x0000, 0x0200, 0x3613, 0x0024, /*  378 */
  0x3009, 0x3852, 0x0006, 0x8012, 0x2900, 0x3b00, 0x3e00, 0x0024, /*  380 */
  0x0000, 0x0200, 0x36f3, 0x0024, 0x3e10, 0x1812, 0x0006, 0x8000, /*  388 */
  0x290c, 0x7300, 0x3e10, 0x0024, 0x2800, 0xa080, 0x36e3, 0x0024, /*  390 */
  0x3613, 0x1340, 0x2800, 0x8fd9, 0x4080, 0x0024, 0x0000, 0x0406, /*  398 */
  0x36f3, 0x0024, 0x2800, 0x89d5, 0x0006, 0x0103, 0x0000, 0x0246, /*  3a0 */
  0x0006, 0x0182, 0x3443, 0x184c, 0xf400, 0x4501, 0xf400, 0x4513, /*  3a8 */
  0x3e10, 0x530c, 0x0000, 0x0241, 0x3e10, 0x8024, 0x3e10, 0xc024, /*  3b0 */
  0x291e, 0xa8c0, 0x3e01, 0x8024, 0x36d3, 0x110c, 0xf400, 0x4512, /*  3b8 */
  0x2900, 0x3b00, 0x3e01, 0x930c, 0x3e11, 0x910c, 0xf400, 0x4500, /*  3c0 */
  0x290c, 0x7300, 0x3e10, 0x130c, 0x36e3, 0x10cc, 0xf400, 0x4511, /*  3c8 */
  0x3009, 0x1340, 0x4012, 0x0024, 0x2800, 0x9e40, 0x3009, 0x2401, /*  3d0 */
  0x0006, 0x0182, 0x3443, 0x184c, 0xf400, 0x4501, 0xf400, 0x4513, /*  3d8 */
  0x3e10, 0x530c, 0x0000, 0x0401, 0x3e10, 0x8024, 0x3e10, 0xc024, /*  3e0 */
  0x291e, 0x97c0, 0x3e01, 0x8024, 0x36d3, 0x110c, 0xf400, 0x4512, /*  3e8 */
  0x2900, 0x3b00, 0x3e01, 0x930c, 0x3e11, 0x910c, 0xf400, 0x4500, /*  3f0 */
  0x290c, 0x7300, 0x3e10, 0x130c, 0x36e3, 0x10cc, 0xf400, 0x4511, /*  3f8 */
  0x3009, 0x1340, 0x4012, 0x0024, 0x2800, 0x9e40, 0x3009, 0x2401, /*  400 */
  0x0006, 0x0240, 0x3009, 0x110c, 0xf400, 0x4510, 0x2800, 0x9515, /*  408 */
  0xf400, 0x4511, 0x0000, 0x0603, 0x0006, 0x0201, 0x3e10, 0x130c, /*  410 */
  0x0006, 0x0200, 0x2900, 0x1a00, 0x3e00, 0x0024, 0x0006, 0x0240, /*  418 */
  0x36f3, 0x110c, 0xf400, 0x4511, 0xf400, 0x4510, 0x3e10, 0x044c, /*  420 */
  0x3e10, 0x530c, 0x2900, 0x23c0, 0x3e00, 0xc08c, 0x2800, 0x9700, /*  428 */
  0x0000, 0x0642, 0x0000, 0x0802, 0x0000, 0x0806, 0x0006, 0x0203, /*  430 */
  0x0006, 0x0241, 0x3e10, 0x530c, 0x3e10, 0xc024, 0x2900, 0x23c0, /*  438 */
  0x3e01, 0x8024, 0x36d3, 0x110c, 0xb886, 0x4511, 0x6320, 0x130c, /*  440 */
  0x0006, 0x8012, 0x2800, 0x9a98, 0x0000, 0x0024, 0x4290, 0x0024, /*  448 */
  0x2400, 0x9a40, 0x0000, 0x0024, 0xf400, 0x4481, 0x6192, 0x0440, /*  450 */
  0xf400, 0x4055, 0x6396, 0x2880, 0x3d00, 0x0024, 0x0006, 0x8000, /*  458 */
  0x3613, 0x0024, 0x3009, 0x3852, 0x0006, 0x8012, 0x2900, 0x3b00, /*  460 */
  0x3e00, 0x8024, 0x36f3, 0x0024, 0x3e10, 0x9812, 0x290c, 0x7300, /*  468 */
  0x3e10, 0x0024, 0x36e3, 0x10cc, 0xf400, 0x4510, 0x3009, 0x1341, /*  470 */
  0x4120, 0x0024, 0x3009, 0x2000, 0x0000, 0x7e41, 0x3433, 0x0024, /*  478 */
  0x3009, 0x1340, 0x6012, 0x0024, 0x0000, 0x0024, 0x2800, 0xa088, /*  480 */
  0x0000, 0x0024, 0xb880, 0x10cc, 0x3009, 0x3340, 0x2910, 0x0180, /*  488 */
  0x3613, 0x0024, 0x0007, 0x9711, 0x0007, 0x9750, 0x3000, 0x0024, /*  490 */
  0x3100, 0x4024, 0x6014, 0x0024, 0x0000, 0x0201, 0x2800, 0x6485, /*  498 */
  0x0000, 0x0024, 0x6498, 0x0024, 0x6452, 0x0024, 0x0000, 0x0024, /*  4a0 */
  0x2800, 0xd1c8, 0x0000, 0x0024, 0x0000, 0x0004, 0x4590, 0x0024, /*  4a8 */
  0x0000, 0x0080, 0x2800, 0xa755, 0x0000, 0x0043, 0xb182, 0x0012, /*  4b0 */
  0x3210, 0x8024, 0xfe26, 0x0800, 0x48b6, 0x0024, 0x4286, 0x4102, /*  4b8 */
  0x2800, 0xab00, 0xcdc6, 0x0024, 0x6500, 0x0024, 0x0014, 0xe651, /*  4c0 */
  0x2800, 0xaa15, 0x0000, 0x1980, 0x0014, 0xffd1, 0x0000, 0x1000, /*  4c8 */
  0x001d, 0x1741, 0x2914, 0x3780, 0x3004, 0x184c, 0x2800, 0xab00, /*  4d0 */
  0x4c86, 0x0024, 0x0014, 0x0981, 0x2914, 0x3780, 0x3004, 0x184c, /*  4d8 */
  0x4c86, 0x0024, 0x0006, 0x66d0, 0x3000, 0x0024, 0x4080, 0x0024, /*  4e0 */
  0x0007, 0x9011, 0x2800, 0xb385, 0x4d82, 0x0406, 0x0006, 0xbfd1, /*  4e8 */
  0x3443, 0x0412, 0x6892, 0x4506, 0x3cc0, 0xd84c, 0x3e10, 0x484c, /*  4f0 */
  0x2900, 0xdec0, 0x3e01, 0x8024, 0x3443, 0x0413, 0x34c0, 0x03cc, /*  4f8 */
  0x3000, 0x2c00, 0x4090, 0x9b8c, 0xf400, 0x4480, 0x2800, 0xb099, /*  500 */
  0x0005, 0x0001, 0x3009, 0x2842, 0xf400, 0x4480, 0x601e, 0x0024, /*  508 */
  0x0000, 0x0024, 0x2800, 0xb251, 0x0000, 0x0024, 0x0004, 0x0013, /*  510 */
  0x2800, 0xb280, 0x3009, 0x2413, 0x3009, 0x2400, 0x3613, 0x0024, /*  518 */
  0x2914, 0x40c0, 0x0000, 0xd1c8, 0x4d82, 0x0406, 0x0006, 0x6201, /*  520 */
  0x4162, 0x108c, 0xf400, 0x4055, 0x0006, 0x6001, 0x3d00, 0x1000, /*  528 */
  0x3101, 0x8024, 0x669c, 0x0024, 0x469c, 0x2406, 0x4162, 0x0024, /*  530 */
  0x4080, 0x4055, 0x3d00, 0xc024, 0x2800, 0xb845, 0x0000, 0x0201, /*  538 */
  0x3100, 0x138c, 0x6012, 0x0024, 0x0000, 0x0024, 0x2800, 0xd1c8, /*  540 */
  0x0000, 0x0024, 0x3423, 0x0024, 0x3009, 0x1380, 0x4080, 0x0024, /*  548 */
  0x0006, 0x6800, 0x2800, 0xc095, 0x0006, 0x0012, 0x0006, 0x0087, /*  550 */
  0x0006, 0x6006, 0x0006, 0xbfd3, 0x6892, 0x184c, 0x3e10, 0x4024, /*  558 */
  0x2900, 0xdec0, 0x3e01, 0x8024, 0x36f3, 0x108c, 0x3e10, 0x3381, /*  560 */
  0x3e11, 0xcc11, 0x3e14, 0x8024, 0x291e, 0xf080, 0x0006, 0x6010, /*  568 */
  0x0006, 0x6690, 0x3000, 0x1b4c, 0x4090, 0x0024, 0x0006, 0x7400, /*  570 */
  0x2800, 0xc099, 0x0000, 0x0024, 0x0006, 0x00d7, 0x3613, 0x0c11, /*  578 */
  0x3e10, 0x048c, 0x0006, 0x0040, 0x3e15, 0xc024, 0x3e10, 0x0024, /*  580 */
  0x291e, 0xf080, 0x0006, 0x6210, 0x36d3, 0x0024, 0x0000, 0x0201, /*  588 */
  0x0007, 0x9010, 0x3000, 0x0024, 0x6012, 0x0024, 0x0000, 0x0201, /*  590 */
  0x2800, 0xcb48, 0x0006, 0x0012, 0x0006, 0x0087, 0x0006, 0x6006, /*  598 */
  0x0006, 0xbfd3, 0x3613, 0x0024, 0x3e10, 0x4024, 0x2900, 0xdec0, /*  5a0 */
  0x3e01, 0x8024, 0x36f3, 0x108c, 0xf400, 0x4511, 0x3009, 0x1380, /*  5a8 */
  0x4012, 0x0024, 0x0006, 0x6800, 0x3e10, 0x2401, 0x0000, 0x0200, /*  5b0 */
  0x3e11, 0xcc11, 0x3e14, 0x8024, 0x3e10, 0x0024, 0x291e, 0xfb80, /*  5b8 */
  0x0006, 0x6010, 0x0006, 0x6690, 0x3000, 0x1b0c, 0x4090, 0x0024, /*  5c0 */
  0x0006, 0x7400, 0x2800, 0xcb59, 0x0000, 0x0024, 0x0006, 0x00d7, /*  5c8 */
  0x3613, 0x0c11, 0x3e10, 0x048c, 0x0006, 0x0040, 0x3e15, 0xc024, /*  5d0 */
  0x3e10, 0x0024, 0x0000, 0x0200, 0x3e10, 0x0024, 0x291e, 0xfb80, /*  5d8 */
  0x0006, 0x6210, 0x36c3, 0x0024, 0x0006, 0x6691, 0x0006, 0xbfd0, /*  5e0 */
  0x3100, 0x0012, 0x4090, 0x088c, 0xf400, 0x4480, 0x2800, 0xcd99, /*  5e8 */
  0x0005, 0x0001, 0x3223, 0x0024, 0xf400, 0x4480, 0x601c, 0x0024, /*  5f0 */
  0x0000, 0x7e41, 0x2800, 0xcf11, 0x0000, 0x0024, 0x003f, 0x0013, /*  5f8 */
  0x3283, 0x0024, 0x2914, 0x40c0, 0x3613, 0x2012, 0x0007, 0x9012, /*  600 */
  0xb880, 0x108c, 0x3a00, 0x1380, 0x6012, 0x0024, 0x0000, 0x0024, /*  608 */
  0x2800, 0xd1c8, 0x0000, 0x0024, 0xb880, 0x108c, 0x3009, 0x3380, /*  610 */
  0x0000, 0x0081, 0x0007, 0x9750, 0x3000, 0x0024, 0x4012, 0x0024, /*  618 */
  0x0002, 0x0000, 0x6104, 0x2001, 0x0001, 0x0001, 0x2800, 0xa111, /*  620 */
  0x0000, 0x0024, 0x3000, 0x0024, 0x6012, 0x0024, 0x2800, 0xa100, /*  628 */
  0x3800, 0x4024, 0x0007, 0x0001, 0x1811, 0x0006, 0x0002, 0x1c00, /*  630 */
  0x1c00, 0x0006, 0x8008, 0x0000, 0x0006, 0x0002, 0x0007, 0x7d00, /*  638 */
  0x0006, 0x8006, 0x0000, 0x0006, 0x0001, 0x0002, 0x0007, 0x0001, /*  640 */
  0x8354, 0x0006, 0x004e, 0x3613, 0x0024, 0x3e12, 0xb817, 0x3e12, /*  648 */
  0x3815, 0x3e05, 0xb814, 0x3615, 0x0024, 0x3e10, 0x3801, 0x003c, /*  650 */
  0x0440, 0x3e14, 0x3811, 0x003b, 0x0010, 0x003b, 0x0051, 0x3e04, /*  658 */
  0xb813, 0x0006, 0x08d3, 0x0006, 0x0412, 0x3009, 0x2000, 0x003c, /*  660 */
  0x0040, 0x003c, 0x0010, 0xb880, 0xa400, 0xb882, 0x2800, 0x2915, /*  668 */
  0x7ac0, 0x0001, 0x0000, 0x0000, 0x0240, 0x0006, 0x03d0, 0x3800, /*  670 */
  0x134c, 0x0006, 0x0350, 0x3430, 0x0024, 0xbc82, 0x2c00, 0x3810, /*  678 */
  0x0024, 0x0000, 0xfc00, 0xb882, 0x23c1, 0x2914, 0xbec0, 0x0008, /*  680 */
  0x0010, 0x36f4, 0x9813, 0x36f4, 0x1811, 0x36f0, 0x1801, 0x3405, /*  688 */
  0x9014, 0x36f3, 0x0024, 0x36f2, 0x1815, 0x2000, 0x0000, 0x36f2, /*  690 */
  0x9817, 0x0007, 0x0001, 0x1824, 0x0006, 0x800e, 0xffff, 0x0006, /*  698 */
  0x001f, 0xb504, 0x7fff, 0x5a82, 0x4000, 0x2d41, 0x2000, 0x16a0, /*  6a0 */
  0x1000, 0x0b50, 0x0800, 0x05a8, 0x0400, 0x02d4, 0x0200, 0x016a, /*  6a8 */
  0x0100, 0x00b5, 0x0080, 0x005a, 0x0040, 0x002d, 0x0020, 0x0016, /*  6b0 */
  0x0010, 0x000b, 0x0008, 0x0005, 0x0004, 0x0002, 0x0002, 0x0001, /*  6b8 */
  0x0006, 0x801b, 0x0000, 0x0007, 0x0001, 0x837b, 0x0006, 0x0298, /*  6c0 */
  0x3613, 0x0024, 0x3e12, 0xb817, 0x3e12, 0x3815, 0x3e05, 0xb814, /*  6c8 */
  0x3645, 0x0024, 0x0000, 0x800a, 0x3e10, 0x3801, 0x3e10, 0xb803, /*  6d0 */
  0x3e11, 0x3805, 0x3e11, 0xb807, 0x3e14, 0x3811, 0x3e14, 0xb813, /*  6d8 */
  0x3e13, 0xf80e, 0x3e03, 0x534c, 0xb888, 0x13d2, 0x3440, 0x0024, /*  6e0 */
  0x6402, 0x0024, 0x0000, 0x0024, 0x2801, 0x2e98, 0x4090, 0x0024, /*  6e8 */
  0x2401, 0x2e40, 0x0000, 0x0024, 0x003d, 0x0001, 0x003b, 0x0011, /*  6f0 */
  0x3200, 0x104c, 0x2900, 0x32c0, 0x3009, 0x33c0, 0x3613, 0x0410, /*  6f8 */
  0x3009, 0x2000, 0x3009, 0x0400, 0x6090, 0x0024, 0x6014, 0xa400, /*  700 */
  0x003b, 0x0050, 0x2800, 0xe851, 0x0006, 0x0813, 0x003c, 0x0010, /*  708 */
  0x3009, 0x2410, 0x003b, 0x0050, 0x003f, 0xfdc2, 0x3009, 0x3852, /*  710 */
  0x2901, 0x31c0, 0x3009, 0x0012, 0x0006, 0x0810, 0x408a, 0x9bd2, /*  718 */
  0xfe00, 0x0c46, 0x33f1, 0xc024, 0x68f2, 0x0024, 0xac22, 0x0042, /*  720 */
  0x30f0, 0xc024, 0x4dc2, 0x0024, 0x48b6, 0x2040, 0x6cde, 0x23c1, /*  728 */
  0x0000, 0x0024, 0x2800, 0xed01, 0x0000, 0x0024, 0x3810, 0x8024, /*  730 */
  0x38f0, 0xc024, 0x0006, 0x0790, 0xf152, 0x104c, 0x3009, 0x1000, /*  738 */
  0xf100, 0x0024, 0x6010, 0x0024, 0x3cf0, 0x0024, 0x3011, 0x8024, /*  740 */
  0x30f1, 0xc024, 0x0006, 0x05d0, 0x3010, 0x8024, 0x30f0, 0xc024, /*  748 */
  0x0000, 0x0021, 0xf2d6, 0x0024, 0xf2d6, 0x0024, 0x6fd6, 0x0024, /*  750 */
  0x0000, 0x0024, 0x2800, 0xf301, 0x0000, 0x0024, 0x3010, 0x0024, /*  758 */
  0x30f0, 0x4024, 0x0000, 0x0020, 0xf2c2, 0x0024, 0x2800, 0xf3c0, /*  760 */
  0xf2c2, 0x0024, 0x0006, 0x0790, 0x3010, 0x0024, 0x30f0, 0x4024, /*  768 */
  0x0000, 0x0087, 0xb88c, 0x108c, 0x3c10, 0x0024, 0x3cf0, 0x4024, /*  770 */
  0x3410, 0x8024, 0x34d0, 0xc024, 0x6dfe, 0x0024, 0x0001, 0x0000, /*  778 */
  0x2800, 0xf741, 0x0006, 0x0811, 0x4d82, 0x0024, 0x0000, 0x0020, /*  780 */
  0x003f, 0xfe42, 0xac22, 0x0024, 0x0006, 0x0890, 0xb88c, 0x2000, /*  788 */
  0x689e, 0x0442, 0x31f0, 0xd08c, 0x6dfe, 0x0024, 0x0000, 0x8000, /*  790 */
  0x2800, 0xfa18, 0x0000, 0x0024, 0x4d82, 0x0024, 0x003f, 0xfe82, /*  798 */
  0xac22, 0x0024, 0x3c00, 0x0024, 0x0000, 0x8000, 0x3400, 0x4024, /*  7a0 */
  0x6014, 0x0024, 0x0006, 0x0890, 0x2800, 0xfc01, 0x0000, 0x0024, /*  7a8 */
  0x3c00, 0x0024, 0x3400, 0x4024, 0x6010, 0x0024, 0x3c00, 0x0024, /*  7b0 */
  0x3000, 0x0024, 0x34e0, 0x4024, 0x6014, 0x0024, 0x003b, 0x0053, /*  7b8 */
  0x2800, 0xfe81, 0x003f, 0xfd82, 0x3800, 0x4024, 0x3000, 0x104c, /*  7c0 */
  0x3400, 0x4c10, 0xfe82, 0x984c, 0x48b2, 0x4511, 0xac22, 0x13cc, /*  7c8 */
  0x2901, 0x3e80, 0x3a10, 0x0024, 0x0006, 0x05d0, 0x003f, 0xfe42, /*  7d0 */
  0x0006, 0x05d1, 0x3011, 0x904c, 0x30f1, 0xc024, 0x68f2, 0x0024, /*  7d8 */
  0xac22, 0x0442, 0x31f0, 0xc024, 0x4dc2, 0x0024, 0x3910, 0x0024, /*  7e0 */
  0x39f0, 0x4024, 0x34f0, 0xc024, 0xfe36, 0x0024, 0x48b6, 0x0024, /*  7e8 */
  0x6cde, 0x0024, 0x003b, 0x0011, 0x2801, 0x0558, 0x0000, 0x0024, /*  7f0 */
  0x3810, 0x8024, 0x38f0, 0xc024, 0x003f, 0xfe42, 0x0006, 0x0790, /*  7f8 */
  0x3011, 0x904c, 0x34f0, 0x4024, 0xfe12, 0x03c7, 0x48b2, 0x0024, /*  800 */
  0xac22, 0x0024, 0x003f, 0xfdc2, 0xaf2e, 0x0042, 0x6cf2, 0x03c3, /*  808 */
  0x4dc2, 0x0024, 0x003f, 0xfdc2, 0x3810, 0x0024, 0x38f0, 0x4024, /*  810 */
  0x3009, 0x0c10, 0x3009, 0x0001, 0xfe12, 0x8410, 0x48b2, 0x8007, /*  818 */
  0x0006, 0x0350, 0xac22, 0x0024, 0xfe7e, 0x0024, 0x48be, 0x0024, /*  820 */
  0xaf2e, 0x0042, 0x6cf2, 0x03c3, 0x4dc2, 0x0024, 0x3810, 0x0024, /*  828 */
  0x38f0, 0x4024, 0x0006, 0x0310, 0x3000, 0x0024, 0x4080, 0x0024, /*  830 */
  0x0006, 0x0410, 0x2801, 0x1285, 0x0000, 0x0024, 0x0006, 0x0350, /*  838 */
  0x3010, 0x0024, 0x2901, 0x4a00, 0x30f0, 0x4024, 0x0006, 0x0410, /*  840 */
  0x609a, 0x104c, 0x0006, 0x0900, 0x659a, 0x13c3, 0x4050, 0x184c, /*  848 */
  0xf400, 0x4015, 0x3500, 0xb844, 0xfea6, 0xb852, 0x48b6, 0x8c12, /*  850 */
  0x4dd6, 0x0024, 0x4dd6, 0x0024, 0x4dd6, 0x0024, 0x2901, 0x3780, /*  858 */
  0x4388, 0x0024, 0x3009, 0x1bd2, 0x3009, 0x1bc4, 0xf290, 0x0024, /*  860 */
  0xb880, 0x2000, 0x0006, 0x0310, 0x38f0, 0x0024, 0x3000, 0x0024, /*  868 */
  0x4080, 0x0024, 0x0000, 0x8000, 0x2801, 0x1605, 0x0000, 0x0024, /*  870 */
  0x3000, 0x0024, 0x4090, 0x0024, 0xb880, 0x23c0, 0x2801, 0x1b40, /*  878 */
  0x3800, 0x0024, 0x0006, 0x0650, 0xb882, 0x0042, 0x30f0, 0xc024, /*  880 */
  0x6dc2, 0x0024, 0x0006, 0x0310, 0x2801, 0x1a81, 0x6890, 0x0024, /*  888 */
  0x0006, 0x0290, 0x3000, 0x0024, 0x4090, 0x0024, 0x0000, 0x0024, /*  890 */
  0x2801, 0x1b49, 0x0000, 0x0024, 0x3000, 0x0024, 0x4090, 0x0024, /*  898 */
  0x6890, 0x2080, 0x2801, 0x1b40, 0x3800, 0x0024, 0x38e0, 0x0024, /*  8a0 */
  0x0001, 0x0000, 0x3800, 0x0024, 0x0006, 0x0810, 0x003f, 0xff02, /*  8a8 */
  0x3010, 0x0024, 0x30f0, 0x4024, 0x0006, 0x08d0, 0x2901, 0x4a00, /*  8b0 */
  0xac22, 0x0024, 0xf200, 0x0001, 0x0006, 0x06d0, 0x4010, 0x0024, /*  8b8 */
  0x3800, 0x0024, 0x0006, 0x0710, 0x3010, 0x8024, 0x30f0, 0xc024, /*  8c0 */
  0x0006, 0x05d0, 0x3010, 0x0024, 0x30f0, 0x4024, 0x0006, 0x06d0, /*  8c8 */
  0x3001, 0x4024, 0x0006, 0x0350, 0x685a, 0x0024, 0xac52, 0x0024, /*  8d0 */
  0x6dce, 0x0040, 0x0000, 0x0087, 0x2801, 0x2901, 0xb88c, 0x03c1, /*  8d8 */
  0x6fc2, 0x0024, 0x002b, 0xf200, 0x2801, 0x2501, 0xb882, 0x0024, /*  8e0 */
  0x6dc2, 0x0024, 0x0000, 0x0082, 0x2801, 0x2501, 0x0006, 0x0710, /*  8e8 */
  0xb886, 0x0040, 0x30f0, 0x4024, 0x4cd6, 0x0024, 0x3810, 0x8024, /*  8f0 */
  0x38f0, 0xc024, 0x0006, 0x0310, 0x3000, 0x0024, 0x4080, 0x0024, /*  8f8 */
  0x0000, 0x2000, 0x2801, 0x2815, 0x0000, 0x0024, 0x30f3, 0x0024, /*  900 */
  0x3000, 0x0024, 0x4080, 0x0024, 0x0000, 0x2000, 0x2801, 0x2c45, /*  908 */
  0x0000, 0x0024, 0x0006, 0x02d0, 0xb880, 0x2040, 0x2801, 0x2c40, /*  910 */
  0x3800, 0x0024, 0x6fc2, 0x0024, 0x0000, 0x7d00, 0x2801, 0x2c41, /*  918 */
  0xb882, 0x0024, 0x6cde, 0x0024, 0x0006, 0x0710, 0x2801, 0x2c41, /*  920 */
  0x0000, 0x0024, 0x689c, 0x0040, 0xb88e, 0x03c1, 0x6cfe, 0x0024, /*  928 */
  0x3811, 0x8024, 0x38f1, 0xc024, 0x003d, 0x0001, 0x3009, 0x0c00, /*  930 */
  0x6090, 0x0024, 0x6014, 0xac00, 0x003c, 0x0010, 0x2801, 0x2e51, /*  938 */
  0x0000, 0x0024, 0x3009, 0x2c10, 0x6498, 0x0024, 0x36f3, 0x4024, /*  940 */
  0x36f3, 0xd80e, 0x36f4, 0x9813, 0x36f4, 0x1811, 0x36f1, 0x9807, /*  948 */
  0x36f1, 0x1805, 0x36f0, 0x9803, 0x36f0, 0x1801, 0x3405, 0x9014, /*  950 */
  0x36f3, 0x0024, 0x36f2, 0x1815, 0x2000, 0x0000, 0x36f2, 0x9817, /*  958 */
  0x0007, 0x0001, 0x84c7, 0x0006, 0x002e, 0x3e04, 0x3851, 0x3e04, /*  960 */
  0xf84e, 0x3e03, 0xf84d, 0x3e00, 0xb843, 0x3009, 0x3801, 0x0028, /*  968 */
  0xffd3, 0x0008, 0x0010, 0x0000, 0x0051, 0x0001, 0x800a, 0xbc83, /*  970 */
  0x0b2a, 0x0000, 0xfb8e, 0x2401, 0x350e, 0xfe27, 0x0b2a, 0x5623, /*  978 */
  0x0b2a, 0x4cb2, 0x0024, 0x4cc2, 0x0024, 0xf7c0, 0x9bc1, 0x3600, /*  980 */
  0x9bc3, 0x3603, 0xdbcd, 0x3604, 0xdbce, 0x3604, 0x1bd1, 0x2000, /*  988 */
  0x0000, 0x0000, 0x800a, 0x0007, 0x0001, 0x84de, 0x0006, 0x0038, /*  990 */
  0x3e14, 0x7814, 0x3e14, 0xf80e, 0x3e13, 0xf80d, 0x3e10, 0x3801, /*  998 */
  0x3e10, 0xb805, 0x3e04, 0x0024, 0x0001, 0x000a, 0x0028, 0xffd3, /*  9a0 */
  0x0008, 0x0010, 0x0008, 0x0014, 0x0000, 0x0051, 0x0000, 0x0055, /*  9a8 */
  0xb081, 0x092a, 0x3009, 0x3800, 0xfe28, 0x8a02, 0x0000, 0xfbce, /*  9b0 */
  0x2401, 0x3c4e, 0x5822, 0x8a02, 0xf7cb, 0x0960, 0x5823, 0xcd2a, /*  9b8 */
  0x36f4, 0x0024, 0x36f0, 0x9805, 0x36f0, 0x1801, 0x36f3, 0xd80d, /*  9c0 */
  0x36f4, 0xd80e, 0x36f4, 0x5814, 0x2000, 0x0000, 0x0000, 0x800a, /*  9c8 */
  0x0007, 0x0001, 0x84fa, 0x0006, 0x005c, 0x3e04, 0xb853, 0x3e00, /*  9d0 */
  0x3841, 0x3e00, 0xb843, 0x3e01, 0x3845, 0x3e01, 0xb807, 0x0000, /*  9d8 */
  0x800a, 0x3009, 0x0002, 0x0006, 0x0652, 0xfe24, 0x0024, 0x0fff, /*  9e0 */
  0xff40, 0x48b6, 0x0846, 0xad06, 0x0bc7, 0xaf0a, 0x0024, 0x6fea, /*  9e8 */
  0x0024, 0x4dea, 0x0024, 0x3a11, 0x0024, 0x3a01, 0x4024, 0x0006, /*  9f0 */
  0x04d2, 0x3210, 0x8401, 0x32f0, 0xc024, 0xad0a, 0x0024, 0x6de6, /*  9f8 */
  0x0024, 0xfe12, 0x0024, 0x48be, 0x0024, 0xaf0e, 0x0024, 0x4df6, /*  a00 */
  0x0024, 0x3a10, 0x8024, 0x0fff, 0xfec0, 0x3a00, 0xc024, 0x0006, /*  a08 */
  0x0552, 0x3210, 0x8024, 0x32f0, 0xc024, 0xad0a, 0x0024, 0x6de6, /*  a10 */
  0x0024, 0x0fff, 0xff80, 0xaf0e, 0x0024, 0x4df6, 0x0024, 0x3a10, /*  a18 */
  0x8c40, 0x3af0, 0xc024, 0x3601, 0x9bc7, 0x3601, 0x1bc5, 0x3600, /*  a20 */
  0x9bc3, 0x3600, 0x1bc1, 0x3604, 0x9bd3, 0x2000, 0x0000, 0x0000, /*  a28 */
  0x800a, 0x0007, 0x0001, 0x8528, 0x0006, 0x000e, 0x4c82, 0x0024, /*  a30 */
  0x0000, 0x0024, 0x2000, 0x0005, 0xf5c0, 0x0024, 0x0000, 0x09c1, /*  a38 */
  0x2000, 0x0000, 0x6100, 0x0024,
#ifndef SKIP_PLUGIN_VARNAME
};
#endif
