#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SIZE 262144

#if 0
#define DEBUG
#endif

struct AddrDat {
  unsigned int addr;
  unsigned int data;
};
int nRle = 0, nCopy = 0;
int nWork = 0;
struct AddrDat work[MAX_SIZE];
int nFinal = 0;
unsigned int final[MAX_SIZE];

void Dump(int end) {
  int i = end-nCopy-nRle;
#ifdef DEBUG
  fprintf(stderr, "Dump(end=%d), nCopy %d, nRle %d, i %d\n",
	  end, nCopy, nRle, i);
#endif
  if ((nRle < 3 && nCopy && work[i].addr == work[i+nCopy].addr) || 
       (!nCopy && nRle < 2)) {
    nCopy += nRle;
    nRle = 0;
  }
  if (nCopy) {
    final[nFinal++] = work[i].addr;
    final[nFinal++] = nCopy;    
    while (nCopy--) {
#ifdef DEBUG
      fprintf(stderr, "  Copy %x, %4x\n", work[i].addr, work[i].data);
#endif
      final[nFinal++] = work[i++].data;
    }
  }
  if (nRle) {
#ifdef DEBUG
    fprintf(stderr, "  Rle(%d) %x, %4x\n", nRle, work[i].addr, work[i].data);
#endif
    final[nFinal++] = work[i].addr;
    final[nFinal++] = nRle|0x8000U;    
    final[nFinal++] = work[i].data;
  }
  nRle = 1;
  nCopy = 0;
}

int main(void) {
  char s[256];
  int i;
  while (fgets(s, 256, stdin)) {
    unsigned int t, addr, data;
    char s2[256];
    int n = sscanf(s, "W %x %x %x %s", &t, &addr, &data, s2);
    if (!n) {
      n = sscanf(s, "w %x %x %x %s", &t, &addr, &data, s2);
    }
    if (n == 3) {
      work[nWork].addr = addr;
      work[nWork++].data = data;
    }
  }
#ifdef DEBUG
  fprintf(stderr, "%d words\n", nWork);
#endif

  nRle = 1;
  nCopy = 0;
  for (i=1; i<nWork; i++) {
#ifdef DEBUG
    fprintf(stderr, "i=%2d, addr=%x, data=%04x, nCopy=%d, nRle=%d\n",
	    i, work[i].addr, work[i].data, nCopy, nRle);
#endif
    if (work[i].addr != work[i-1].addr) {
      /* Always causes dump because address changes */
#ifdef DEBUG
      fprintf(stderr, "Address dump\n");
#endif
      Dump(i);
    } else if (work[i].data != work[i-1].data) {
      if (nRle < 6) {
#ifdef DEBUG
	fprintf(stderr, "Fold RLE\n");
#endif
	nCopy += nRle;
	nRle = 1;
      } else {
#ifdef DEBUG
	fprintf(stderr, "Data dump\n");
#endif
	Dump(i);
      }
    } else {
#ifdef DEBUG 
     fprintf(stderr, "Add RLE\n");
#endif
      nRle++;
    }
  }
#ifdef DEBUG
  fprintf(stderr, "Final dump\n");
#endif
  Dump(i);

  printf("/* User application code loading tables for VS10xx */\n"
	 "\n"
	 "#if 0\n"
	 "void LoadUserCode(void) {\n"
	 "  int i = 0;\n"
	 "\n"
	 "  while (i<sizeof(plugin)/sizeof(plugin[0])) {\n"
	 "    unsigned short addr, n, val;\n"
	 "    addr = plugin[i++];\n"
	 "    n = plugin[i++];\n"
	 "    if (n & 0x8000U) { /* RLE run, replicate n samples */\n"
	 "      n &= 0x7FFF;\n"
	 "      val = plugin[i++];\n"
	 "      while (n--) {\n"
	 "        WriteVS10xxRegister(addr, val);\n"
	 "      }\n"
	 "    } else {           /* Copy run, copy n samples */\n"
	 "      while (n--) {\n"
	 "        val = plugin[i++];\n"
	 "        WriteVS10xxRegister(addr, val);\n"
	 "      }\n"
	 "    }\n"
	 "  }\n"
	 "}\n"
	 "#endif\n"


	 "\n");


  printf("#ifndef SKIP_PLUGIN_VARNAME\n"
	 "#define PLUGIN_SIZE %d\n"
	 "const unsigned short plugin[%d] = { /* Compressed plugin */\n"
	 "#endif", nFinal, nFinal);

  for (i=0; i<nFinal; i++) {
    if (i%8) {
      printf(" ");
    } else {
      if (i) {
	printf(" /* %4x */\n  ", i-8);
      } else {
	printf("\n  ");
      }
    }
    printf("0x%04x,", final[i]);
  }
  printf("\n"
	 "#ifndef SKIP_PLUGIN_VARNAME\n"
	 "};\n"
	 "#endif\n");

  exit(EXIT_SUCCESS);
}
