#ifndef AEC_H
#define AEC_H

#include <vstypes.h>

/*
  TODO: easily changable FIR length and samplerate.
 */

#define AEC_LENGTH_BITS 10 //8 //10 //10=1024

#define NLMS_FLT_ALIGN (1<<AEC_LENGTH_BITS)
#define DA_AD_DELAY 16
#define NLMS_FLT_LEN (NLMS_FLT_ALIGN-DA_AD_DELAY)
#define FIR_WINDOW_SHIFT (AEC_LENGTH_BITS-1) //9 //scale sample power



//Constant parameters for speech recognition
//#define FES_MARGIN -5000L //the bigger, the lower FES level is detected
//#define DT_CONST_C 0L //how much nesShortPwr affects DT detection
//#define DT_CONST_D 10000L //20000L // threshold level
//#define NES_MARGIN 5000L //the bigger, the lower NES level is detected




#ifndef ASM

typedef struct {
    s_int16 fesOnly; /* far end speech present n x ENERGY_WINDOW_LENGTH
			samples (saturate at 200 ms) */
    s_int16 dt;      /* double talk present */
    s_int16 nlms;    /*adaptation active*/

    __y s_int16 *uWr;
    __y s_int16 *uRd;

    /*Settings */
    s_int16 errScaleBase; /*default=4, i.e. 1/16*/
    u_int32 errRefLevel; /*having it in the struct: +10 words*/
    u_int32 errRefLevelMax;
    u_int32 firWindowPowerLimit;

    u_int32 firWindowPower;
    s_int32 fesVShortPwr; //32 samples
    s_int32 errShortPwr; //128 samples
    s_int32 errLongPwr; //2048 samples
    s_int32 fesLongPwr; //2048 samples, but with very quick rise.
    
    f_int16 *firNlms;
    __y s_int16 *fesDelay; /* Must be aligned correctly. */
    s_int16 firNlmsSize;
    s_int16 fesDelaySize;
    s_int16 firWindowShift;

    s_int16 reserved[16];
} AECSTATE;

extern AECSTATE aecState;

s_int16 AecGetFES(void); /*must be provided*/
//extern void AecInit(s_int16 scale /*2 for average speaker gain*/);
void AecInit(s_int16 scale,
	     __y s_int16 *fesDelay, s_int16 fesDelaySize,
	     s_int16 *firNlms, s_int16 firNlmsSize);
void AecPerform(s_int16 *buffer, s_int16 numOut);


/*ASM function to count short term power of 
  residual error signal (128 samples)*/
auto void AecErrorPwrAsm(register __i0 s_int16 *e);
/* ASM function to count FIR delay line power */
auto void AecFirPowerAsm(__y register __i0 s_int16 *uOldest,
			 __y register __i1 s_int16 *u);

auto s_int16 AecFirAsm2(register __i2 __y s_int16 *u1,
			register __a0 s_int16 delayLen,
			register __i0 f_int16 *nlms,
			register __a1 s_int16 filterLen);
auto void AecNlmsAsm3(register __i2 __y s_int16 *uNew,
		      register __a0 s_int16 delayLen,
		      register __c0 s_int16 mult,
		      register __i0 f_int16 *nlms,
		      register __a1 s_int16 filterLen);
//extern __y s_int16 aecFESDelay[NLMS_FLT_ALIGN];
//extern f_int16 aecFirNlms[NLMS_FLT_LEN];


#endif /*!ASM*/

#endif /*AEC_H*/


