#ifndef AEC_H
#define AEC_H

#include <vstypes.h>

/*
  TODO: easily changable FIR length and samplerate.
 */
#define AEC_LENGTH_BITS 10 //8 //10 //10=1024

#define NLMS_FLT_ALIGN (1<<AEC_LENGTH_BITS)
#define DA_AD_DELAY 16
#define NLMS_FLT_LEN (NLMS_FLT_ALIGN-DA_AD_DELAY)
#define FIR_WINDOW_SHIFT (AEC_LENGTH_BITS-1) //9 //scale sample power



//Constant parameters for speech recognition
#define FES_MARGIN -5000L //the bigger, the lower FES level is detected
#define DT_CONST_C 0L //how much nesShortPwr affects DT detection
#define DT_CONST_D 10000L //20000L // threshold level
#define NES_MARGIN 5000L //the bigger, the lower NES level is detected




#ifndef ASM

extern s_int16 AecGetFES(void);
extern void AecInit(s_int16 scale /*2 for average speaker gain*/);
extern void AecPerform(s_int16 *buffer, s_int16 numOut);

typedef struct {
  s_int16 fesOnly; /* far end speech present n x ENERGY_WINDOW_LENGTH samples 
		    (saturate at 200 ms) */
  s_int16 dt;  // double talk present
  s_int16 nlms; /*adaptation active*/
} State;


/*ASM function to count
  nesVShortPwr (32 samples), nesShortPwr (128 samples),
  nesLongPwr (2048 samples), fesVShortPwr (32 samples),
  fesShortPwr (128 samples) */
auto void AecPowerAsm(__y register __i0 s_int16 *u,
		      __y register __i1 s_int16 *d);

/*ASM function to count short term power of 
  residual error signal (128 samples)*/
auto void AecErrorPwrAsm(register __i0 s_int16 *e);
/* ASM function to count FIR delay line power */
auto void AecFirPowerAsm(__y register __i0 s_int16 *uOldest,
			 __y register __i1 s_int16 *u);

register __a0 s_int16 HighOne(register __a0 s_int16);
auto s_int16 AecFirAsm(register __i2 __y s_int16 *u1);

auto void AecNlmsAsm(register __i2 __y s_int16 *uNew);
auto void AecNlmsAsm2(register __i2 __y s_int16 *uNew, register __c0 s_int16 mult);
auto void AecHalveAsm(void);
extern __y s_int16 aecFESDelay[NLMS_FLT_ALIGN];
extern f_int16 aecFirNlms[NLMS_FLT_LEN];
//extern s_int16 e;  /* residual between filtered FES and mic signal */

extern s_int32 nesVShortPwr; //32 samples
extern s_int32 nesShortPwr; //128 samples
extern s_int32 nesLongPwr; //2048 samples
extern s_int32 errShortPwr; //128 samples
extern s_int32 fesVShortPwr; //32 samples
extern s_int32 fesShortPwr; //128 samples
//extern f_int16 wu; /* echo estimation */
extern s_int16 aecErrScaleShift; /*default=4, i.e. 1/16*/

#endif /*!ASM*/

#endif /*AEC_H*/


