#!/usr/bin/perl

$length = 0;
$receive = -1;
$newaddr = -1;
$addrNum = -1000;
$addrMatch = 0;

while(<>) {
    $in = $_;
    while ($in =~ /^(.*)\\\s*$/) {
	$in = $1 . <IN>;
    }
    if ($in =~ /^\s+\.sect code,.+$/) {
	$receive = 0x8000;
    }
    if ($in =~ /^\s+\.sect data_y,.+$/) {
	$receive = 0x4000;
    }
    if ($in =~ /^\s+\.sect data_x,.+$/) {
	$receive = 0x0;
    }
    if ($in =~ /^\s+\.org\s+0x(\S+)\s*$/) {
	$newaddr = $1;
	if (hex($newaddr) == $addrNum) {
	    $addrMatch = 1;
	}
	$addrNum = hex($newaddr);
    }
    if ($in =~ /^(0x\S\S\S\S)\s+0x(\S\S\S\S)(\S\S\S\S)\s.+$/) {
	if ($newaddr >= 0) {
	    if ($addrMatch == 0) {
		printf STDERR "new I addr = $newaddr\n";
		printf "W 2 7 %x\n", hex($newaddr)+$receive;
	    } else {
		printf STDERR "new I addr = $newaddr (skipped)\n";
		$addrMatch = 0;
	    }
	    $newaddr=-1;
	}

	printf "W 2 6 $2\n";
	printf "W 2 6 $3\n";
	$length++;
	$addrNum++;
    }
    if ($in =~ /^(0x\S\S\S\S)\s+\.word\s+0x(\S\S\S\S).*$/) {
	if ($newaddr >= 0) {
	    if ($addrMatch == 0) {
		printf STDERR "new %s addr = $newaddr\n",
		($receive < 0x4000) ? "X" : "Y";
		printf "W 2 7 %x\n", hex($newaddr)+$receive;
	    } else {
		printf STDERR "new %s addr = $newaddr (skipped)\n",
		($receive < 0x4000) ? "X" : "Y";
		$addrMatch = 0;
	    }
	    $newaddr=-1;
	}

	printf "W 2 6 $2\n";
	$length++;
	$addrNum++;
	$addrNum++;
    }
}
$pos = $pos * 2;
printf STDERR "Total %d 32-bit words = %d bytes\n", $length, $length*4;

