#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "vsmpg.h"
#include "loud.h"

#define CHANNELS 2

#define DATA_IN 0xC00E
#define DATA_OUT 0xC00F
#define SAMPLE_BLOCK 64


#ifndef __VSDSP__
u_int16 ymemmap[65536];
u_int16 xmemmap[65536];
#endif

#if 0
#define SIN_FREQ 50
#define SIN_AMPL (7500)
#endif

#if 1
#define COMPAND_RESULT
			/* 2048 ~= 1 */
#define COMPAND_MAX_GAIN (8*2048U)
#endif

/* Compand: Locked 00-12-20 v5.11 */

/* Basis = 2048 */
#define COMP_MIN_G  2048	/* 1 */
#define COMP_UNAFFECT_LEVEL (2*163)	/* 32768/64/(PI/2) */




#ifdef __VSDSP__
int ReadSamples(register __i0 s_int16 *samples, register __a0 s_int16 n) {
  register int i;
  for (i=0; i<n; i++) {
    *samples++ = (s_int16)(USEX(DATA_IN))>>1;
  }
  return n;
}
#else
int ReadSamples(FILE *fp, s_int16 *samples, s_int16 n) {
  int i = 0;
  while (i<n && !feof(fp)) {
    *samples    = fgetc(fp) << 8;
    *samples   |= fgetc(fp);
#if 1
    *samples >>= 1;
#endif
    samples++;
    i++;
  }
  return i;
}
#endif

#ifdef __VSDSP__
void WriteSamples(register __i0 s_int16 *samples, register __a0 s_int16 n) {
  register int i;
  for (i=0; i<n; i++) {
    USEX(DATA_OUT) = *samples++;
  }
}
#else
void WriteSamples(FILE *fp, s_int16 *samples, s_int16 n) {
  int i = 0;
  while (i++<n) {
    fputc(*samples >> 8, fp);
    fputc(*samples++ & 0xFF, fp);
  }
}
#endif

s_int16 samples[SAMPLE_BLOCK];


#ifndef __VSDSP__
int main(int argc, char **argv)
#else
int main(void)
#endif
{
#ifndef __VSDSP__
  FILE *readFP = NULL, *writeFP = NULL;
  const char *inName = NULL, *outName = NULL;
  int i;
  for (i=1; i<argc; i++) {
    if (!inName) {
      inName = argv[i];
    } else if (!outName) {
      outName = argv[i];
    } else {
      fprintf(stderr, "Skipping extraneous parameter \"%s\"\n", argv[i]);
    }
  }

  if (!inName || !outName) {
    fprintf(stderr, "Must define input and output file names\n");
  }
#endif


  LoudMain(0, 44100, APPL_RESET); /* Clear buffers by writing 0 to AICTRL[0] */
  LoudMain(0, 2, APPL_W0);	  /* Initialize given filter */

#ifdef __VSDSP__
  while (1) {
    register u_int16 t;
    s_int16 *smp = samples;

    ReadSamples(samples, SAMPLE_BLOCK);
    LoudMain(&smp, SAMPLE_BLOCK/2, APPL_AUDIO);
    WriteSamples(samples, SAMPLE_BLOCK);
  }
#else
  readFP = fopen(inName, "rb");
  if (!readFP) {
    fprintf(stderr, "Couldn't open \"%s\" for reading\n", inName);
    goto close_files;
  }

  writeFP = fopen(outName, "wb");
  if (!writeFP) {
    fprintf(stderr, "Couldn't open \"%s\" for writing\n",
	    outName);
    goto close_files;
  }

  while (ReadSamples(readFP, samples, SAMPLE_BLOCK) == SAMPLE_BLOCK) {
    register int t;
    s_int16 *smp = samples;
    LoudMain(&smp, SAMPLE_BLOCK/2, APPL_AUDIO);
    WriteSamples(writeFP, samples, SAMPLE_BLOCK);
  }

#endif


 close_files:

#ifndef __VSDSP__
  if (readFP && readFP != stdin)
    fclose(readFP);

  if (writeFP && writeFP != stdout)
    fclose(writeFP);
#endif

  return 0;
}
