//----------------------------- DTR RTS -----------------------------

/*IF YOU WANT TO USE RTS AND DTR PINS ON UART YOU MUST DEFINE "USE_DTR_RTS_PINS".
	IF THAT IS NOT THE CASE AND YOU DO NOT WANT TO USE DTR RTS PINS YOU CAN COMMENT OUT
	THAT LINE WHERE "USE_DTR_RTS_PINS" IS DEFINED. IF "USE_DTR_RTS_PINS" IS DEFINED
	YOU HAVE TO SET RIGHT PINS TO "DTR_PIN" AND TO "RTS_PIN".
	
	HOX! DO NOT TOUCH ANY OTHER LINE IN THAT SECTION IF YOU ARE NOT 100% SURE WHAT YOU ARE DOING!
*/

//#define USE_DTR_RTS_PINS

#ifdef USE_DTR_RTS_PINS
#define DTR_PIN 0x2f
#define RTS_PIN 0x2e
#endif


//----------------------------- DCD DSR -----------------------------

/* IF YOU WANT TO USE RTS AND DTR PINS ON UART YOU MUST DEFINE "USE_DCD_DSR_PINS".
	IF THAT IS NOT THE CASE AND YOU DO NOT WANT TO USE DTR RTS PINS YOU CAN COMMENT OUT
	THAT LINE WHERE "USE_DCD_DSR_PINS" IS DEFINED. IF "USE_DCD_DSR_PINS" IS DEFINED
	YOU HAVE TO SET RIGHT PINS TO "DCD_PIN" AND TO "DSR_PIN".
	
	HOX! DO NOT TOUCH ANY OTHER LINE IN THAT SECTION IF YOU ARE NOT 100% SURE WHAT YOU ARE DOING!

*/

//#define USE_DCD_DSR_PINS

#ifdef USE_DCD_DSR_PINS
#define DCD_PIN 0x1d
#define DSR_PIN 0x10
#endif


//----------------------------- UART SELECTION -----------------------------

/* IF YOU WANT TO USE UART BOTH UARTS (UART0 AND UART2) YOU CAN DO SO BY DEFINING "WANT_UART_SELECTABLE".
	IF YOU DO SO YOU MUST DEFINE ALSO "ENABLE_UART0" AND "ENABLE_UART2"! TO CHANGE UART YOU HAVE TO ADD PIN TO
	USE WITH SELECTION. PREDEFINED PIN IS 0x1C (BUTTON_B0 ON DEVELOPER BOARD)
	
	IF YOU WANT TO USE JUST ONE OF THE UARTS, YOU CAN COMMENT OUT "WANT_UART_SELECTABLE" AND DEFINE ONLY 
	ONE UART YOU WANT TO USE, FOR EXAMPLE "ENABLE_UART0".
	
	TO SELECT THE UART YOU ARE GOING TO USE ON STARTUP YOU CAN EITHER DEFINE "USE_UART0" TO USE UART0 OR
	COMMENT THAT LINE OUT TO USE UART2.
	
	HOX! DO NOT TOUCH ANY OTHER LINE IN THAT SECTION IF YOU ARE NOT 100% SURE WHAT YOU ARE DOING!

*/

//#define WANT_UART_SELECTABLE

#ifdef WANT_UART_SELECTABLE

#define UART_SELECTION_PIN 0x1c

#endif

//at leat one of the uarts must be defined (both if WANT_UART_SELECTABLE is defined)
#define ENABLE_UART0
#define ENABLE_UART2

//if you want to use uart2 on startup comment this line out
#define USE_UART0


//----------------------------- SERIALNUMBER -----------------------------

/* IF YOU WANT THAT USB DEVICE SEES YOUR CUSTOM SERIALNUMBER YOU HAVE TO DEFINE "CUSTOM_SERIALNUMBER"
	AND IN ADDITION YOU HAVE TO HAVE YOUR OWN .TXT FILE IN LOCATION DEFINED WITH "USB_SERIAL_LOCATION".
	
	IF CUSTOM SERIALNUMBER IS NOT WANTED, YOU CAN JUST COMMENT OUT THE FIRST LINE WHICH DEFINES "CUSTOM_SERIALNUMBER"
	
	HOX! DO NOT TOUCH ANY OTHER LINE IN THAT SECTION IF YOU ARE NOT 100% SURE WHAT YOU ARE DOING!

*/

#define CUSTOM_SERIALNUMBER
#ifdef CUSTOM_SERIALNUMBER
#define USB_SERIAL_LOCATION "S:serialnumber.txt"
#endif


//----------------------------- CHECK INPUTS -----------------------------

/* IF YOU WANT TO CHECK INPUTS FROM UART OR/AND USB YOU CAN DEFINE "USE_CHECKINPUTS" AND USE FUNCTION PTR
	CALLED *fptr_check TO HANDLE THE INPUTS. PREDEFINED FUNCTION IS TO EXIT PROGRAM WHEN ESC IS DETECTED
*/
//#define USE_CHECKINPUTS 


//----------------------------- RUNLEVEL SELECTION -----------------------------

/* IF WANTED YOU CAN USE THIS APPLICATION ONLY ON RUNLEVEL 9 (USB-UART ADAPTER) YOU CAN
	JUST DEFINE "ALLOW_ONLY_RUNLEVEL9". IF "ALLOW_ONLY_RUNLEVEL9" IS DEFINED AND RUNLEVEL IS SOMETHING
	ELSE THAN 9, APLICATION WILL EXIT AT START WITHOUT OPENING ANY CONNECTION BETWEEN USB AND UART.
*/

#define ALLOW_ONLY_RUNLEVEL9


//----------------------------- FLOW CONTROL -----------------------------

/* IF YOU WANT TO USE FLOW CONTROL (ONLY RTS/CTS IS SUPPORTED) YOU CAN DEFINE "USE_CTS_RTS_FLOW".
	AFTER THAT YOU HAVE TO SET RIGHT PINS TO CTS_PIN AND RTS_PIN!
	
	IF YOU WANT TO ENABLE FLOW CONTROL AND ALSO WANT TO MANUALLY DISABLE/ENABLE FLOW CONTROL DURING
	RUNTIME YOU CAN DEFINE "FLOW_SELECT_PIN". IF THAT MANUAL CONTROLLING IS NOT NEEDED, YOU CAN COMMENT
	DEFINING "FLOW_SELECT_PIN" OUT (LINE 3)
	
	HOX! DO NOT TOUCH ANY OTHER LINE IN THAT SECTION IF YOU ARE NOT 100% SURE WHAT YOU ARE DOING!

*/

//#define USE_CTS_RTS_FLOW

#ifdef  USE_CTS_RTS_FLOW

#define FLOW_SELECT_PIN 0x1d //BUTTON_B1

#define CTS_PIN 0x1c
#define RTS_PIN 0x2f 

#endif


//----------------------------- DEBUG PRINTS -----------------------------

/*IF YOU WANT TO SHOW TESTPRINTS DEFINE "USEDEBUGPRINTS" AND IF NOT, COMMENT IT OUT*/

#define USEDEBUGPRINTS




//----------------------------- FAILSAFE -----------------------------

//CHECKING DEFINES
//HOX! DO NOT TOUCH ANY OTHER LINE IN THAT SECTION IF YOU ARE NOT 100% SURE WHAT YOU ARE DOING!

#if defined USE_CTS_RTS_FLOW && defined USE_DTR_RTS_PINS
#include <DO_NOT_DEFINE_USE_CTS_RTS_FLOW_AND_USE_DTR_RTS_PINS_SIMULTANEOUSLY.h>
#endif


