/// \file main.c VS1010D VSOS Executable main file
/// This is a starting point for developing VS1010D DLX libraries and executables

#include <vo_stdio.h>
#include <volink.h>     // Linker directives like DLLENTRY
#include <apploader.h>  // RunLibraryFunction etc
#include <vs1010dRom.h>
#include <vs1010c.h>
#include <string.h>
#include <math.h> 
#include <vsos.h>
#include <stdlib.h>
#include <string.h>

#include "configPins.h"

u_int16 calculate(u_int32 br){
	u_int32 clock = 12288000;
	u_int32 f;
	u_int32 divider;
	u_int32 max = (u_int32)256*255;
	u_int32 dif = 0;
	u_int32 d1 = 255;
	u_int32 d2 = 255;
	u_int32 cdd1 = 0;
	int i;
	u_int16 bits = 0;
	u_int32 bf;
	u_int32 cd1, cd2;
	u_int32 sdif = 1000000;
	int counter = 0;
	counter = 0;
	sdif = 100000;
	cd1 = 0;
	cd2 = 0;
	
	divider = (u_int32)((long double)clock/(long double)br + 0.5);
	
	// if baud rate is too small
	if(max <= divider){
		cd1 = 255;
		cd2 = 255;
		f = (u_int32)(clock/((cd1+1)*cd2) + 0.5);
		
		sdif = f - br;
		bf = f;
		goto COUNTERPRINT;
	}
	
	// if baud rate is too big
	if((u_int32)1 >= divider){
		cd1 = 0;
		cd2 = 1;
		f = (u_int32)(clock/((cd1+1)*cd2) + 0.5);
		
		sdif = f - br;
		bf = f;
		goto COUNTERPRINT;
	}

	///////////////////////////////////////////////TRY1	
	if((int)(floor(divider/(u_int32)256)) < 1) i = 1;
	else i = (int)((divider/(u_int32)256));
	
	for (i; i <= (int)((long double)(sqrt(divider)) + (long double)1.0); i++){
		counter++; 
		if ((int)divider % i == 0 && (int)divider/i <= 255){
			cd2 = (u_int32)divider/i;
			cd1 = divider/cd2 - 1;
			
			f = (u_int32)(clock/((cd1+1)*cd2) + 0.5);
			if(br > f) dif = br - f;
			else dif = f - br;
			
			sdif = dif;
			bf = f;
			if(dif == 0) goto COUNTERPRINT;
			else break;
		}
	}
	
	COUNTERPRINT:	
	#ifdef USEDEBUGPRINTS
	printf("\nBaud rate calculated\n\n" );
	#endif

	bits = ((int)cd1 << 8) | (int)cd2;

	return bits;
}

