/// \file touch_int.h Touchpad internal functions
#ifndef TOUCH_INT_H
#define TOUCH_INT_H

#include <touch.h>

#define TOUCH_XYS 0x0F
#define TOUCH_ENA 0x0E
#ifndef SAR_DAT
#define SAR_DAT 0xFECD
#endif

extern struct TouchInfo touchInfo;

/* Returns:
   20 if current touch gives a new result,
   10 if replaying old result,
    0 if no touch detected. */
s_int16 MyGetTouchLocation(s_int16 *x, s_int16 *y);
s_int16 InitTouch(void);
void FiniTouch(void);
#if 0
int CalibrateTouch(void);
#endif

#endif
