#ifndef LCDFUNCTIONS_H
#define LCDFUNCTIONS_H

#include <vstypes.h>
#include <vsos.h>

typedef struct TileStruct {
	u_int16 *data;
	u_int16 w;
	u_int16 h;
	ioresult (*getTile)(u_int16 x1, u_int16 y1, u_int16 w, u_int16 h, struct TileStruct *tile, u_int16 *pixels);
} Tile;

extern Tile lcdBackground;
extern Tile metalTile;
extern u_int16 lcdbk[];
extern u_int16 metal[];
extern u_int16 simpleLcd;

ioresult GetTile(u_int16 x1, u_int16 y1, u_int16 w, u_int16 h, Tile *tile, u_int16 *pixels);
u_int16 LcdTextOutXY16 (u_int16 x1, u_int16 y1, char *s);
u_int16 TextWidth16 (char *s);
u_int16 LcdTextOutXY (u_int16 x, u_int16 y, char *s);

#define RENDERBUFFER_SIZE 320

extern u_int16 renderBuffer[RENDERBUFFER_SIZE];


#endif