/// \file main.c Stdbuttons device driver for VSOS3 - uses switches S1, S2 and S3 to control buttons.
/// \author Panu-Kristian Poiksalo, VLSI Solution Oy 2012

/* For free support for VSIDE, please visit www.vsdsp-forum.com */

/** This device driver implements StdButtons so that you can use pushbuttons S1 and S2
	to select which StdButton is highlighted and S3 to click the highlighted StdButton. 
	This driver is useful when you don't have a touch screen. */

#include <vo_stdio.h>
#include <volink.h>     // Linker directives like DLLENTRY
#include <apploader.h>  // RunLibraryFunction etc
#include <vo_gpio.h>
#include <stdbuttons.h>
#include <kernel.h>

// Handlers defined in stdbuttons.c
void MyCreateStdButton();
void MyRenderStdButton();
void MySetVirtualResolution();
void MyGetStdButtonPress();
void MySetClippingRectangleToButton();

ioresult init(char *parameters) {
	GpioSetAsInput(0x00);
	GpioSetAsInput(0x01);
	GpioSetAsInput(0x02);
	SetHandler(CreateStdButton, MyCreateStdButton);
	SetHandler(RenderStdButton, MyRenderStdButton);
	SetHandler(SetVirtualResolution, MySetVirtualResolution);
	SetHandler(GetStdButtonPress, MyGetStdButtonPress);
	SetHandler(SetClippingRectangleToButton, MySetClippingRectangleToButton);	
	return S_OK;
}

void fini(void) {
	//We are not really prepared for the event that we are removed from memory
	printf("Please don't unload StdButtons...");
	while(1); //Stop.
}
