/// \file scsi.h Common SCSI definitions

#ifndef SCSI_H
#define SCSI_H


typedef enum {
  SCSI_UNINITIALIZED,
  SCSI_READY_FOR_COMMAND,
  SCSI_DATA_TO_HOST,
  SCSI_TRANSMITTING,
  SCSI_DATA_FROM_HOST,
  SCSI_SEND_STATUS
} SCSIStageEnum;

typedef enum {
  SCSI_OK = 0,
  SCSI_REQUEST_ERROR = 1,
  SCSI_PHASE_ERROR = 2
} SCSIStatusEnum;


#define OPERATION_CODE 0

//SCSI COMMANDS
#define SCSI_INQUIRY 0x12
#define SCSI_FORMAT_UNIT 0x04
#define SCSI_READ_6 0x08
#define SCSI_READ_10 0x28
#define SCSI_READ_CAPACITY_10 0x25
#define SCSI_READ_CAPACITY_16 0x9e
#define SCSI_READ_CAPACITY_16_2 0x10
#define SCSI_RECEIVE_DIAGNOSTIC_RESULTS 0x1c
#define SCSI_REPORT_LUNS 0xA0
#define SCSI_REQUEST_SENSE 0x03
#define SCSI_SEND_DIAGNOSTIC 0x1d
#define SCSI_TEST_UNIT_READY 0x00
#define SCSI_WRITE_6 0x0a
#define SCSI_WRITE_10 0x2a
#define SCSI_MODE_SENSE_6 0x1a
#define SCSI_SYNCHRONIZE_CACHE 0x35
#define SCSI_PREVENT_ALLOW_MEDIUM_REMOVAL 0x1e

//SCSI SENSE KEYS
#define SK_NO_SENSE 0
#define	SK_RECOVERED_ERROR 1
#define SK_NOT_READY 2
#define SK_MEDIUM_ERROR 3
#define	SK_HARDWARE_ERROR 4
#define	SK_ILLEGAL_REQUEST 5
#define	SK_UNIT_ATTENTION 6
#define	SK_DATA_PROTECT 7
#define	SK_BLANK_CHECK 8
#define	SK_VENDOR_SPECIFIC 9
#define	SK_COPY_ABORTED 10
#define SK_ABORTED_COMMAND 11
#define SK_EQUAL 12
#define SK_VOLUME_OVERFLOW 13
#define SK_MISCOMPARE 14

// Unit attention
#define NOT_READY_TO_READY  0x2800
#define POR_OR_DEVIVE_RESET 0x2900
#define POR_OCCURRED        0x2901
#define SCSI_BUS_RESET      0x2902
#define TARGET_RESET        0x2903

typedef struct {
  union {
    u_int32 lba;
    u_int16 page;    
  } u;
} ScsiRequestParameters;


#endif


