/*

  PlayFilX - Play 2 MP3 files at the same time Client

*/
#include <vo_stdio.h>
#include <volink.h>     /* Linker directives like DLLENTRY */
#include <apploader.h>  /* RunLibraryFunction etc */
#include <timers.h>
#include <libaudiodec.h>
#include <vsostasks.h>
#include <consolestate.h>
#include <ctype.h>
#include <uimessages.h>
#include <string.h>
#include <stdlib.h>
#include <audio.h>
#include <aucommon.h>
#include <sysmemory.h>
#include <kernel.h>
#include <taskandstack.h>

DLLIMPORT(playFil1);
DLLIMPORT(playFil2);

extern char *playFil1, *playFil2;


ioresult main(char *parameters) {
  int nParam, i;
  FILE *fp = NULL;
  char *p = parameters;
  int verbose = 0;
  int retCode = S_ERROR;
  int audioLibNum = 0;
  int chan = 0;
  char *songName = NULL;

  nParam = RunProgram("ParamSpl", parameters);
  for (i=0; i<nParam; i++) {
    if (!strcmp(p, "-h")) {
      printf("Usage: PlayFilX [-1|-2|-c1|-c2|-h] [song]\n"
	     "-1|-2\tForce Track 1|2\n"
	     "-c1|c2\tCancel Track 1|2\n"
	     "song\tSong file name\n"
	     "-h\tShow this help\n");
      goto finally;
    } else if (!strcmp(p, "-1")) {
      chan = 1;
    } else if (!strcmp(p, "-2")) {
      chan = 2;
    } else if (!strcmp(p, "-c1")) {
      playFil1 = (char *)0xFFFF;
      while (playFil1) Delay(10);
    } else if (!strcmp(p, "-c2")) {
      playFil2 = (char *)0xFFFF;
      while (playFil2) Delay(10);
    } else if (!songName) {
      songName = p;
    } else {
      printf("E: Extraneous parameter \"%s\"\n", p);
      goto finally;
    }
    p += strlen(p)+1;
  }

  if (songName) {
    if (chan != 2 && !playFil1) {
      playFil1 = songName;
      printf("Track 1: %s\n", songName);
      while (playFil1 == songName) Delay(10);
    } else if (!playFil2) {
      playFil2 = songName;
      printf("Track 2: %s\n", songName);
      while (playFil2 == songName) Delay(10);
    } else {
      printf("E: Both audio tracks already in use\n");
      goto finally;
    }
  }

  printf("Track 1 %s, Track 2 %s\n",
	 playFil1 ? "playing" : "stopped",
	 playFil2 ? "playing" : "stopped");

  retCode = S_OK;
 finally:

  return retCode; /* End of files, ok exit */
}
