#include <vo_stdio.h>
#include <volink.h>     /* Linker directives like DLLENTRY */
#include <apploader.h>  /* RunLibraryFunction etc */
#include <kernel.h>

ioresult main(char *parameters) {
  static s_int16 d16[] = {0x1234, 0x5678, 0x1122, 0x3344};
  static s_int32 d32[] = {0x12345678, 0x87654321, 0x11223344, 0x55667788};
  static s_int16 d1632[] = {0x1122, 0x3344, 0x5566, 0x7788,
			    0xaaaa, 0xbbbb, 0xcccc, 0xdddd};
  static s_int16 t16[2][4];
  static s_int32 t32[2][4];
  static s_int16 t1632[2][4];
  u_int16 volume = 32768;

  for (i=0; i<sizeof(d16)/sizeof(d16[0]); i++) {
    printf("%04x ", d16[i]);
  }
  printf("<-- original\n");
  Convert16BitVSDSPTo16BitLE(t16[0], d16, sizeof(d16)/sizeof(d16[0])/2);
  Convert16BitVSDSPTo16BitLEInPlace(d16, sizeof(d16)/sizeof(d16[0])/2);
  for (i=0; i<sizeof(d16)/sizeof(d16[0]); i++) {
    printf("%04x ", d16[i]);
  }
  printf("<-- converted IP\n");
  for (i=0; i<sizeof(d16)/sizeof(d16[0]); i++) {
    printf("%04x ", t16[0][i]);
    }
  printf("<-- converted\n");
  printf("3412 7856 2211 4433 <-- correct\n");
  Convert16BitLETo16BitVSDSP(t16[1], t16[0], sizeof(d16)/sizeof(d16[0])/2);
  Convert16BitLETo16BitVSDSPInPlace(d16, sizeof(d16)/sizeof(d16[0])/2);
  for (i=0; i<sizeof(d16)/sizeof(d16[0]); i++) {
    printf("%04x ", d16[i]);
  }
  printf("<-- back IP\n");
  for (i=0; i<sizeof(d16)/sizeof(d16[0]); i++) {
    printf("%04x ", t16[1][i]);
  }
  printf("<-- back\n\n");

  for (i=0; i<sizeof(d32)/sizeof(d32[0]); i++) {
    printf("%08lx ", d32[i]);
  }
  printf("<-- original\n");
  Convert32BitVSDSPTo24BitLE(t32[0], d32, sizeof(d32)/sizeof(d32[0])/2);
  Convert32BitVSDSPTo24BitLEInPlace(d32, sizeof(d32)/sizeof(d32[0])/2);
  for (i=0; i<sizeof(d32)/sizeof(d32[0]); i++) {
    printf("%08lx ", d32[i]);
  }
  printf("<-- converted IP\n");
  for (i=0; i<sizeof(d32)/sizeof(d32[0]); i++) {
    printf("%08lx ", t32[0][i]);
  }
  printf("<-- converted\n");
  printf("12435634 33226587 66551177(55667788)<-- correct\n");
  Convert24BitLETo32BitVSDSP(t32[1], t32[0], sizeof(d32)/sizeof(d32[0])/2);
  Convert24BitLETo32BitVSDSPInPlace(d32, sizeof(d32)/sizeof(d32[0])/2);
  for (i=0; i<sizeof(d32)/sizeof(d32[0]); i++) {
    printf("%08lx ", d32[i]);
  }
  printf("<-- back IP\n");
  for (i=0; i<sizeof(d32)/sizeof(d32[0]); i++) {
    printf("%08lx ", t32[1][i]);
  }
  printf("<-- back\n\n");

  for (i=0; i<sizeof(d1632)/sizeof(d1632[0]); i++) {
    printf("%04x ", d1632[i]);
  }
  printf("<-- original\n");
  Convert32BitVSDSPTo16BitLE(t1632[0], d1632, sizeof(d1632)/sizeof(d1632[0])/4);
  Convert32BitVSDSPTo16BitLEInPlace(d1632, sizeof(d1632)/sizeof(d1632[0])/4);
  for (i=0; i<sizeof(d1632)/sizeof(d1632[0]); i++) {
    printf("%04x ", d1632[i]);
  }
  printf("<-- converted IP\n");
  for (i=0; i<sizeof(d1632)/sizeof(d1632[0]); i++) {
    printf("%04x ", t1632[0][i]);
  }
  printf("<-- converted\n");
  printf("4433 8877 bbbb dddd(aaaa bbbb cccc dddd)<-- correct\n");
  d1632[4] = 0xabab;
  d1632[5] = 0xabab;
  d1632[6] = 0xabab;
  d1632[7] = 0xabab;
  Convert16BitLETo32BitVSDSP(t1632[1], t1632[0], sizeof(d1632)/sizeof(d1632[0])/4);
  Convert16BitLETo32BitVSDSPInPlace(d1632, sizeof(d1632)/sizeof(d1632[0])/4);
  for (i=0; i<sizeof(d1632)/sizeof(d1632[0]); i++) {
    printf("%04x ", d1632[i]);
  }
  printf("<-- back IP\n");
  for (i=0; i<sizeof(d1632)/sizeof(d1632[0]); i++) {
    printf("%04x ", t1632[1][i]);
  }
  printf("<-- back\n\n");

  return EXIT_SUCCESS;
}
