/* For free support for VSIDE, please visit www.vsdsp-forum.com */

/// \file libtrace.c Find the library which contains the code address, which is given as a parameter
/// \author Panu-Kristian Poiksalo, VLSI Solution Oy

/// This library is called by the kernel entry point ZeroPtrCall. It resolves the library from which 
/// a call to address 0 was made. Usually such a function call is made by calling a method of an
/// uninitialized object. This library then finds which library is loaded to that address, prints out
/// the name of the library, segment and offset. That information is then passed to find_err.dl3,
/// which opens the libfile, scans its symbol table and prints out the name of the function that
/// made the erroneous method call.


#include <vo_stdio.h>
#include <volink.h>
#include <apploader.h>
#include <lcd.h>
#include <stdbuttons.h>
#include <string.h>


const char ixy[] = "IXY";
u_int16 offend_addr = 0;
char *offend_plibname = NULL;


struct offend_info {
	u_int16 *lib;
	u_int16 segment;
	u_int16 offset;
	char libname[9];
} off = {
	0, 0, 0xffffu, ""
};


void PrintLibInfo2(FILE *of, u_int16 *lib) {
	u_int16 *p = lib;
	u_int16 entries;
	u_int16 *entrylist;
	u_int32 libfileptr;
	u_int16 fini;
	u_int16 entry_main;
	u_int16 nSections;	
	u_int16 refCount;
	u_int16 sizes[3]={0};
	u_int16 istart = 0;	
	u_int16 i;
	
	entries = *p++;
	refCount = *p++;
	entry_main = *p++;
	fini = *p++;
	entrylist = p;
	p += entries;
	libfileptr = *(u_int32*)p;
	p+= 2;
	nSections = *p++;
	
	for (i=0; i<nSections; i++) {
		u_int16 size = (*p >> 2) << 1;		
		u_int16 page = *p&3;
		sizes[page] += size;
		p++;
		if ((page==0) && (*p <= offend_addr) && (off.offset > offend_addr-*p)) {
			off.offset = offend_addr-*p;
			off.lib = lib;
			off.segment = i;
		}
		p++;		
	}
	p++;
	if (off.lib == lib) 	{
		char *d = off.libname;
		char *s = (char*)p;
		while (*s && *s != '.') {
			*d++ = *s++;
		}
		*d=0;
	}
}


int main(u_int16 offender_physical_address) {
	u_int16 i;
	offend_addr = offender_physical_address;
	for (i=0; i<MAX_LIB; i++) {
		if (loadedLib[i]) PrintLibInfo2(vo_stderr,loadedLib[i]);		
	}

	fprintf(vo_stderr,"Offending lib: %s:%d.%d\n",off.libname,off.segment,off.offset);
	RunLibraryFunction("FIND_ERR",0,(int)&off);
	return S_OK;
}
