/* For free support for VSIDE, please visit www.vsdsp-forum.com */

/// \file find_err.c Find an error location in a libfile
/// \author Panu-Kristian Poiksalo, VLSI Solution Oy

/// This library is typically called by libtrace.dl3, which passes a libname[8],
/// segment and offset to this find_err, which then tries to open the libfile by
/// extending libname to s:sys/libname.dl3 or, that failing, to s:libname*
/// It then scans the libfile's symbol table and prints the name of the function
/// in whose address space the specified location (error point) is.

#include <vo_stdio.h>
#include <volink.h>     // Linker directives like DLLENTRY
#include <apploader.h>  // RunLibraryFunction etc

CHIPSPECIFIC (VS1005G)
LINK_ABS (sprintf,62531)

typedef struct offend_info {
	u_int16 *lib;
	u_int16 segment;
	u_int16 offset;
	char libname[9];
};

char lfn[20];
FILE *f;
static Resource resource;


u_int16 NextResource(register FILE *f){
	if (resource.pos) {
		f->pos = resource.pos + 8 + resource.header.length;
		if (f->pos & 1) f->pos++;
	}
	resource.pos = f->pos;	
	fread(&resource.header, 1, sizeof(resource.header), f);
	return resource.header.resourceType;
}


ioresult main (struct offend_info *offend) {
	u_int32 s_pos = 0;
	u_int16 s_ofs = 0;
	u_int16 best_ofs = 0xffffu;
	ioresult result = S_OK;
	//fprintf(vo_stderr,"Find offender %s:%d.%d: ",offend->libname,offend->segment,offend->offset);
	sprintf(lfn,"S:SYS/%s.DL3",offend->libname);
	f=fopen(lfn,"rb");
	if (!f) {
		sprintf(lfn,"S:%s*",offend->libname);
		f=fopen(lfn,"rb");
		if (!f) {
			fprintf(vo_stderr,"Hmm, seems not %s, sorry.\n",lfn);
			return S_ERROR;
		}
	}
	f->pos=4;
	while(resource.header.resourceType != _RESTYPE_ENTRYLIST) {
		if (NextResource(f) == _RESTYPE_SYMBOL + offend->segment) {
			if ((offend->offset >= resource.header.subType) 
			&& (offend->offset - resource.header.subType < best_ofs)) {			
				best_ofs = offend->offset - resource.header.subType;
				s_pos = f->pos;
				s_ofs = resource.header.subType;
			}
		}
	}
	if (s_pos) {
		fprintf(stderr,"Function: ");
		f->pos = s_pos;
		while(1) {
			char ch;
			fread(&ch, 1, 1, f);
			if (ch) {
				fputc(ch,stderr);
			} else {
				break;
			}
		}
		fprintf(stderr,"+%d\n",offend->offset - s_ofs);		
		result = S_ERROR;
		goto finally;
	}
	fprintf(stderr,"Not found\n");
	finally:
	fclose(f);
	return result;
}


