/// \author Lasse

#include <vo_stdio.h>
#include <volink.h>
#include <string.h>
#include <StdWidget.h>
#include <swint.h>
#include <touch.h>

static BtnPos* currentPos=0;
static IconInfo* iconInfo=0;
u_int16 currentLayerMask=0; // UI layers that are currently shown (bitmask)
static StdWidget* currentDialog=0; // current list of widgets
static LayoutManagerState* layout[NUM_LAYERS]; // the layout manager for each UI layer
static StdWidget* focusWidget=0; // reference to a widget the user is interacting with
static s_int16 touchX=-1; // last touch location for touch-based UI's
static s_int16 touchY=-1;
static u_int16 scanLine[RESX]; // rendering buffer (RGB565 pixel values)
static StdWidget* prevPage=0;
static StdWidget* nextPage=0;
static u_int16 repaint=0;

u_int16 ProcessWidgets(regz u_int16,regz LMCallback);
void WidgetPainter(regz StdWidget*);
void WidgetListener(regz StdWidget*);

void SetPaintRequest(regz StdWidget* w) {
	w->flags|=WF_PAINT;
	if(!repaint) {
		repaint=1;
	}
}

void ResetLayoutManagerState(regz u_int16 mask,regz u_int16 persistent) {
	LayoutManagerState** l=layout;
	u_int16 layer=1;
	u_int16 i;
	for(i=0;i<NUM_LAYERS;i++) {
		if(layer&mask) {
			LayoutManagerState* state=*l;
			state->currentIndex=0;
			state->lastVisible=0;
			state->size=0;
			state->firstVisible*=persistent;
		}
		layer<<=1;
		++l;
	}
}

//
// call SWInit() once for each screen of the user interface before calling SWUpdate()
//

DLLENTRY(SWInitProc)

void SWInitProc(regz StyleManager styleManager,regz void* extra) {
	currentLayerMask=~0; // impossible value to trigger init during next SWUpdate
	styleManager(layout,&currentPos,&iconInfo);
}

//
// SWUpdate: update screen and poll user event
//

DLLENTRY(SWUpdateProc)

void SWUpdateProc(regz u_int16 hiddenLayerMask,regz struct StdWidget* widgets) {
	u_int16 layerMask=0xFF^hiddenLayerMask;
	if(currentLayerMask!=layerMask || widgets!=currentDialog) {
		//
		// Init
		//
		currentLayerMask=layerMask;
		currentDialog=widgets;
		ResetLayoutManagerState(layerMask,0);
		ProcessWidgets(layerMask,SetPaintRequest);
		if(prevPage) {
			prevPage->userEvent=0;
		}
		if(nextPage) {
			nextPage->userEvent=0;
		}
	}
	if(GetTouchLocation(&touchX,&touchY)) {
		repaint=2;
	} else if(repaint) {
		--repaint;
		if(repaint==1 && focusWidget) {
			focusWidget->flags&=~WF_ACTIVATED;
			focusWidget->flags|=WF_PAINT;
			focusWidget->userEvent(focusWidget,0,0,0);
			focusWidget=0;
			touchX=-1;
			touchY=-1;
		}
	} else {
		return;
	}
	if(ProcessWidgets(layerMask,WidgetListener)) {
		u_int16 layer;
		for(layer=0;layer<NUM_LAYERS;layer++) {
			LayoutManagerState* state=layout[layer];
			if(state && ((1<<layer)&layerMask) && state->currentIndex && state->finishLayout) {
				state->finishLayout(state);
			}
			++state;
		}
		ProcessWidgets(layerMask,WidgetPainter);
	}
}

static u_int16 ProcessWidgetList(regz StdWidget* widget,regz LMCallback op,regz LayoutManagerState* state) {
	static StdWidget dList[MAX_DI]={0}; // space for dynamic widget list
	StdWidget* listItem=dList;
	DListCallback getNextItem=widget->content.dynamicListCallback;
	s_int16 startIndex=state->currentIndex;
	u_int16 rv;
	if(startIndex<state->firstVisible) {
		state->currentIndex=state->firstVisible;
	}
	rv=0;
	while(1) {
		u_int16 paint=listItem->flags&WF_PAINT; // need to preserve the WF_PAINT flag
		if(!getNextItem(listItem,state->currentIndex-startIndex)) {
			return rv;
		}
		listItem->flags|=paint;
		rv|=paint;
		if(state->layoutManager(state,listItem,op)) {
			state->lastVisible=state->currentIndex;
			++listItem;
		}
		++state->currentIndex;
	}
}

//
// ProcessWidgets: send each widget to its corresponding layout manager for processing
//
u_int16 ProcessWidgets(regz u_int16 layerMask,regz LMCallback op) {
	StdWidget* widget;
	volatile u_int16 paint=0; // <--------------------------------------------- optimointi pois niin toimii ilman volatilea..?
	//
	ResetLayoutManagerState(layerMask,1);
	//
	widget=currentDialog;
	while(widget->flags!=WT_END_OF_LIST) {
		u_int16 layer=widget->flags&(7|WF_HIDDEN);
		// the presence of a WF_HIDDEN flag should push the layer index outside of the valid range
		// (which should make the check below fail, effectively leaving such widget out of the processing)
		if((1<<layer)&layerMask) {
			LayoutManagerState* state=layout[layer];
			paint|=(widget->flags&WF_PAINT);
			if(WidgetType(widget)==WT_DLIST) {
				paint|=ProcessWidgetList(widget,op,state);
			} else { // simple widget
				if(state->layoutManager(state,widget,op)) {
					state->lastVisible=state->currentIndex;
				}
				++state->currentIndex;
			}
		}
		++widget;
	}
	return paint;
}

static void WidgetPainter(regz StdWidget* widget) {
	if(widget->flags&WF_PAINT) {
		RasterizationCallback rasterizer;
		widget->flags&=~WF_PAINT;
		rasterizer=widget->renderCallback(widget,currentPos->w);
		if(rasterizer) {
			s_int16 x1=currentPos->x;
			s_int16 x2=x1+currentPos->w-1;
			s_int16 y=currentPos->y;
			s_int16 line;
			s_int16 hgt=currentPos->h;
			for(line=0;line<hgt;line++) {
				rasterizer(scanLine,line,currentPos);
				LcdFilledRectangle(x1,y,x2,y,scanLine,0);
				++y;
			}
		}
	}
}

#include <uimessages.h>

void PageFlip(regz s_int16,regz LayoutManagerState*);

void PrevPage(regz StdWidget* widget,regz s_int16 x,regz s_int16 y,regz u_int16 _) {
	PageFlip(-1,layout[widget->data.wt_button.int_p]);
}

void NextPage(regz StdWidget* widget,regz s_int16 x,regz s_int16 y,regz u_int16 hover) {
	u_int16 layer=widget->data.wt_button.int_p;
	LayoutManagerState* lms=layout[layer];
	if(!hover) {
		PageFlip(1,lms);
	}
	if(lms->lastVisible+1>=lms->currentIndex) {
		widget->flags|=WF_DISABLED|WF_PAINT;
	} else {
		widget->flags&=~WF_DISABLED;
		widget->flags|=WF_PAINT;
	}
}

static void WidgetListener(regz StdWidget* widget) {
	if(!widget->userEvent) {
		u_int16 type=widget->msgType;
		if(type==UIMSG_BUT_PREVPAGE) {
			widget->userEvent=PrevPage;
			widget->flags|=WF_DISABLED|WF_PAINT;
			prevPage=widget;
		} else if(type==UIMSG_BUT_NEXTPAGE) {
			widget->userEvent=NextPage;
			nextPage=widget;
			NextPage(widget,0,0,1); // update button states
		}
	} else if(!(widget->flags&WF_DISABLED)) {
		s_int16 x=touchX-currentPos->x;
		s_int16 y=touchY-currentPos->y;
		if(x>=0 && y>=0 && x<currentPos->w && y<currentPos->h) {
			if(focusWidget!=widget) {
				if(focusWidget) {
					focusWidget->flags&=~WF_ACTIVATED;
					focusWidget->flags|=WF_PAINT;
				}
				widget->flags|=WF_ACTIVATED|WF_PAINT;
				focusWidget=widget;
			}
		}
	}
}

void PageFlip(regz s_int16 direction,regz LayoutManagerState* layer) {
	static u_int16 history[32];
	static u_int16 historyPos=0;
	u_int16 c=0;
	if(!layer->firstVisible && historyPos) {
		historyPos=0;
	}
	if(direction>0 && historyPos<sizeof(history)) {
		history[historyPos++]=layer->firstVisible;
		c=layer->lastVisible+1;
	} else if(historyPos) {
		c=history[--historyPos];
		nextPage->flags&=~WF_DISABLED;
		nextPage->flags|=WF_PAINT;
	}
	layer->firstVisible=c;
	ProcessWidgets(currentLayerMask,SetPaintRequest);
	if(layer->firstVisible) {
		prevPage->flags&=~WF_DISABLED;
		prevPage->flags|=WF_PAINT;
	} else {
		prevPage->flags|=WF_DISABLED|WF_PAINT;
	}
}

DLLENTRY(SWCtrlProc)

void* SWCtrlProc(regz SWC cmd,regz s_int16 iparam,regz void* pparam) {
	switch(cmd) {
	case swcGetIconInfo:
		return iconInfo;
	case swcRepaint:
		ProcessWidgets(currentLayerMask,SetPaintRequest);
		break;
	}
	return 0;
}
