/// \author Lasse

#include <string.h>
#include <volink.h>
#include <exec.h>
#include <timers.h>
#include <m3u_playlist.h>
#include "mutex.h"

static u_int16 mutex=0;

#define MAX_NAME_SIZE 256
static char m3uBuffer[MAX_NAME_SIZE];

static u_int16 StepForward(register M3U_PLAYLIST* playlist) {
	FILE* f=playlist->handle;
	if(playlist->current>=0) {
		fgets(m3uBuffer+2,MAX_NAME_SIZE-2,f);
	}
	while(!feof(f)) {
		char c=fgetc(f);
		if(c==-1) {
			return 0;
		}
		if(c=='#') { // skip comment lines
			fgets(m3uBuffer+2,MAX_NAME_SIZE-2,f);
		} else { // found audio file
			fseek(f,-1,SEEK_CUR);
			++playlist->current;
			return 1;
		}
	}
	return 0;
}

static u_int16 FindIndex(register M3U_PLAYLIST* playlist,register s_int16 index) {
	u_int16 rv;
	ObtainMutex(&mutex);
	if(index<playlist->current) {
		fseek(playlist->handle,0,SEEK_SET);
		playlist->current=-1;
	}
	rv=1;
	while(playlist->current<index) {
		if(!StepForward(playlist)) {
			rv=0;
			break;
		}
	}
	ReleaseMutex(&mutex);
	return rv;
}

static void Trim(register char* buffer) {
	// remove trailing line feed & carriage return if present
	char* c=strrchr(buffer,'\n');
	if(c) {
		c[0]=0;
	}
	c=strrchr(buffer,'\r');
	if(c) {
		c[0]=0;
	}

}

static FILE* M3uOpen(register M3U_PLAYLIST* playlist,register s_int16 itemIndex) {
	FILE* rv=0;
	FILE* f;
	u_int32 pos;
	if(!FindIndex(playlist,itemIndex)) {
		return 0;
	}
	ObtainMutex(&mutex);
	f=playlist->handle;
	pos=ftell(f);
	fgets(m3uBuffer+2,MAX_NAME_SIZE-2,f);
	fseek(f,pos,SEEK_SET);
	Trim(m3uBuffer+2);
	rv=fopen(m3uBuffer,"rb");
	ReleaseMutex(&mutex);
	return rv;
}

static u_int16 M3uName(register M3U_PLAYLIST* playlist,register s_int16 itemIndex,register char* buffer,register s_int16 bufferSz) {
	char* c;
	FILE* f;
	u_int32 pos;
	if(!FindIndex(playlist,itemIndex)) {
		buffer[0]=0;
		return 0;
	}
	ObtainMutex(&mutex);
	f=playlist->handle;
	pos=ftell(f);
	fgets(m3uBuffer+2,bufferSz-2,f);
	fseek(f,pos,SEEK_SET);
	Trim(m3uBuffer+2);
	// convert directory separators to '/'
	while((c=strchr(m3uBuffer+2,'\\'))) {
		c[0]='/';
	}
	// try cutting off path preceding the filename
	c=strrchr(m3uBuffer+2,'/');
	if(!c) {
		c=m3uBuffer+2-1;
	}
	strcpy(buffer,c+1);
	ReleaseMutex(&mutex);
	return 1;
}

static s_int16 M3uSize(register M3U_PLAYLIST* playlist) {
	s_int16 rv;
	ObtainMutex(&mutex);
	while(StepForward(playlist)) {
		;
	}
	rv=playlist->current+1;
	ReleaseMutex(&mutex);
	return rv;
}

static void M3uClose(register M3U_PLAYLIST* playlist) {
	Forbid();
	if(playlist->handle) {
		fclose(playlist->handle);
		playlist->handle=0;
	}
	Permit();
}

void init(char* _) {
	InitMutexN(&mutex,1);
}

DLLENTRY(CreateM3uPL) // ENTRY_1

u_int16 CreateM3uPL(register M3U_PLAYLIST* playlist,register char* path) {
	FILE* f;
	Forbid();
	memset(playlist,0,sizeof(M3U_PLAYLIST));
	playlist->a.Size=(PLSIZEMETHOD)M3uSize;
	playlist->a.Name=(PLNAMEMETHOD)M3uName;
	playlist->a.Open=(PLOPENMETHOD)M3uOpen;	
	playlist->a.Delete=(PLRELEASEMETHOD)M3uClose;
	playlist->handle=fopen(path,"r");
	playlist->current=-1;
	m3uBuffer[0]=(path[1]==':')?path[0]:'S';
	m3uBuffer[1]=':';
	Permit();
	return (u_int16)playlist->handle;
}