/// \author Lasse

#include <string.h>
#include <exec.h>
#include <volink.h>
#include <vo_stdio.h>
#include <vo_fat.h>
#include <fat_playlist.h>
#include <timers.h>
#include "mutex.h"

static u_int16 mutex=0;

static u_int16 NextEntry(register FAT_PLAYLIST* playlist,register char* buffer,register s_int16 bufferSz) {
	FILE* f=playlist->handle;
	buffer[0]=0;
	if(playlist->current<0) {
		if(FatFindFirst(f,playlist->path+2/*skip drive letter*/,buffer,bufferSz)!=S_OK) {
			return 0;
		} else while(buffer[0]=='.' && FatFindNext(f,buffer,bufferSz)==S_OK) {
			; // skip "." and ".."
		}
		if(buffer[0]=='.') { // empty directory
			return 0;
		}
	} else if(FatFindNext(f,buffer,bufferSz)!=S_OK) {
		return 0;
	}
	strcpy(playlist->cfn,f->extraInfo);
	playlist->attr=f->ungetc_buffer;
	++playlist->current;	
	return 1;
}

static u_int16 FatName(register FAT_PLAYLIST* playlist,register s_int16 itemIndex,register char* buffer,register s_int16 bufferSz) {
	u_int16 rv;
	ObtainMutex(&mutex);
	if(playlist->handle) {
		if(itemIndex<=playlist->current) {
			playlist->current=-1;
		}
		while(playlist->current<itemIndex) {
			if(!NextEntry(playlist,buffer,bufferSz)) {
				ReleaseMutex(&mutex);
				return 0;
			}
		}
	}
	rv=(playlist->attr&0x10)==0;
	if(bufferSz<20) {
		strcpy(buffer,playlist->cfn);
	}
	ReleaseMutex(&mutex);
	return rv;
}

static FILE* FatOpen(register FAT_PLAYLIST* playlist,register s_int16 itemIndex) {
	char* name=playlist->cfn;
	FatName(playlist,itemIndex,name,19);
	if(name[0]) {
		return fopen(playlist->path,"rb");
	} else {
		return 0;
	}
}

static s_int16 FatSize(register FAT_PLAYLIST* playlist) {
	if(playlist->handle) {
		s_int16 size=playlist->current+1;
		ObtainMutex(&mutex);
		while(NextEntry(playlist,playlist->cfn,19)) {
			++size;
		}
		ReleaseMutex(&mutex);
		return size;
	} else {
		return 0;
	}
}

#include <sysmemory.h>

static void FatClose(register FAT_PLAYLIST* playlist) {
	ObtainMutex(&mutex);
	if(playlist->handle) {
		fclose(playlist->handle);
		playlist->handle=0;
	}
	if(playlist->path) {
		free(playlist->path);
		playlist->path=0;
	}
	ReleaseMutex(&mutex);
}

void init(char* _) {
	InitMutexN(&mutex,1);
}

DLLENTRY(CreateFatPL) // ENTRY_1

u_int16 CreateFatPL(register FAT_PLAYLIST* playlist,register char* path) {
	FILE* f;
	char* bp;
	u_int16 pathLgt;
	ObtainMutex(&mutex);
	memset(playlist,0,sizeof(FAT_PLAYLIST));
	playlist->a.Size=(PLSIZEMETHOD)FatSize;
	playlist->a.Name=(PLNAMEMETHOD)FatName;
	playlist->a.Open=(PLOPENMETHOD)FatOpen;	
	playlist->a.Delete=(PLRELEASEMETHOD)FatClose;
	playlist->current=-1;
	pathLgt=strlen(path);
	bp=malloc(pathLgt+19);
	if(!bp) {
		f=0;
	} else {
		strcpy(bp,path);
		playlist->path=bp;
		playlist->cfn=bp+pathLgt;
		f=fopen(path,"s");
		playlist->handle=f;
	}
	ReleaseMutex(&mutex);
	return (u_int16)f;
}
