/// \author Lasse

#include <string.h>
#include <volink.h>
#include <StdWidget.h>
#include <LibGfx4.h>
#include <swint.h>

#define ICONSIZE 16
#define ICONMAX 6

//#define BIGFONT StdBigFont /* ROM font, Latin-1 character set only. */
#define BIGFONT StdUniFont /* Requires file S:SYS/UNIFONT.DAT. Much better character support but EXTREMELY SLOW. */

static u_int16 iconMemory[(ICONSIZE*ICONSIZE*ICONMAX)/8];

static const u_int16 basicPalette[15]={
	GRAY5(18),GRAY5(10),GRAY5(2), // default (client area) font color
	GRAY5(28),GRAY5(25),GRAY5(22),GRAY5(17), // disabled ("grayed") button
	GRAY5(31),GRAY5(20),GRAY5(10),GRAY5(0), // button in neutral state
 	RGB555(0,12,31),RGB555(10,20,31),RGB555(20,25,31),RGB555(31,31,31), // button in activated ("pressed") state
};

static const u_int16 wallpaperPalette[]={ /* 21 words */
	0xe717,0xded6,0xce75,0xc634,0xbdd3,0xbdd3,0xad72,0xbdd3,0xbdd3,0xad72,0xbdd3,0xad72,0xad72,
	0xad72,0xad72,0xad72,0xad72,0xad72,0xad72,0xad72,0xad72,
};

void ClearWithWallpaper(regz s_int16,regz s_int16,regz s_int16,regz s_int16);

static BtnPos bp={0};
static s_int16 listPadding=0;
static u_int16 fontShadow=1;
static u_int16 backgroundColor=0;

u_int16 ListLayout(regz LayoutManagerState*,regz StdWidget*,regz LMCallback);
u_int16 ToolLayout(regz LayoutManagerState*,regz StdWidget*,regz LMCallback);
u_int16 MenuLayout(regz LayoutManagerState*,regz StdWidget*,regz LMCallback);
u_int16 MsgLayout(regz LayoutManagerState*,regz StdWidget*,regz LMCallback);

void HomeFinish(regz LayoutManagerState*);
void ListFinish(regz LayoutManagerState*);
void ToolFinish(regz LayoutManagerState*);
void MenuFinish(regz LayoutManagerState*);
void FslFinish(regz LayoutManagerState*);

static LayoutManagerState homeLayout={ListLayout,HomeFinish};
static LayoutManagerState listLayout={ListLayout,ListFinish};
static LayoutManagerState toolLayout={ToolLayout,ToolFinish};
static LayoutManagerState menuLayout={MenuLayout,MenuFinish};
static LayoutManagerState msgLayout={MsgLayout,MenuFinish};
static LayoutManagerState fslLayout={ListLayout,FslFinish};

static LayoutManagerState* layerMap[]={
	&homeLayout, /* WL0 */
	&toolLayout, /* WL1 */
	&listLayout, /* WL2 */
	&toolLayout, /* WL3 */
	&fslLayout,  /* WL4 */
	&msgLayout,  /* WL5 */
	&menuLayout, /* WL6 */
	&toolLayout, /* WL7 */
};

static void HomeFinish(regz LayoutManagerState* lms) {
	lms->currentIndex=0;
	listPadding=16;
	ClearWithWallpaper(0,0,RESX,listPadding);
	ClearWithWallpaper(0,lms->size+listPadding,RESX,RESY-40);
}

static void ListFinish(regz LayoutManagerState* lms) {
	lms->currentIndex=0;
	listPadding=0;
	ClearWithWallpaper(0,lms->size,RESX,RESY-40);
}

static void MenuFinish(regz LayoutManagerState* lms) {
	lms->currentIndex=0;
	listPadding=(RESY-lms->size)/2;
}

static void ToolFinish(regz LayoutManagerState* lms) {
	lms->currentIndex=0;
	ClearWithWallpaper(lms->size,RESY-40,RESX,RESY);
}

static void FslFinish(regz LayoutManagerState* lms) {
	lms->currentIndex=0;
	listPadding=0;
	ClearWithWallpaper(0,lms->size,RESX,RESY);
}

void RadialWallpaper(regz u_int16* write,regz s_int16 x,regz s_int16 y,regz s_int16 width) {
	s_int16 yy=y-RESY/2;
	yy*=yy;
	while(width-->0) {
		u_int16 xc=(x-RESX/2);
		u_int16 c=(xc*xc+yy+512)>>10;
		write[0]=wallpaperPalette[(c>>1)+((c*(x^y))&1)];
		++write;
		++x;
	}
}

void SolidColorWall(regz u_int16* write,regz s_int16 x,regz s_int16 y,regz s_int16 width) {
	memset(write,backgroundColor,width);
}

DLLENTRY(Mp3Style)

void Mp3Style(regz LayoutManagerState** lms,regz BtnPos** pbp,regz IconInfo** pii) {
	static const IconInfo basicII={ICONSIZE,ICONSIZE,2,ICONMAX,iconMemory};
	memcpy(lms,layerMap,sizeof(layerMap));
	memcpy(palette4,basicPalette,sizeof(basicPalette));
	wallFunc=RadialWallpaper;
	pbp[0]=&bp;
	pii[0]=&basicII;
}

void ClearWithWallpaper(regz s_int16 x1,regz s_int16 y1,regz s_int16 x2,regz s_int16 y2) {
	static u_int16 buffer[RESX];
	while(y1<y2) {
		wallFunc(buffer,x1,y1,x2-x1);
		LcdFilledRectangle(x1,y1,x2-1,y1,buffer,0);
		++y1;
	}
}

//
// Widget Renderers
//

static wchar* ButtonCaption(regz StdWidget* btn) {
	if(btn->flags&WF_DCAP) {
		return btn->content.captionCallback(btn);
	} else {
		return btn->content.caption;
	}
}

RasterizationCallback RenderListItem(regz StdWidget* btn,regz u_int16 pitch) {
	wchar* caption=ButtonCaption(btn);
	u_int16 flags=btn->flags;
	u_int16 shift;
	memset16(bitCache4,0,RESX*32/4);
	if(flags&WF_ALTSTYLE) {
		RenderText4(caption,8,14,pitch,StdSmallFont);
	} else {
		char* end=strchr((char*)caption,0)-3;
		// concatenate string to fit into the space available
		while(TextWidth4(caption,BIGFONT)>bp.w-8) {
			strcpy(end,"...");
			--end;
		}
		RenderText4(caption,8,8,pitch,BIGFONT);
	}
	shift=0;
	if((flags&WF_DISABLED)==WF_DISABLED) {
		shift=8;
	} else if(flags&WF_ACTIVATED) {
		shift=12;
	}
	if(shift) {
		ColorShift4(shift,0,0,pitch,bp.h,pitch);
	} else if(fontShadow) {
		Shadow4(8,8,pitch-8,16,pitch);
	}
	return Rasterizer4;
}

static void DrawVerticalLine(regz u_int16 x,regz u_int16 y,regz u_int16 hgt,regz u_int16 pitch,regz u_int16 pixelQuad) {
	u_int16* tgt=bitCache4+((x+y*pitch)>>2);
	pitch>>=2;	
	while(hgt-->0) {
		tgt[0]=pixelQuad;
		tgt+=pitch;
	}
}

RasterizationCallback RenderSlider(regz StdWidget* btn,regz u_int16 pitch) {
	static u_int16 colors[]={15,15,14,14,13,12};
	SliderValue* sv=btn->content.sliderValue;
	u_int16 wdt=pitch-32;
	u_int16 x=(sv->current*wdt)/sv->max;
	u_int16 y=(bp.h-16)/2;
	u_int16 i;
	u_int16 o=(pitch-wdt)/2;
	u_int16* c=colors;
	memset16(bitCache4,0,RESX*32/4);
	ColorShift4(7,o,y,wdt,2,pitch);	
	ColorShift4(7,o,y+14,wdt,2,pitch);
	DrawVerticalLine(o-4,y,16,pitch,0x7700);
	DrawVerticalLine(o+wdt,y,16,pitch,0x0077);
	x&=~3; // ColorShift4 coordinates are aligned to 4 pixels
	y+=2;	
	if(x>0 && x<wdt) {
		DrawVerticalLine(o+x,y,12,pitch,0x0066);
	}
	for(i=0;i<12;i+=2) {
		ColorShift4(*c++,o,y,x,2,pitch);
		ColorShift4(6,o+x,y,wdt-x,2,pitch);
		y+=2;
	}
	return Rasterizer4;
}

RasterizationCallback RenderToolButton(regz StdWidget* btn,regz u_int16 pitch) {
	u_int16 bw;
	u_int16 color;
	u_int16 symbol;
	u_int16 flags;
	memset16(bitCache4,0,pitch*bp.h/4);
	symbol=btn->symbol;
	if(symbol) {
		--symbol;
		symbol<<=5;
		RenderIcon4(iconMemory+symbol,(bp.w-ICONSIZE)/2,(36-ICONSIZE)/2,pitch,ICONSIZE);
	} else {
		wchar* caption=ButtonCaption(btn);
		RenderText4(caption,12,(36-16)/2,pitch,StdBigFont);
	}
	bw=pitch-4;
	// the last button is thinner than the others
	if(bp.x+bp.w>=RESX) {
		bw-=4;
	}
	color=8;
	flags=btn->flags;
	if(flags&(WF_ACTIVATED|WF_ALTSTYLE)) {
		color=12;
	} else if(flags&WF_DISABLED) {
		color=4;
	}
	ColorShift4(color,4,0,bw,36,pitch);
	return Rasterizer4;
}

RasterizationCallback RenderMsg(regz StdWidget* btn,regz u_int16 pitch) {
	wchar* caption=ButtonCaption(btn);
	memset16(bitCache4,0,pitch*bp.h/4);
	if(caption) {
		s_int16 x=(bp.w-TextWidth4(caption,StdBigFont))/2;
		RenderText4(caption,x,(bp.h-16)/2,pitch,StdBigFont);
	}
	ColorShift4(12,0,0,bp.w,bp.h,pitch);
	return Rasterizer4;
}

#define MENUWDT 224

//
// Layout Managers
//

u_int16 MenuLayout(regz LayoutManagerState* lms,regz StdWidget* btn,regz LMCallback process) {
	s_int16 index=lms->currentIndex-lms->firstVisible;
	index*=40;
	if(index+40<RESY-40) {
		bp.x=(RESX-MENUWDT)/2;
		bp.y=index+listPadding;
		bp.w=MENUWDT;
		bp.h=40;
		lms->size=index+40;
		if(!btn->renderCallback) {
			btn->renderCallback=RenderToolButton;
		}
		process(btn);
		return 1;
	} else {
		return 0;
	}
}

u_int16 ListLayout(regz LayoutManagerState* lms,regz StdWidget* btn,regz LMCallback process) {
	static u_int16 parity=0;
	//s_int16 index=lms->currentIndex-lms->firstVisible;
	//if(index>=0) {
		s_int16 pos=lms->size;
		if(pos+32>=RESY-40) {
			return 0;
		}
		bp.x=0;	
		bp.y=pos+listPadding;
		bp.h=32;
		if(btn->flags&WF_ALTSTYLE) {
			// this is a small label
			bp.w=48;
			parity=1;
		} else {
			bp.y=pos+listPadding;
			bp.w=parity?RESX-48:RESX;
			bp.x=parity*48;
			parity=0;
			lms->size+=32;
		}
		if(!btn->renderCallback) {
			if(WidgetType(btn)==WT_SLIDER) {
				btn->renderCallback=RenderSlider;
			} else {
				btn->renderCallback=RenderListItem;
			}
		}
		process(btn);
	//	lms->lastVisible=index;
	//}
	return 1;
}

u_int16 ToolLayout(regz LayoutManagerState* lms,regz StdWidget* btn,regz LMCallback process) {
	s_int16 index=lms->currentIndex-lms->firstVisible;
	index*=RESX/4;
	if(index<RESX-40) {
		bp.x=index;
		bp.y=RESY-40;
		bp.w=RESX/4;
		bp.h=40;
		lms->size=index+RESX/4;
		if(!btn->renderCallback) {
			btn->renderCallback=RenderToolButton;
		}
		process(btn);
		return 1;
	} else {
		return 0;
	}
}

u_int16 MsgLayout(regz LayoutManagerState* lms,regz StdWidget* btn,regz LMCallback process) {
	bp.x=(RESX-160)/2;
	bp.y=(RESY-60)/2;
	bp.w=160;
	bp.h=60;
	if(!btn->renderCallback) {
		btn->renderCallback=RenderMsg;
	}
	process(btn);
	return 1;
}

#include <vo_stdio.h>
#include <stdlib.h>

DLLENTRY(LoadColorTheme)

void LoadColorTheme(register FILE* f) {
	u_int16* write=0;
	while(!feof(f)) {
		char c=fgetc(f);
		if(c=='#') {
			static char buffer[7]={0};
			char* c=buffer;
			u_int32 rgb888;
			u_int16 rgb565;
			u_int16 i,r,g,b;
			for(i=0;i<6;i++) {
				c[0]=fgetc(f);
				++c;
			}
			rgb888=strtol(buffer,0,16);
			r=((u_int16)(rgb888>>(16+3-11)))&(0x1f<<11);
			g=((u_int16)(rgb888>>( 8+2- 5)))&(0x3f<< 5);
			b=((u_int16)(rgb888>>( 0+3- 0)))&(0x1f<< 0);
			rgb565=r|g|b;
			if(!write) {
				wallFunc=SolidColorWall;
				backgroundColor=rgb565;
				write=palette4;
			} else {
				write[0]=rgb565;
				++write;
			}
			fontShadow=0;
		}
	}
}