#include <vo_stdio.h>
#include <string.h>
#include "mp3gui.h"
#include <uimessages.h>
#include <apploader.h>

#include <timers.h>

void FixPath(regz wchar*);

static wchar songNameBuffer[32]="N/A";
static wchar artistNameBuffer[32]="N/A";
static wchar albumNameBuffer[32]="N/A";
static wchar playTimeBuffer[8]="0:00:00";
static wchar pathNameBuffer[64]={0};
wchar volumeText[13]="Volume -00";
static wchar playlistPath[]="E:PLAYLIST/";
static wchar musicPath[]="E:MUSIC/";
static wchar themePath[]="E:THEME/";
u_int16 repaint=0;

extern ModelCallback modelCallback;
static BrowserMode browserMode=BM_FOLDER;
static SliderValue progressBar={0/*current value*/,100/*maximum value*/,0/*validator (don't need it)*/};

static FAT_PLAYLIST browser={0};
static FAT_PLAYLIST albumPlaylist={0};
static M3U_PLAYLIST m3uPlaylist={0};
static ABSTRACT_PLAYLIST* currentPlaylist=0;

static void ListItemSelected(regz StdWidget* this,regz s_int16 x,regz s_int16 y,regz u_int16 hover) {
	u_int16 index=this->data.wt_button.int_p;
	wchar* name;
	switch(browserMode) {
	case BM_PLAYLIST:
		strcpy((char*)pathNameBuffer,(char*)playlistPath);
		name=pathNameBuffer+11;
		break;
	case BM_FOLDER:
		strcpy((char*)pathNameBuffer,(char*)musicPath);
		name=pathNameBuffer+8;
		break;
	case BM_COLORTHEME:
		strcpy((char*)pathNameBuffer,(char*)themePath);
		name=pathNameBuffer+8;
		break;
	}
	browser.a.Name(&browser.a,index,name,19);
	if(name[0]) {
		if(browserMode==BM_COLORTHEME) {
			LoadColorTheme(pathNameBuffer);
		} else {
			//
			// build new playlist
			//
			// make sure the model is not using the current playlist, its about to get deleted
			modelCallback(-1,UIMSG_VSOS_SET_CURRENT_PLAYLIST,0L);
			// delete the current playlist
			OpenDirectory(currentPlaylist,0);
			// see which kind of playlist was requested
			if(browserMode==BM_PLAYLIST) {
				currentPlaylist=&m3uPlaylist.a; // M3U
				OpenPlaylist(&m3uPlaylist.a,pathNameBuffer);
			} else { // a FAT directory playlist
				FixPath(name); // convert to uppercase & append slash
				currentPlaylist=&albumPlaylist.a;
				OpenDirectory(&albumPlaylist.a,pathNameBuffer);
			}
			modelCallback(-1,UIMSG_VSOS_SET_CURRENT_PLAYLIST,(u_int32)currentPlaylist);
			modelCallback(-1,UIMSG_BUT_FIRST,0L); // start playing
		}
		// return to home screen
		LoadIconSet(0);
		layerMask=~(LayerMask(WL0)|LayerMask(WL1));
	}
}

static s_int16 DirectoryListing(regz StdWidget* result,regz u_int16 index) {
	browser.a.Name(&browser.a,index,pathNameBuffer,sizeof(pathNameBuffer));
	result->content.caption=pathNameBuffer;
	result->userEvent=ListItemSelected;
	result->data.wt_button.int_p=index;
	if(!pathNameBuffer[0] && !index) {
		strcpy((char*)pathNameBuffer,"<empty list>");
		result->userEvent=0;
	}
	return pathNameBuffer[0];
}

static void PlayButton(regz StdWidget* this,regz s_int16 x,regz s_int16 y,regz u_int16 hover) {
	modelCallback(-1,UIMSG_BUT_PAUSE_TOGGLE,0L);
	this->symbol=3; // assume we paused the playback, change to play icon
	this->flags|=WF_PAINT;
}

static void SimpleButton(regz StdWidget* this,regz s_int16 x,regz s_int16 y,regz u_int16 hover) {
	modelCallback(-1,this->msgType,0L);
}

static void MenuButton(regz StdWidget* this,regz s_int16 x,regz s_int16 y,regz u_int16 hover) {
	layerMask=~(LayerMask(WL6)|LayerMask(WL7));
}

static void BrowserButton(regz StdWidget* this,regz s_int16 x,regz s_int16 y,regz u_int16 hover) {
	browserMode=this->data.wt_button.int_p;
	OpenDirectory(&browser.a,(wchar*)this->data.wt_button.ptr_p);
	LoadIconSet(1); // load browser icon set
	layerMask=~(LayerMask(WL2)|LayerMask(WL3));
}

static void ReturnButton(regz StdWidget* this,regz s_int16 x,regz s_int16 y,regz u_int16 hover) {
	LoadIconSet(0); // load homescreen icon set
	layerMask=~(LayerMask(WL0)|LayerMask(WL1));
}

StdWidget widgetList[]={
	//
	// Homescreen (layer[0]=info | layer[1]=toolbar)
	//
	{WL0|WT_LABEL|WF_ALTSTYLE,0,{"SONG"}},
	{WL0|WT_LABEL,0,{songNameBuffer},0,0,UIMSG_TEXT_SONG_NAME},
	{WL0|WT_LABEL|WF_ALTSTYLE,0,{"ARTIST"}},
	{WL0|WT_LABEL,0,{artistNameBuffer},0,0,UIMSG_TEXT_ARTIST_NAME},
	{WL0|WT_LABEL|WF_ALTSTYLE,0,{"ALBUM"}},
	{WL0|WT_LABEL,0,{albumNameBuffer},0,0,UIMSG_TEXT_ALBUM_NAME},
	{WL0|WT_SLIDER,0,{&progressBar},0,0,UIMSG_U32_PLAY_FILE_PERCENT},
	{WL0|WT_LABEL,0,{playTimeBuffer},0,0,UIMSG_U32_PLAY_TIME_SECONDS},	
	{WL1|WT_BUTTON,1,{"Prev"},SimpleButton,0,UIMSG_BUT_PREVIOUS},
	{WL1|WT_BUTTON,3,{"Play"},PlayButton,0,UIMSG_BUT_PAUSE_TOGGLE},
	{WL1|WT_BUTTON,2,{"Next"},SimpleButton,0,UIMSG_BUT_NEXT},
	{WL1|WT_BUTTON,5,{"List"},MenuButton},
	//
	// File Browser (layer[2]=item list | layer[3]=toolbar)
	//
	{WL2|WT_DLIST,0,{DirectoryListing}},
	{WL3|WT_BUTTON,1,{"Back"},MenuButton},
	{WL3|WT_BUTTON,2,{"Up"},  0,0,UIMSG_BUT_PREVPAGE,{0,WL2}},
	{WL3|WT_BUTTON,3,{"Down"},0,0,UIMSG_BUT_NEXTPAGE,{0,WL2}},
	//
	// Menu (layer[6]=menu overlay | layer[7]=disabled toolbar)
	//
	{WL6|WT_BUTTON,0,{"Albums"},BrowserButton,0,0,{musicPath,BM_FOLDER}},
	{WL6|WT_BUTTON,0,{"Playlist"},BrowserButton,0,0,{playlistPath,BM_PLAYLIST}},
	{WL6|WT_BUTTON,0,{"Color Theme"},BrowserButton,0,0,{themePath,BM_COLORTHEME}},
	{WL6|WT_BUTTON,0,{"Close"},ReturnButton},
	{WL7|WT_BUTTON|WF_DISABLED,1,{"Prev"}},
	{WL7|WT_BUTTON|WF_DISABLED,3,{"Play"}},
	{WL7|WT_BUTTON|WF_DISABLED,2,{"Next"}},
	{WL7|WT_BUTTON|WF_DISABLED,5,{"List"}},
	//
	// layer[5]=volume overlay
	//
	{WL5|WT_BUTTON|WF_ALTSTYLE,0,{volumeText}},
	//
	// (terminate list)
	//
	{WT_END_OF_LIST},
};

void PlayerCallback(s_int16 index,u_int16 message,u_int32 value) {
	StdWidget* update=0;
	switch(message) {
	case UIMSG_VSOS_NO_MORE_FILES:
		strcpy((char*)songNameBuffer,"N/A");
		strcpy((char*)artistNameBuffer,"N/A");
		strcpy((char*)albumNameBuffer,"N/A");
		strcpy((char*)playTimeBuffer,"0:00:00");
		repaint=1; // signal main loop to perform a repaint of the interface
		break;
	case UIMSG_TEXT_LONG_FILE_NAME:
		message=UIMSG_TEXT_SONG_NAME;
		strcpy((char*)artistNameBuffer,"N/A");
		strcpy((char*)albumNameBuffer,"N/A");
		// (fall through)
	case UIMSG_TEXT_SONG_NAME:
	case UIMSG_TEXT_ARTIST_NAME:
	case UIMSG_TEXT_ALBUM_NAME:
		update=FindButtonByMsg(message);
		if(update) {
			s_int16 lgt=strlen((char*)value);
			u_int16* caption=update->content.caption;
			if(lgt>31) {
				lgt=31;
			}
			caption[lgt]=0;
			memcpy(caption,(wchar*)value,lgt);
			update->flags|=WF_PAINT;
		}
		break;
	case UIMSG_U32_PLAY_FILE_PERCENT:
		update=FindButtonByMsg(message);
		progressBar.current=(u_int16)value;
		update->flags|=WF_PAINT;
		update=FindButtonByMsg(UIMSG_BUT_PAUSE_TOGGLE);
		update->symbol=4; // we're playing; show a pause symbol
		update->flags|=WF_PAINT;
		break;
	case UIMSG_U32_PLAY_TIME_SECONDS: 
		update=FindButtonByMsg(message);
		if(update) {
			u_int16 secs=(u_int16)value;
			u_int16 mins=secs/60;
			u_int16 hours=secs/(60*60);
			secs-=mins*60;
			mins-=hours*60;
			playTimeBuffer[0]=hours+'0';
			playTimeBuffer[2]=(mins/10)+'0';
			playTimeBuffer[3]=(mins%10)+'0';
			playTimeBuffer[5]=(secs/10)+'0';
			playTimeBuffer[6]=(secs%10)+'0';
			update->flags|=WF_PAINT;
			if(!repaint) {
				repaint=1;
			}
		}
		break;
	}
}

// FixPath: convert to uppercase and add a trailing '/'

static void FixPath(regz wchar* s) {
	wchar c;
	while((c=s[0])) {
		if(c>='a' && c<='z') {
			s[0]=c+('A'-'a');
		}
		++s;
	}
	if(s[-1]!='/') {
		s[0]='/';
		s[1]=0;
	}
}

void ChangeDrive(regz wchar drive) {
	playlistPath[0]=drive;
	musicPath[0]=drive;
	themePath[0]=drive;
}
