#ifndef MP3GUI_H
#define MP3GUI_H

#include <StdWidget.h>
#include <fat_playlist.h>
#include <m3u_playlist.h>
#include <uimessages.h>
#include <exec.h> // Forbid/Permit

extern u_int16 layerMask;
extern StdWidget widgetList[];
extern IconInfo* iconInfo;
extern u_int16 repaint;

typedef void (*ModelCallback)(s_int16,u_int16,u_int32);
#define GetModelCallback(lib) (*(((ModelCallback*)(lib))+2+ENTRY_1))

void PlayerCallback(s_int16 index,u_int16 message,u_int32 value);
StdWidget* FindButtonByMsg(regz u_int16);
void OpenDirectory(regz ABSTRACT_PLAYLIST* playlist,regz wchar* path);
void OpenPlaylist(regz ABSTRACT_PLAYLIST* playlist,regz wchar* path);
void LoadIconSet(regz u_int16 index);
void LoadColorTheme(regz wchar* name);
void ChangeDrive(regz wchar drive);

typedef enum BrowserMode { BM_FOLDER=0,BM_PLAYLIST=1,BM_COLORTHEME=2 } BrowserMode;

typedef void (*ColorThemeLoader)(register FILE*);
#define GetColorThemeLoader(lib) (*(((ColorThemeLoader*)(lib))+2+ENTRY_2))

#endif