/// \author Lasse

#include <apploader.h>
#include <string.h>
#include "mp3gui.h"

#include <vo_stdio.h>
#include <timers.h>
#include <vo_gpio.h>

void AdjustVolume();

// default visible layers
u_int16 layerMask=~(LayerMask(WL0)|LayerMask(WL1));

ModelCallback modelCallback;

static void* libStdWidget=0;
static void* libFatPlaylist=0;
static void* libM3uPlaylist=0;
static void* libSWStyle=0;

void MainLoop() {
	while(1) {
		AdjustVolume();
		SWUpdate(libStdWidget,layerMask,widgetList);
		if(repaint) {
			repaint=0;
			SWCtrl(libStdWidget,swcRepaint,0,0);
		}
		Delay(1);
	}
}

int main() {
	StyleManager mp3Style;
	// load audio playback module
	void* libModel=LoadLibrary("MP3MODEL");
	// load UI style manager
	libSWStyle=LoadLibrary("MP3STYLE");
	mp3Style=SWSGet(libSWStyle);
	// load UI framework
	libStdWidget=LoadLibrary("STDWDGT");
	// load FAT directory interface
	libFatPlaylist=LoadLibrary("PLFAT");
	// obtain modelCallback (which is used to communicate with audio model)
	modelCallback=GetModelCallback(libModel);
	// very basic error checking
	if(!libSWStyle || !libStdWidget || !libFatPlaylist || !mp3Style) {
		fprintf(stderr,"Required library not found\n");
	} else {
		static const IconInfo expectedIconType={16,16,2,6};
		// initialize the UI library
		SWInit(libStdWidget,mp3Style,0);
		// since we use bitmap icons, ask which format the UI style manager expects
		iconInfo=SWCtrl(libStdWidget,swcGetIconInfo,0,0);
		// check that our icons are compatible
		if(memcmp(&expectedIconType,iconInfo,sizeof(IconInfo)-1)) {
			fprintf(stderr,"Unsupported icon resource type requested\n");
			return -2;
		} else { // provide audio model with a callback to us
			u_int16 drive=PERIP(SW_REG0);
			modelCallback(-1,UIMSG_VSOS_SET_CALLBACK_FUNCTION,(u_int32)PlayerCallback);
			// load default icon set
			LoadIconSet(0);
			if(drive>='A' && drive<='Z') {
				ChangeDrive(drive);
			}
			// launch the UI
			MainLoop();
		}
	}
	// clean up
	DropLibrary(libM3uPlaylist);
	DropLibrary(libFatPlaylist);
	DropLibrary(libStdWidget);
	DropLibrary(libSWStyle);
	DropLibrary(libModel);
	return 0;
}

StdWidget* FindButtonByMsg(regz u_int16 msg) {
	StdWidget* w=widgetList;
	while(w->flags!=WT_END_OF_LIST) {
		if(w->msgType==msg) {
			return w;
		}
		++w;
	}
	return 0;
}

void OpenDirectory(regz ABSTRACT_PLAYLIST* playlist,regz wchar* path) {
	if(playlist->Delete) {
		playlist->Delete(playlist);
		memset(playlist,0,sizeof(ABSTRACT_PLAYLIST));
	}
	if(path) {
		CreateCommonPlaylist(libFatPlaylist,playlist,path);
		playlist->flags|=PF_AUTOADVANCE;
	}
}

void OpenPlaylist(regz ABSTRACT_PLAYLIST* playlist,regz wchar* fileName) {
	if(!libM3uPlaylist) {
		libM3uPlaylist=LoadLibrary("PLM3U");
	}
	if(libM3uPlaylist) {
		CreateCommonPlaylist(libM3uPlaylist,playlist,fileName);
		playlist->flags|=PF_AUTOADVANCE;
	} else {
		printf("Error: could not load PLM3U\n");
	}
}

void LoadColorTheme(regz wchar* fileName) {
	FILE* f=fopen((char*)fileName,"r");
	if(f) {
		// see if style manager supports color themes
		ColorThemeLoader loader=GetColorThemeLoader(libSWStyle);
		if(loader) { // load the color theme if it does
			loader(f);
		}
		fclose(f);
	}
}

extern wchar volumeText[];

//
// AdjustVolume polls buttons S2 and S3 for volume up/down events
// and displays a text box overlay to indicate the new volume level
// (if no key is pressed, it returns immediately)
//
void AdjustVolume() {
	static s_int16 volume=0;
	u_int16 counter=1;
	u_int16 timeoutPeriod=150; // key repeat time
	while(counter>0) {
		u_int16 keyPressed=0;
		if(counter<80) {
			if(GpioReadPin(0x03)) {
				RunLibraryFunction("LIBINFO",ENTRY_MAIN,0);
			}
			if(GpioReadPin(0x01)) {
				volume+=1;
				keyPressed=1;
			} else if(GpioReadPin(0x02)) {
				volume-=1;
				keyPressed=1;
			}
			if(volume<0) {
				volume=0;
			} else if(volume>50) {
				volume=50;
			}
		} else if(GpioReadPin(0x01)+GpioReadPin(0x02)==0) {
			counter=80;
		}
		if(keyPressed) {
			counter=timeoutPeriod;
			timeoutPeriod=100;
			// apply the new volume level
			SystemUiMessage(0,UIMSG_S16_SET_VOLUME,volume*2);
			// draw volume message
			sprintf((char*)volumeText,"Volume -%02d",volume);
			SWUpdate(libStdWidget,~LayerMask(WL5),widgetList);
			SWCtrl(libStdWidget,swcRepaint,0,0);
		} else {
			--counter;
			if(!counter) {
				return;
			}			
			Delay(5);
		}
	}
}