/// \author Lasse

#include <apploader.h>
#include <StdWidget.h>
#include <timers.h>
#include <stdlib.h>
#include <lcd.h>

static void* libStdWidget=0;
static void* libSWStyle=0;
extern StdWidget widgetList[];
static u_int16 appRunning=1;
static char driveList[26]="";

void DetectDrives() {
	char* result=driveList;
	u_int16 i;
	for(i=0;i<26;i++) {
		if(vo_pdevices[i] && vo_pdevices[i]->fs==vo_filesystems[0]) { //FAT
			result[0]=i+'A';
			++result;
		}
	}
}

void MainLoop() {
	while(appRunning) {
		SWUpdate(libStdWidget,0,widgetList);
		Delay(1);
	}
}

int main() {
	StyleManager mp3Style;
	// load UI style manager
	libSWStyle=LoadLibrary("MP3STYLE");
	mp3Style=SWSGet(libSWStyle);
	// load UI framework
	libStdWidget=LoadLibrary("STDWDGT");
	// load FAT directory interface
	if(!libSWStyle || !libStdWidget || !mp3Style) {
		fprintf(stderr,"Required library not found\n");
	} else {
		static const IconInfo expectedIconType={16,16,2,6};
		DetectDrives();
		// initialize the UI library
		SWInit(libStdWidget,mp3Style,0);
		// wait for user input
		MainLoop();
	}
	// clean up
	DropLibrary(libStdWidget);
	DropLibrary(libSWStyle);
	return 0;
}

static void ItemSelected(regz StdWidget* this,regz s_int16 x,regz s_int16 y,regz u_int16 hover) {
	PERIP(SW_REG0)=this->data.wt_button.int_p;
	fclose(appFile);
	appFile=fopen("S:MP3GUI.AP3","rb");
	appRunning=0;
	lcd0.backgroundColor=COLOR_BLACK; // prevent blue screen flash
}

static s_int16 DriveListItem(regz StdWidget* result,regz u_int16 index) {
	static wchar driveName[64];
	char drive=driveList[index];
	if(drive) {
		u_int16 i=drive-'A';
		sprintf((char*)driveName,"[%c]: %s",drive,vo_pdevices[i]->Identify(vo_pdevices[i],NULL,0));
		result->content.caption=driveName;
		result->userEvent=ItemSelected;
		result->data.wt_button.int_p=drive;
		return 1;
	} else {
		return 0;
	}
}

StdWidget widgetList[]={
	{WL4|WT_BUTTON|WF_DISABLED,0,{"Please Select"}},
	{WL4|WT_DLIST,0,{DriveListItem}},
	{WT_END_OF_LIST},
};