/// \author Lasse

#include <StdWidget.h>
#include <LibGfx4.h>
#include <swint.h>
#include <ctype.h>

extern const u_int32 font16a[];
extern const u_int16 font16aptrs[];
extern __y u_int16 latin1[];

u_int16 bitCache4[2560]; // the main graphics buffer (4-bit pixel data)
u_int16 palette4[15]; // color data
WallFunc wallFunc=0; // wallpaper renderer

s_int16 StdBigFont(regz u_int16* tgt,regz u_int16 mod4,regz wchar letter,regz u_int16 pitch) {
	s_int16 offset;
	s_int16 wdt;
	if (!isprint(letter)) letter='.';
	offset=font16aptrs[letter];
	wdt=font16aptrs[letter+1]-offset;
	if(tgt) {
		const u_int32* glyph=font16a+offset;
		s_int16 i;
		mod4<<=2;
		for(i=0;i<wdt;i++) {
			u_int16* write=tgt;
			u_int32 column=glyph[0];
			u_int16 row;
			++glyph;
			for(row=0;row<16;row++) {
				write[0]|=((u_int16)column&3)<<mod4;
				column>>=2;
				write+=pitch;
			}
			mod4+=4;
			if(mod4>=16) {
				mod4=0;
				++tgt;
			}
		}
	}
	return wdt+1;
}

s_int16 StdSmallFont(regz u_int16* tgt,regz u_int16 mod4,regz wchar letter,regz u_int16 pitch) {
	if(tgt) {
		const __y u_int16* glyph=latin1+letter*3;
		u_int16 i;
		u_int16 p1=1;
		u_int16 p2=1;
		mod4<<=2;
		switch(letter) {
		case 'l':
		case 'i':
		case 'L':
		case 'T':
			--p2;
			break;
		case 'm':
		case 'w':
		case 'I':
			p1=3;
			p2=2;
			break;
		}
		for(i=0;i<3;i++) {
			u_int16 column=glyph[0];
			u_int16 c;
			++glyph;
			column=(column>>8)|(column<<8);
			for(c=0;c<2;c++) {
				u_int16* write=tgt;
				u_int16 row;
				
				for(row=0;row<8;row++) {
					u_int16 bit=column&1;
					column>>=1;
					bit*=3;
					write[0]|=bit<<mod4;
					write+=pitch;
				}
				if(i!=p1 || c==p2) {
					mod4+=4;
				}
				if(mod4>=16) {
					mod4=0;
					++tgt;
				}
			}
		}
	}
	return 6;
}

void RenderText4(regz wchar* string,regz s_int16 x,regz s_int16 y,regz u_int16 pitch,regz FontStyle font) {
	u_int16* tgt;
	pitch>>=2;
	tgt=bitCache4+y*pitch;
	while(string[0]) {
		x+=font(tgt+(x>>2),x&3,string[0],pitch);
		++string;
	}
}

s_int16 TextWidth4(regz wchar* string,regz FontStyle font) {
	s_int16 w=0;
	while(string[0]) {
		w+=font(0,0,string[0],0);
		++string;
	}
	return w;
}

void RenderIcon4(regz u_int16* data,regz s_int16 x,regz s_int16 y,regz u_int16 pitch,regz u_int16 size) {
	u_int16* tgt;
	u_int16 mod4=0;
	u_int16 col;
	pitch>>=2;
	x>>=2;
	tgt=bitCache4+x+y*pitch;
	col=size;
	while(col-->0) {
		u_int16 block=size;
		u_int16* write=tgt;
		while(block>0) {
			u_int16 column=data[0];
			u_int16 row;
			++data;
			for(row=0;row<8;row++) {
				write[0]|=(column&3)<<mod4;
				column>>=2;
				write+=pitch;
			}
			block-=8;
		}
		mod4+=4;
		if(mod4>=16) {
			mod4=0;
			++tgt;
		}
	}
}

void ColorShift4(regz s_int16 amount,regz s_int16 x,regz s_int16 y,regz u_int16 w,regz u_int16 h,regz u_int16 pitch) {
	u_int16* tgt;
	amount|=amount<<4;
	amount|=amount<<8;
	x>>=2;
	w>>=2;
	pitch>>=2;
	tgt=bitCache4+(x+(y*pitch));	
	pitch-=w;
	while(h-->0) {
		u_int16 i;
		for(i=0;i<w;i++) {
			tgt[0]+=amount;
			++tgt;
		}
		tgt+=pitch;
	}
}

void Shadow4(regz s_int16 x,regz s_int16 y,regz u_int16 w,regz u_int16 h,regz u_int16 pitch) {
	u_int16* write;
	u_int16* read;
	x>>=2;
	w>>=2;
	pitch>>=2;
	write=bitCache4+(x+(y+h)*pitch);
	read=write-pitch;
	pitch+=w;
	while(h-->0) {
		u_int16 i;
		for(i=0;i<w;i++) {
			u_int16 c=write[0]<<1;
			u_int16 r=read[0];
			c|=c<<1;
			r|=r<<1;
			write[0]|=((r<<1)&((~c)&0x4444));
			++write;
			++read;
		}
		write-=pitch;
		read-=pitch;
	}
}

//
// Rasterizer4: produces a row of RGB565 pixels based on 4-bit values in bitCache4[]
//
void Rasterizer4(regz u_int16* target,regz s_int16 line,regz BtnPos* pos) {
	u_int16* bits;
	s_int16 width=pos->w;
	s_int16 x;	
	if(wallFunc) {
		wallFunc(target,pos->x,pos->y+line,width);
	}
	width>>=2;
	bits=bitCache4+line*width;
	for(x=0;x<width;x++) {
		u_int16 b=(*bits++);
		u_int16 pixel;
		for(pixel=0;pixel<4;pixel++) {
			u_int16 b4=b&15;
			if(b4) {
				target[0]=(palette4-1)[b4];
			}
			++target;
			b>>=4;
		}
	}
}
