/**
   \file usb.h Miscellaneous USB-related definitions. Not all seem to be VS1000-related.
*/
#ifndef USB_H
#define USB_H

#define USB_SET_ADDRESS_ENA	0xD0
#define USB_SET_ENDP_ENA	0xD8
#define USB_SET_MODE		0xF3
#define USB_SET_DMA		0xFB
#define USB_READ_INT		0xF4
#define USB_SELECT_ENDP_CO	0x00
#define USB_SELECT_ENDP_CI	0x01
#define USB_SELECT_ENDP_E1O	0x02
#define USB_SELECT_ENDP_E1I	0x03
#define USB_SELECT_ENDP_E2O	0x04
#define USB_SELECT_ENDP_E2I	0x05
#define USB_ENDP_ST_CO		0x40
#define USB_ENDP_ST_CI		0x41
#define USB_ENDP_ST_E1O		0x42
#define USB_ENDP_ST_E1I		0x43
#define USB_ENDP_ST_E2O		0x44
#define USB_ENDP_ST_E2I		0x45
#define USB_ACCESS_BUF		0xF0
#define USB_ACK_SETUP		0xF1
#define USB_CLEAR_BUF		0xF2
#define USB_VALIDATE_BUF	0xFA
#define USB_SEND_RESUME		0xF6
#define USB_READ_FRAME_NUMBER	0xF5

#define D12_INT_EOT		0x100
#define D12_INT_SUSPENDCHANGE	0x80
#define D12_INT_BUSRESET	0x40
#define D12_INT_ENDP2IN		0x20
#define D12_INT_ENDP2OUT	0x10
#define D12_INT_ENDP1IN		0x08
#define D12_INT_ENDP1OUT	0x04
#define D12_INT_ENDP0IN		0x02
#define D12_INT_ENDP0OUT	0x01

#define	USB_ENDPOINT_HALT	0
#define USB_ENDPOINT_DIRECTION_MASK	0x80
#define USB_MAX_ENDPOINTS 		0x03



#define D12_FULLEMPTY		0x01
#define D12_STALL		0x02

#define D12_SETUPPACKET		0x20

#define EP0_TX_FIFO_SIZE	16
#define EP0_RX_FIFO_SIZE	16
#define EP0_PACKET_SIZE		16

#define EP1_TX_FIFO_SIZE	16
#define EP1_RX_FIFO_SIZE	16
#define EP1_PACKET_SIZE		16

#define EP2_TX_FIFO_SIZE	64
#define EP2_RX_FIFO_SIZE	64
#define EP2_PACKET_SIZE		64


#define USB_REQUEST_MASK 0x0F
#define USB_REQUEST_GET_STATUS		0x00
#define USB_REQUEST_CLEAR_FEATURE	0x01
#define USB_REQUEST_SET_FEATURE		0x03
#define USB_REQUEST_SET_ADDRESS		0x05
#define USB_REQUEST_GET_DESCRIPTOR	0x06
#define USB_REQUEST_SET_DESCRIPTOR	0x07
#define USB_REQUEST_GET_CONFIGURATION	0x08
#define USB_REQUEST_SET_CONFIGURATION	0x09
#define USB_REQUEST_GET_INTERFACE	0x0A
#define USB_REQUEST_SET_INTERFACE	0x0B
#define USB_REQUEST_SYNC_FRAME		0x0C

#define USB_REQUEST_TYPE_MASK 0x60
#define USB_STANDARD_REQUEST		0x00
#define USB_INTERFACE_REQUEST	        0x01
#define USB_ENDPOINT_REQUEST	        0x02

#define USB_CLASS_REQUEST		0x20
#define USB_VENDOR_REQUEST		0x40

#define USB_DEVICE_DESCRIPTOR_TYPE	0x01
#define USB_CONFIGURATION_DESCRIPTOR_TYPE	0x02
#define USB_STRING_DESCRIPTOR_TYPE	0x03
#define USB_INTERFACE_DESCRIPTOR_TYPE	0x04
#define USB_ENDPOINT_DESCRIPTOR_TYPE	0x05
#define USB_POWER_DESCRIPTOR_TYPE	0x06

#define USB_CLASS_CODE_TEST_CLASS_DEVICE	0xDC
#define USB_SUBCLASS_CODE_TEST_CLASS_D12	0xA0
#define USB_PROTOCOL_CODE_TEST_CLASS_D12	0xB0

#define USB_RECIPIENT			0x1f
#define USB_RECIPIENT_DEVICE		0x00
#define USB_RECIPIENT_INTERFACE		0x01
#define USB_RECIPIENT_ENDPOINT		0x02

#define USB_SP_REQUEST 0
#define USB_SP_VALUE 1
#define USB_SP_INDEX 2
#define USB_SP_LENGTH 3


#endif
