#ifndef STANDALONE_H
#define STANDALONE_H

#define STANDALONE

#define USE_HC

#ifdef VS1053
#include <h1053/vsmpg.h>
#include <h1053/hardware.h>
#include <h1053/common.h>
#include <h1053/asmfuncs.h>
#include <h1053/parametric.h>
#endif

#include <vstypes.h>
auto s_int16 myrand(void); /* output 0..0x3fff */
extern __y s_int16 rand_seed;

#include "fat.h"

#ifdef USE_HC
extern s_int16 hcShift;
#endif

void SpiLoad(register __i2 short startAddr);

void MyReset();

auto void SpiSendClocks(void);
auto u_int16 SpiSendReceiveMmc(register __a0 u_int16 topAlignedData,
			       register __a1 numBits);
auto u_int16 MmcCommand(register __b0 s_int16 cmd, register __d u_int32 arg);
auto void ReadDiskSector(register __a u_int32 sector);
auto void WritePhysicalSectorY(register __d u_int32 sector,
			      register __i3 __y u_int16 *dataBufPtr);
auto void WritePhysicalSectorYSwap(register __d u_int32 sector,
			      register __i3 __y u_int16 *dataBufPtr);
auto u_int16 GetByte(register __c0 u_int16 n);
auto u_int16 GetWord(register __c0 u_int16 n);
auto u_int32 GetLong(register __c0 u_int16 n);
auto u_int16 InitFileSystem(void);
auto u_int16 InitFileSystemR(void);
auto __y struct FRAGMENT *FragmentList(register __i2 __y struct FRAGMENT *frag,
			  register __b u_int32 fatCluster);
auto s_int16 HandleDir(register __i2 __y struct FRAGMENT *curFragment,
		       __y struct FRAGMENT *nextFragment);
auto s_int16 OpenFile(register __c0 u_int16 fileNum);
auto s_int16 CheckFileType(register __a u_int32 name);
auto s_int16 CheckFileType1003(register __a u_int32 name);
auto s_int16 CheckFileType1003Nw(register __a u_int32 name);
auto s_int16 CheckFileType1023(register __a u_int32 name);
auto s_int16 CheckFileType1033(register __a u_int32 name);
auto s_int16 CheckFileType1053(register __a u_int32 name);
auto s_int16 CheckFileType1103(register __a u_int32 name);

s_int16 RecordMode(void);
u_int16 SciModeOr(void);

extern u_int16 created[3]; /*create date, time, 100ths */

int UartFill(void);
int UartGetByte(void);
int UartPeekByte(void);

u_int16 Shuffle(register __c0 u_int16 files, register __c1 u_int16 old);

#endif/*STANDALONE_H*/
