#include <stdio.h>
#include <string.h>
#include <stdlib.h>

unsigned char header[512] = { /* RIFF WAV header */
    0x52,0x49,0x46,0x46,0xF8,0x8F,0x06,0x00,0x57,0x41,0x56,0x45,
    0x66,0x6D,0x74,0x20,0x14,0x00,0x00,0x00,0x11,0x00,0x01,0x00,
    0x80,0x3E,0x00,0x00,0xD7,0x0F,0x00,0x00,0x00,0x01,0x04,0x00,
    0x02,0x00,0xF9,0x01,0x66,0x61,0x63,0x74,0xC8,0x01,0x00,0x00,
    0x1E,0xEE,0x0C,0x00  /* the rest are zeros */
};

long GetSeconds(char *s, char **sc) {
    long secs = 0;
    while (1) {
	secs += strtol(s, sc, 10);
	if (**sc != ':')
	    return secs;
	/* if it was minutes (or hours even..) */
	secs *= 60;
	s = *sc + 1;
    }
}

void FixVal(unsigned char *s, unsigned long val) {
    s[0] = (unsigned char)val;
    s[1] = (unsigned char)(val>>8);
    s[2] = (unsigned char)(val>>16);
    s[3] = (unsigned char)(val>>24);
}

int main(int argc, char *argv[]) {
    unsigned long fs = 8000, size = 2048*1024, dataSize, nSamp, tim = 0;
    int n;
    FILE *fp;
    for (n = 1; n < argc; n++) {
	char *err = NULL;
	if (!strcmp(argv[n], "-f")) {
	    fs = strtol(argv[++n], &err, 0);
	} else if (!strcmp(argv[n], "-s")) {
	    size = strtoul(argv[++n], &err, 0) & ~511L;
	} else if (!strcmp(argv[n], "-t")) {
	    tim = GetSeconds(argv[++n], &err);
	} else {
	    fprintf(stderr, "Usage: %s [-f <rate>] [-s <size>] [-t <time>]\n",
		    argv[0]);
	    fprintf(stderr, "Example: %s -t 5:30\n", argv[0]);
	    return EXIT_FAILURE;
	}
	if (err && *err)
	    fprintf(stderr, "Invalid number '%s'\n", argv[n]);
    }
    if (tim) {
	fprintf(stderr, "%ld seconds\n", tim);
	size = ((long)(tim * (fs * 256/505.0)) + 511) & ~511L;
    }
    dataSize = size - 512;
    nSamp = dataSize / 256 * 505;

    fprintf(stderr, "Rate: %ld Hz, Size: %lu, Byte rate: %ld\n",
	    fs, size, fs*128/505);
    fprintf(stderr, "Number of samples %lu, Duration %6.2f seconds\n",
	    nSamp, (double)nSamp/fs);

    FixVal(header+4, size-8); /* chunk size = file size - 8 */
    FixVal(header+24, fs);    /* sample rate */
    FixVal(header+28, fs*256/505); /* byte rate */
    FixVal(header+48, nSamp); /* number of samples */
    FixVal(header+504, 0x61746164); /* "data" in little-endian format */
    FixVal(header+508, dataSize);   /* data size = file size - 512 */

    if ((fp = fopen("VSRECORD.WAV", "wb"))) {
	unsigned char zero[512] = {0};
	fwrite(header, 512, 1, fp);
	if (fseek(fp, dataSize, SEEK_SET) == 0) {
	    fwrite(zero, 512, 1, fp); /* Seek successful, write last block */
	} else {
	    while ((size -= 512) > 0) /* Failed, write as much as possible */
		fwrite(zero, 512, 1, fp);
	}
	fclose(fp);
	fprintf(stderr, "Created VSRECORD.WAV\n");
	return EXIT_SUCCESS;
    }
    fprintf(stderr, "Could not open VSRECORD.WAV for writing!\n");
    return EXIT_FAILURE;
}
