
#ifndef VS_NAND_H
#define VS_NAND_H

#include <vstypes.h>
#include <stdlib.h>
#include <physical.h>

/** Nand Flash Opcode: */
#define NAND_OP_ 0x

/** Nand Flash Opcode: Read Signature*/
#define NAND_OP_READ_SIGNATURE 0x90

/** Nand Flash Opcode: Read Signature*/
#define NAND_OP_READ_STATUS 0x70

/** Nand Flash Opcode: Read A*/
#define NAND_OP_READ_A 0x00

/** Nand Flash Opcode: Read C*/
#define NAND_OP_READ_C 0x50

/** Nand Flash Opcode: Commit read address */
#define NAND_OP_COMMIT_DATA_ADDRESS 0x30

/** Nand Flash Opcode: Prepare to Program*/
#define NAND_OP_PREPARE_TO_PROGRAM 0x80

/** Nand Flash Opcode: Execute Programming*/
#define NAND_OP_PERFORM_PROGRAM 0x10


struct FsNandPhys {
  /** Physical basic structure */
  struct FsPhysical p;
  /* Custom fields follow */
  u_int16 nandType;
  u_int16 waitns; /* wait in ns */
  //  u_int16 nandTmp[8];
};

/** Erase the block that starts from page "block". */
s_int16 FsPhNandErase(struct FsPhysical *p, s_int32 block);

/** Creates a physical layer. */
struct FsPhysical *FsPhNandCreate(u_int16 param);

/** Free resources allocated by FsPhNandCreate and release HW */
s_int16 FsPhNandDelete(struct FsPhysical *p);

/** Free hardware bus for possible other devices */
s_int16 FsPhNandFreeBus(struct FsPhysical *p);

/** Reinitialize bus */
s_int16 FsPhNandReinitialize(struct FsPhysical *p);

/** Read pages. */
s_int16 FsPhNandRead(struct FsPhysical *p, s_int32 firstPage,
		     u_int16 pages, u_int16 *data, u_int16 *meta);

/** Write pages */
s_int16 FsPhNandWrite(struct FsPhysical *p, s_int32 firstPage,
		      u_int16 pages, u_int16 *data, u_int16 *meta);

/** Support: Count bits */
s_int16 NandCountBits(register __a u_int32 val);
s_int16 NandMingle(register __a u_int32 val);
void NandSwapBad(register __i0 u_int16 *spare);
void NandWaitIdle(void);

#endif
