#ifndef __PLAYER_H__
#define __PLAYER_H__

#include <vstypes.h>

void putch(register __a0 short dat);

extern s_int16 tmpBuf[2*32];

extern struct Player {
    s_int16 totalFiles;
    s_int16 currentFile;
    s_int16 nextFile;
    s_int16 nextStep; /* 1 = next file, -1 = previous file */
    s_int16 pauseOn;
    s_int16 randomOn;
    s_int16 volume;
    s_int16 volumeOffset;
    u_int16 offDelay; /* pause timeout in 5 sec increments -> power off */
    u_int16 ffCount;
    u_int16 maxClock; /* max clock used by player: 7=3.5x, 6=3.0x etc.. */
} player;

#define LED1 4 //SI
#define LED2 8 //SO

enum keyEvent {
  ke_null = 0,
  ke_previous,
  ke_next,
  ke_rewind,
  ke_forward,
  ke_volumeUp,   /* +0.5dB */
  ke_volumeDown, /* -0.5dB */
  ke_earSpeaker, /* 0, 16000U, 38000U, 54000U */
  ke_earSpeakerToggle, /* 0, 38000U */
  ke_randomToggle,
  ke_randomToggleNewSong,
  ke_pauseToggle,
  ke_powerOff,
  ke_ff_faster,  /* increase play speed */
  ke_ff_slower,  /* decrease play speed */
  ke_ff_off,     /* back to normal play speed */
  ke_volumeUp2,  /* +1.0dB */
  ke_volumeDown2,/* -1.0dB */
};

struct KeyMapping {
  u_int16 key;
  enum keyEvent event;
};
extern const struct KeyMapping *currentKeyMap;
extern const struct KeyMapping sixKeyMap[];
extern const struct KeyMapping fiveKeyMap[];
extern const struct KeyMapping shiftFourKeyMap[];
extern const struct KeyMapping threeKeyMap[];

#define KEY_1 1 /* prev/vol down     -> vol down 1 / vol down */
#define KEY_2 2 /* random/earspeaker -> vol up 1   / vol up */
#define KEY_3 4 /* next/vol up       -> prev / rew */
#define KEY_4 8 /*                   -> next / ff */
#define KEY_5 16 /*                  -> earspeaker / random */
#define KEY_POWER 256 /* pause / power off/on */
#define KEY_RELEASED   0x4000
#define KEY_LONG_PRESS 0x8000
#define KEY_LONG_ONESHOT 0x8000

extern u_int16 keyOld;
extern s_int16 keyOldTime;
#define SHORT_LIMIT 16
#define OFF_LIMIT 32


extern __y u_int16 mallocAreaY[]; /* for ramdisk */
extern u_int16 mallocAreaX[];     /* for ramboot */

extern const u_int32 *supportedFiles;
extern const u_int32 defSupportedFiles[];


/*
  Function Prototypes
 */

auto void CleanDisk(register __c1 u_int16 tryBoot);
void PlayerVolume(void);
auto u_int16 USBIsAttached(void);
auto void MassStorage(void);
auto void RealMassStorage(void);
void KeyEventHandler(enum keyEvent event);
void RealKeyEventHandler(enum keyEvent event);
auto u_int16 ReadGPIO(void);
void USBSuspend(u_int16 timeOut);
void RealUSBSuspend(u_int16 timeOut);


#endif /*__PLAYER_H__*/
