#ifndef MINIFAT_H
#define MINIFAT_H

#define MINIFAT_H

#include <vstypes.h>
#include "fat.h"

#if 0
struct Fat {
    byte BS_jmpBoot[3];		/**< 0 x86 Boot Jump Code */
    byte BS_OEMName[8];		/**< 3 Formatter's name, usually "MSWIN4.1" */
    
    word BPB_BytsPerSec;	/**< 11 Bytes per sector (512) */
    byte BPB_SecPerClus;	/**< 13 Sectors per Cluster (1,2,4,8,..,128) */
    word BPB_RsvdSecCnt;	/**< 14 Reserved sectors (1 (32 for FAT32)) */
    byte BPB_NumFATs;		/**< 16 Number of FATs (2) */
    word BPB_RootEntCnt;	/**< 17 FAT12/16 n of root dir entries */
    word BPB_TotSec16;		/**< 19 Old sector count (0 for FAT32) */
    byte BPB_Media;		/**< 21 Media Type (eg 0xF8) */
    word BPB_FATSz16;		/**< 22 Size of one FAT16 in sectors */
    word BPB_SecPerTrk;		/**< 24 Old CHS Sectors Per Track */
    word BPB_NumHeads;		/**< 26 Old CSH Number of Heads */
    u_32 BPB_HiddSec;		/**< 28 n of sectors before this volume */
    u_32 BPB_TotSec32;		/**< 32 New sector count (0 for FAT12/16) */
   
    /** FAT type specific extensions */
    union Extensions{	

      /** FAT12/16 specific extensions to Bios Parameter Block*/
      struct Fat16Specific {	
	byte BS_DrvNum;		/**< 36 DOS INT13 Drive Number (0x80=HD)*/
	byte BS_Reserved1;	/**< 37 For WINNT; Format to 0 */
	byte BS_BootSig;	/**< 38 0x29 if next 3 fields are present */
	byte BS_VolID[4];	/**< 39 Volume ID (usually format datetime) */
	byte BS_VolLab[11];	/**< 43 Volume Label */
	byte BS_FilSysType[8];	/**< 54 Decorative name of fs, eg "FAT16   "*/
      } _16;

      /** FAT32 specific extensions to Bios Parameter Block*/
      struct Fat32Specific {	
        u_32 BPB_FATSz32;	/**< 36 Size of one FAT32 in sectors */
	word BPB_ExtFlags;	/**< 40 Flags; active FAT number etc */
	word BPB_FSVer;		/**< 42 File System Version (0x0000) */
	u_32 BPB_RootClus;	/**< 44 Start cluster of Root Dir. (2) */
	word BPB_FSInfo;	/**< 48 Start sector of FSINFO in Resvd area */
	word BPB_BkBootSec;	/**< 50 Sector in Resvd area for BkBoot (6) */
	byte BPB_Reserved[12];	/**< 52 Reserved, Always 0. */
	byte BS_DrvNum;      	/**< 64 DOS INT13 Drive Number (0x80=HD) */
	byte BS_Reserved1;      /**< 65 For WINNT, Format to 0 */
	byte BS_BootSig;	/**< 66 0x29 if next 3 fields are present */
	byte BS_VolID[4];	/**< 67 Volume ID (usually format datetime) */
	byte BS_VolLab[11];	/**< 71 Volume Label */
	byte BS_FilSysType[8];  /**< 82 Decorative name of fs, eg "FAT32   "*/
      } _32;
    } ext;
  } fat;
#endif
#if 0
/** FAT/VFAT directory record union */
union DirRecordUnion {
  /** Standard directory entry */
  struct Entry {
    byte Name[11]; 0
    byte Attr;     11
    byte NTRes;    12
    byte CrtTimeTenth; 13
    word CrtTime;  14
    word CrtDate;  16
    word LstAccDate; 18
    word FstClusHi; 20
    word WrtTime;   22
    word WrtDate;   24
    word FstClusLo; 26
    u_32 FileSize;  28
  } entry;

  /** Extended directory entry */
  struct LongEntry {
    byte Ord;      0
    word Name1[5]; 1 /**< characters 1-5 */
    byte Attr;     11
    byte Type;     12 /**< entry type, zero=long name component */
    byte Chksum;   13
    word Name2[6]; 14 /**< characters 6-11 */
    word FstClusLO; 26 /**< zero for long entry */
    word Name3[2]; 28 /**< characters 12-13 */
  } longentry;
};
#endif


auto u_int16 FatGetByte(register __c0 u_int16 n);
auto u_int16 FatGetWord(register __c0 u_int16 n);
auto u_int32 FatGetLong(register __c0 u_int16 n);
auto u_int16 FatInitFileSystem(void);
auto __y struct FRAGMENT *FatFragmentList(
    register __i2 __y struct FRAGMENT *frag,
    register __reg_b u_int32 fatCluster);
auto s_int16 FatHandleDir(register __y struct FRAGMENT *curFragment,
			  __y struct FRAGMENT *nextFragment);
auto s_int16 FatOpenFile(register __c0 u_int16 fileNum);
auto s_int16 FatReadFile(register __i3 u_int16 *buf,
			 register __c1 s_int16 byteOff,
			 register __c0 s_int16 byteSize /*< <0 for little-endian order*/);
u_int32 FatTell(void);
u_int32 FatSeek(register __reg_a u_int32 pos); /*< returns old position */
void MemCopyPackedBigEndian(register __i0 u_int16 *dst,
			    register __a0 u_int16 dstidx,
			    register __i1 u_int16 *src,
			    register __a1 u_int16 srcidx,
			    register __b0 u_int16 byteSize);
void MemCopyPackedLittleEndian(register __i0 u_int16 *dst,
			       register __a0 u_int16 dstidx,
			       register __i1 u_int16 *src,
			       register __a1 u_int16 srcidx,
			       register __b0 u_int16 byteSize);
void MemWritePacked(register __a0 void *dst, register __a1 u_int16 dstidx,
		    register __b0 u_int16 dat);
u_int16 MemReadPacked(register __a0 const void *src,
		      register __a1 u_int16 srcidx);
void MemWritePackedY(register __a0 __y void *dst, register __a1 u_int16 dstidx,
		    register __b0 u_int16 dat);
u_int16 MemReadPackedY(register __a0 __y const void *src,
		      register __a1 u_int16 srcidx);

typedef s_int16 (*freeSectorCallback)(void *private, u_int32 sector, u_int32 numSecs);
s_int16 FatIterateOverFreeSectors(freeSectorCallback callBackFunction,
				  void *private);

auto u_int16 ReadDiskSector(register __i0 u_int16 *buffer,
			    register __reg_a u_int32 sector);

/**
   Minifat interface:
   - ReadDiskSector() must be provided

 */


#endif/*MINIFAT_H*/
