#ifndef _MATH_H_
#define _MATH_H_

__near double frexp(double value, __near int *eptr);
__near double ldexp(double value, int exp);
__near double fabs(double value);
#define frexp __builtin_frexp
#define ldexp __builtin_ldexp
#define fabs  __builtin_fabs

__near double _modf(double value, __near double *iptr);
#define modf(v,p) _modf(v,p)
#define _oldmodf(v,p) (*(p)=(long)(v),(v)-(double)(long)(v))
__near double fmod(double x, double y);

/* NOTE: Check what this really should be !!!*/
#define HUGE_VAL      3.402823466385288598e38

#define EDOM        33
#define ERANGE      34

__near double acos(double);
__near double asin(double);
__near double atan(double);
__near double cos(double);
__near double cosh(double);
__near double exp(double);
__near double log10(double);
__near double log(double);
__near double sin(double);
__near double sinh(double);
__near double sqrt(double);
__near double tan(double);
__near double tanh(double);

__near double floor(double);
__near double ceil(double);
__near double pow(double, double);
__near double atan2(double, double);

__near auto double SqrtF(double); /* result with 16-bit precision */
__near auto unsigned short SqrtI(register __c unsigned long x);

__near auto double SqrtF32(double); /* result with 32-bit precision */
__near auto unsigned long SqrtI32(register __c unsigned long x); /* 16.16 result */
__near double ISqrt(double x); /* x^(-1/2) */

#ifndef __VSDSP__
#define MulSh24(a,b) ((long)((long long)(a) * (b) >> 24))
#define MulSh20(a,b) ((long)((long long)(a) * (b) >> 20))
#else
/* These functions should be called in integer mode */
auto long MulSh24(register __a long c, register __d long d);
auto long MulSh20(register __a long c, register __d long d);
#endif


#endif /* _MATH_H_ */
