#ifndef VSMPG_H
#define VSMPG_H

#include <vstypes.h>

#ifndef ASM

#ifndef __VSDSP__
#define __a
#define __b
#define __c
#define __d
#define __x
#define __y
#define __a0
#define __a1
#define __b0
#define __b1
#define __c0
#define __c1
#define __d0
#define __d1
#define __i0
#define __i1
#define __i2
#define __i3
#define auto
#endif

#ifndef CONST
#define CONST const
#endif

typedef unsigned char byte;

/*audio.h*/
struct audio_info_struct {
  u_int16 rate;
  u_int16 channels;
};
auto void AudioSet(u_int16 ch, u_int16 r);
auto void AudioInit(void);

#endif/*!ASM*/

#define		AUDIOBUFSIZE		64

#define         FALSE                   0
#define         TRUE                    1

#define         MAX_NAME_SIZE           81
#define         SBLIMIT                 32
#define         SCALE_BLOCK             12
#define         SSLIMIT                 18

#define         MPG_MD_STEREO           0
#define         MPG_MD_JOINT_STEREO     1
#define         MPG_MD_DUAL_CHANNEL     2
#define         MPG_MD_MONO             3

#define HYBL_SIZE (2*(SBLIMIT+1)*SSLIMIT)
#ifndef ASM
extern s_int16 hyBlock[2][(SBLIMIT+1)*SSLIMIT];
#endif


/* For Application, general.c/h */

#define APPL_RESET	 0
#define APPL_AUDIO	 1
#define APPL_W0		 2
#define APPL_W1		 3
#define APPL_W2		 4
#define APPL_W3		 5
#define APPL_R0		 6
#define APPL_R1		 7
#define APPL_R2		 8
#define APPL_R3		 9
#define APPL_BITSTREAM	10
#define APPL_OUT_OF_DATA 11

#define EXTRA_QUANT_BITS 8 /* for 32-bit quantization, must be at least 3 */

/*ima.h/imalib.h*/
#define ISSTMAX 88
#define IMA_ENCODE_BLOCK_ALIGN 256
#define IMA_ENCODE_SAMPLES (2*IMA_ENCODE_BLOCK_ALIGN-7)
#define IMA_ENCODE_BSSPACE (IMA_ENCODE_BLOCK_ALIGN*4) // must be power of 2


#ifndef ASM

/*general.h*/
extern s_int16 (*applAddr)(s_int16 register __i0 **d,
			   s_int16 register __a1 mode,
			   s_int16 register __a0 n);
auto s_int16 MyGetC(void);
auto void MyGetCPairs(register __i0 __y u_int16 *p, register __a0 s_int16 n);
auto void WaitForData(register __c0 u_int16 n);
auto s_int16 ReadStream(register __i3 u_int16 *buf,
			register __c1 s_int16 byteOff,
			register __c0 s_int16 byteSize);
extern s_int16 __y timeToRemovePDown2;

/*ima.h/imalib.h*/
extern u_int16 __y *bssWp, *bssRp;
auto void ImaEncode(void);



u_int16 get1bit(void);
auto void rewindbits(register __a1 int number_of_bits);
auto u_int16 getbits(register __a1 int);
auto void SetPointer(s_int16);

extern s_int16 pcm_sample[AUDIOBUFSIZE];
extern s_int16 pcm_point;

void do_layer3(void);
auto void InitLayer3(void);
void do_layer2(void);
void do_layer1(void);

void InitDecode(void);
auto void synth_mono32(s_int32 *,s_int16 *,s_int16 *);
auto void synth32(s_int32 *bandPtr, s_int16 ch, s_int16 *out, s_int16 *pnt);


auto s_int16 WmaStereoCopy(s_int16 *p, s_int16 samples);

/* These may be used by layer 1 and 2 for other purposes.
   Size for each table is 1152. */
extern s_int16 hybridIn[2][SBLIMIT][SSLIMIT];
extern s_int16 hybridOut[2][SSLIMIT][SBLIMIT];

extern struct audio_info_struct __y ai;
auto void InitCommon(void);


/* For cos64, imdct36 & imdct12 */
extern s_int16 __y const cos64NewTab[];
extern s_int16 __y const cos36Tab[];
extern s_int16 __y const cos12Tab[];

/* For bit routines */
extern u_int16 __y *wordpointer; /*can also point to X depending on codec*/
extern u_int16 __y bitindex;

extern __y s_int16 _common_y_3136[3072+64];
#endif/*!ASM*/


#endif/*!VSMPG_H*/
