#ifndef __PARAMETRIC_H__
#define __PARAMETRIC_H__

#define PARAMETRIC_VERSION 0x0003

#if PARAMETRIC_VERSION == 3
struct parametric {
    /* configs are not cleared between files */
    u_int32 chipID;     /*0x1e00/01 Initialized at reset for your convenience*/
    u_int16 version;    /*0x1e02 - structure version */
    /* config1  0x1e03 ---- ---- ppss RRRR */
    /*                                RRRR = Midi Reverb */
    /*                           pp=PS mode, ss=SBR mode
       SBR mode: 0=normal, 1=no implicit upsample, 2=never upsample, 3=no SBR
       PS mode:  0=normal, 1=PS in downsampled mode, 2=reserved 3=no PS
    */
    u_int16 config1;
    s_int16 playSpeed;  /*0x1e04 0,1 = normal speed, 2 = twice, etc. */
    u_int16 byteRate;   /*0x1e05 average byterate */

    u_int16 endFillByte;   /*0x1e06 which byte value to send after file */
    u_int16 reserved[15];  /*0x1e07..15 */
    u_int32 jumpPoints[8]; /*0x1e16..25 file byte offsets */
    u_int16 latestJump;    /*0x1e26 index to lastly updated jumpPoint */
    u_int32 positionMsec;  /*0x1e27-28 play position if known. V3*/
    s_int16 resync;        /*0x1e29 > 0 for automatic m4a, ADIF, WMA resyncs*/
    /* 42 words */
    union { /* 22 available */
	u_int16 generic[22];
	struct {
	    u_int32 curPacketSize;
	    u_int32 packetSize;
	    /*v2*/
	    u_int16 rKeyType; /* requested 'C' or 'P' for WMA-DRM */
	    u_int32 rOffset;  /* requested file offset for 'P' */

	    u_int16 pData[8]; /* provided data for 'C' or 'P' */
	    u_int32 pOffset;  /* provided file offset for 'P' */
	    u_int16 pKeyType; /* provided 'C' or 'P' for WMA-DRM */
	} wma; /* 4*/
	struct {
	    u_int16 sceFoundMask; /*2a single-channel-el. found since last clr*/
	    u_int16 cpeFoundMask; /*2b channel-pair-el. found since last clr*/
	    u_int16 lfeFoundMask; /*2c low-frequency-el. found since last clr*/
	    u_int16 playSelect;   /*2d 0 = first any, initialized at aac init */
	    s_int16 dynCompress;  /*2e -8192=1.0, initialized at aac init */
	    s_int16 dynBoost;     /*2f  8192=1.0, initialized at aac init */
	    /*
	      playSelect:
	        0 = first sce or cpe or lfe
		xxxx0001 first sce
		xxxx0010 first cpe
		xxxx0011 first lfe
		eeee0101 sce eeee
		eeee0110 cpe eeee
		eeee0111 lfe eeee
	    */
	    /*
	      sbrAndPsStatus: (mask)
	        1 SBR present
		2 upsampling active
		4 PS present
		8 PS active
	     */
	    u_int16 sbrAndPsStatus; /*0x1e30 V3 */
#define AAC_SBR_PRESENT 1
#define AAC_UPSAMPLE_ACTIVE  2
#define AAC_PS_PRESENT 4
#define AAC_PS_ACTIVE  8
	} aac; /* 3*/
	struct {
	    u_int32 bytesLeft;
	} midi; /* */
	struct {
	    s_int16 gain; /* 0x1e2a proposed gain offset, default = -12 */
	} vorbis;
    } i;
};
#endif/*V3*/
#if PARAMETRIC_VERSION == 2
struct parametric {
    u_int32 chipID;     /*1940/41 Initialized at reset for your convenience */
    u_int16 version;    /*1942 - structure version */
    /* midiConfig: ---- ---- -SSS RRRR   playSpeed, Reverb */
    u_int16 midiConfig; /*1943*/
    /* config1:    ---- ---- ---- ppss   p=PS mode, s=SBR mode V3 */
    u_int16 config1;    /*1944*/
    /* config2:    ---- ---- ---- ----   */
    u_int16 config2;    /*1945 configs are not cleared between files */

    u_int32 jumpPoints[16]; /*1946..65 file byte offsets */
    u_int16 latestJump; /*1966 index to lastly updated jumpPoint */
    s_int16 seek1;      /*1967 file data inserted/removed bytes -32768..32767*/
    s_int16 seek2;      /*1968 file data inserted/removed kB -32768..32767*/
    s_int16 resync;     /*1969 > 0 for automatic m4a, ADIF, WMA resyncs */
    /* 42 words */
    union { /* 22 available */
	u_int16 generic[22];
	struct {
	    u_int32 curPacketSize;
	    u_int32 packetSize;
	    /*v2*/
	    u_int16 rKeyType; /* requested 'C' or 'P' for WMA-DRM */
	    u_int32 rOffset;  /* requested file offset for 'P' */

	    u_int16 pData[8]; /* provided data for 'C' or 'P' */
	    u_int32 pOffset;  /* provided file offset for 'P' */
	    u_int16 pKeyType; /* provided 'C' or 'P' for WMA-DRM */
	} wma; /* 4*/
	struct {
	    u_int16 sceFoundMask; /* single-channel-el. found since last clr*/
	    u_int16 cpeFoundMask; /* channel-pair-el. found since last clr*/
	    u_int16 lfeFoundMask; /* low-frequency-el. found since last clr*/
	    u_int16 playSelect;   /* 0 = first any, initialized at aac init */
	    s_int16 dynCompress;  /* -8192=1.0, initialized at aac init */
	    s_int16 dynBoost;     /*  8192=1.0, initialized at aac init */
	    /*
	      playSelect:
	        0 = first sce or cpe or lfe
		xxxx0001 first sce
		xxxx0010 first cpe
		xxxx0011 first lfe
		eeee0101 sce eeee
		eeee0110 cpe eeee
		eeee0111 lfe eeee
	    */
	} aac; /* 4*/
	struct {
	    u_int32 bytesLeft;
	} midi; /* */
	struct {
	    s_int32 playTimeSeconds; /* 0x196a..6b */
	    s_int32 playTimeSamples; /* 0x196c..6d */
	    s_int16 gain; /* 0x196e proposed gain, default = -12 */
	} vorbis;
    } i;
};
#endif/*V2*/
extern struct parametric parametric_x; /* 64 words */

/*
  WMA A-B repeat / Rewind
  1) When A pressed:
     read a file byte offset "A = jumpPoints[latestJump]" from VS1023
     (optionally remember SCI_DECODE_TIME)
  2) When B pressed:
     read a file byte offset "B = jumpPoints[latestJump]" from VS1023
  3) Send bytes upto but not including byte at file offset B
     (B bytes from the file have now been sent)
  4) write a wma seek indication "seek = A-B" to VS1023
     (optionally update SCI_DECODE_TIME)
  5) Continue sending file from file offset A

  WMA Fast Forward
  1) read a file byte offset "A = jumpPoints[latestJump]"
  2) Send bytes upto but not including byte at file offset A
  3) Parse the WMA packet header from offset A onward to get the packet size
     (if packet size type is 0, read "packetSize" from VS1023)
  4) Skip the packet data, remember the skipped size "L = L + size"
  5) repeat 3..4
  6) write a wma seek indication "seek = L" to VS1023
  7) continue sending file
 */


/*
  midiConfig:
  1 1 1 1  1 1
  5 4 3 2  1 0 9 8  7 6 5 4  3 2 1 0
  - - - -  - - - -  - S S S  R R R R

  R = reverb   0 = auto (ON if clock>=3.0x)
               1 = off
	    2-15 = room size

  S = play speed  0 = 1x (normal speed)
                  1 = 2x, 2 = 4x, 3 = 8x, 4 = 16x, 5 = 32x, 6 = 64x, 7 = 128x
*/

#endif /* __PARAMETRIC_H__ */
