#ifndef _FATINFO_H_
#define _FATINFO_H_
//#define FATINFO_IN_Y

#define MAX_FRAGMENTS 38

#define FATINFO_SIZE 16

#ifdef ASM
	.import _fatInfo

#define ISFAT32  0
#define FATSTART 1
#define ROOTSTART 3
#define DATASTART 5
#define CURRENTSECTOR 7
#define FILESIZE 9
#define FATSECTORSPERCLUSTER 11
#define BPBROOTENTCNT 12
#define FILSYSTYPE 13
#define TOTSIZE 14

#define _IS_FAT_32                _fatInfo+ISFAT32
#define _fatStart                 _fatInfo+FATSTART
#define _rootStart                _fatInfo+ROOTSTART
#define _dataStart                _fatInfo+DATASTART
#define _currentSector            _fatInfo+CURRENTSECTOR
#define _fileSize                 _fatInfo+FILESIZE
#define _fatSectorsPerCluster     _fatInfo+FATSECTORSPERCLUSTER
#define _BPB_RootEntCnt           _fatInfo+BPBROOTENTCNT

#else

#include <vstypes.h>

struct FATINFO { /* do not change sizes or order of fields! */
    u_int16 IS_FAT_32;                // _fatInfo+0
    u_int32 fatStart;                 // _fatInfo+1
    u_int32 rootStart;                // _fatInfo+3
    u_int32 dataStart;                // _fatInfo+5
    u_int32 currentSector;            // _fatInfo+7
    u_int32 fileSize;                 // _fatInfo+9
    u_int16 fatSectorsPerCluster;     // _fatInfo+11
    u_int16 BPB_RootEntCnt;           // _fatInfo+12
    u_int16 FilSysType; // _fatInfo+13 to detect FAT12
    s_int32 totSize;    // _fatInfo+14
};

#define LAST_FRAGMENT 0x80000000UL
struct FRAGMENT {
    u_int32 start; /*high bit set if last fragment*/
    u_int16 size;
};
extern __y struct FRAGMENT fragments[MAX_FRAGMENTS];
extern u_int16 stream_buffer[];

#ifdef FATINFO_IN_Y
extern __y struct FATINFO fatInfo;
#else
extern struct FATINFO fatInfo;
#endif

typedef s_int16 (*freeSectorCallback)(void *private, u_int32 sector, u_int32 numSecs);
s_int16 FatIterateOverFreeSectors(freeSectorCallback callBackFunction,
				  void *private);
/*Reads into stream_buffer.*/
auto void ReadDiskSector(register __a u_int32 sector);
void FatPrepareForSaving(void);

struct MMC {
    u_int32 blocks;
    /**do not change above fields!**/
    u_int16 fileName[12/2];   /* in packed format */
    u_int32 dirBlock;
    s_int16 dirLine;
    u_int32 freeStart; /* start in 512-byte blocks */
    u_int32 freeSize;  /* size in 512-byte blocks */
    u_int32 fileSize;         /* saved size in bytes */
};
extern __y struct MMC mmc;
void FsFatAllocate2(u_int32 start, u_int32 length, u_int32 link, u_int16 free);
void MmcWrite(u_int32 firstBlock, u_int16 *data);
u_int16 SwapWord(register __a1 u_int16 d);
void FsFatMakeFile(void);
extern u_int16 created[3]; /*date, time, ms little-endian*/


#endif/*ASM*/

#endif/*_FATINFO_H_*/
