#define ASM
#define STANDALONE
#include "h1053/hardware.h"

	.sect code,MySdi
	.org 0x10		// space for 16 instructions
	nop
	nop	// some space for emulator
	nop
	nop
	nop

	.export my_sdi_int
my_sdi_int:
	stx mr0,(i6)+1	; sty i7,(i6)
	stx a0,(i6)	; sty b0,(i6)

	ldc SER_DATA,i7
	lsr ones,b0	; ldx (i7),a0
	.import _ui
	ldc _ui+0/*Data*/,i7
	lsrc a0,a0	; ldy (i6),b0		// 0x8000 or 0xffff;
	sty a0,(i7)	; ldx (i6)-1,a0

	ldc INT_GLOB_ENA,i7
	ldx (i6),mr0
	reti
	stx i7,(i7); ldy (i6)-1,i7

	/* SDI vector updated AFTER the handler is loaded, thus is ok */
	.sect code,int_vectors
	.org 0x22
	jmpi my_sdi_int,(i6)+1	// SDI	0x22

	.import __stack

	.sect code,startup
	.org 0x30
	.import _MyMain
	j _MyMain
	ldc __stack,i6




#define GPIO_IDATA GPIO_DATA
#define SPI_xCS   1 /* GPIO */
#define SPI_CLK   8
#define SPI_MISO  4
#define SPI_MISO_SHIFT -3
#define SPI_xCS2  2
#define SPI_MOSI  1 /* DREQ */

	.sect code,SpiSendClocks
	.export _SpiSendClocks
_SpiSendClocks:
// auto void SpiSendClocks(void);
	stx ls,(i6)+1	; sty le,(i6)

	ldc 1,i5
	ldc SER_DREQ,i7
	stx i5,(i7)+(GPIO_ODATA-SER_DREQ) ; sty lc,(i6)	// data out (=1)
	ldc 16-1,ls
	loop ls,$0-1
	nop

#ifdef PLL3_5
	nop
#endif
	j $10	// 3 cycles
$10:	ldc SPI_CLK|SPI_xCS|SPI_xCS2,i5
	stx i5,(i7)	// clk up

#ifdef PLL3_5
	nop
#endif
	j $11	// 3 cycles
$11:	ldc         SPI_xCS|SPI_xCS2,i5
	stx i5,(i7)	// clk down
$0:
	ldy (i6)-1,lc
	ldx (i6)-1,ls	; ldy (i6),le
	jr
	nop	//loop hw can not be restored here..

	.sect code,SpiSendReceiveMmc
	.export _SpiSendReceiveMmc16
	.export _SpiSendReceiveMmc
_SpiSendReceiveMmc16:
	ldc 16,A1
_SpiSendReceiveMmc:
// auto u_int16 SpiSendReceiveMmc(register __a0 u_int16 dataTopAligned, register __a1 bits);
	// A0 = 16-bit data to send, A0 = data read
	// I7, A1, D1 tmp regs
	stx d0,(i6)+1	; sty c0,(i6)
	stx lc,(i6)+1	; sty c1,(i6)

	ldc SPI_CLK|SPI_xCS,c0
	ldc SPI_xCS,d0
	
	add a1,ones,c1	; stx ls,(i6)
	lsl a,a		; sty le,(i6)
	ldc SER_DREQ,i7

	loop c1,$0-1
	ldc SPI_MISO_SHIFT,c1
$1:
	// PLL2_0  50/50% clock 4.1 MHz
	//=2.0*12.288/6 = 4.096
	// 2.0*12.288/7 = 3.511

	// PLL3_5  55/45% clock 4.8 MHz
	// 3.5*12.288/7 = 6.144
	// 3.5*12.288/8 = 5.376
	//=3.5*12.288/9 = 4.779
	// 3.5*12.288/10 = 4.3008

#ifdef PLL3_5
	nop
#endif
	nop // as much delay between clk down and data i/o as possible
	stx a1,(i7)+(GPIO_ODATA-SER_DREQ)	//data out
#ifdef PLL3_5
	nop
#endif
	stx c0,(i7)+(GPIO_IDATA-GPIO_ODATA) // clk up   ODATA
	ldx (i7)+(GPIO_ODATA-GPIO_IDATA),a1	//data in, note pipeline!
	ashl a1,c1,a1
#ifdef PLL3_5
	nop
#endif
	lslc a,a	; stx d0,(i7)+(SER_DREQ-GPIO_ODATA)	// clk down
$0:
	ldx (i6)-1,ls	; ldy (i6),le
	ldx (i6)-1,lc	; ldy (i6),c1
	jr
	ldx (i6)-1,d0	; ldy (i6),c0


#if 0
	.sect data_y,bss_y
	.export _fileName
_fileName:
	.bss 6
	.export _rand_seed
_rand_seed:
	.bss 1		// the initial seed is 1 (K&R p.252)

	.sect code,_myrand
/* Returns a pseudo-random integer in the range 0 to RAND_MAX */
	.export _myrand
_myrand:
	ldc _rand_seed,i7
	ldy (i7),a0	; stx a1,(i6)
	ldc 16217,a1		//0x4001,a0
	mulss a0,a1
	ldc 9043,a0		//0x951,a0
	add a,p,a		// x(n+1) = (a*x(n)+c) mod m
	lsr a0,a0	; sty a0,(i7)	// output: 0..0x7fff
	jr
	ldx (i6)-1,a1
#endif

	.end
