//#define ASM
//#define STANDALONE
#include "h1053/hardware.h"

#ifndef CMD
	.sect data_x,sci_defaults
	/*SCI_MODE	0xC000*/
	/*SCI_STATUS	0xC001*/
	.org SCI_BASS
#ifdef LOUDNESS_ON
#ifdef BASS_VAL
	.uword BASS_VAL	/*SCI_BASS	0xC002*/
#else
	.uword 0x33d9
#endif
#else
	.uword 0x0000	/*SCI_BASS	0xC002*/
#endif
	.uword CLOCKF_VAL	/*SCI_CLOCKF	0xC003*/
	.uword 0x0000	/*SCI_DECODE_TIME 0xC004*/
	.uword 0x0000	/*SCI_AUDATA	0xC005*/
	.uword 0x0000	/*SCI_WRAM	0xC006*/ /* REC gain/AGC -> AICTRL1*/
	.uword 0x4000	/*SCI_WRAMADDR	0xC007*/ /* REC max gain -> AICTRL2*/
	.uword 0x0000	/*SCI_HDAT0	0xC008*/
	.uword 0x0000	/*SCI_HDAT1	0xC009*/
	.uword 0x0000	/*SCI_AIADDR	0xC00A*/
#ifdef VOL_VAL
	.uword VOL_VAL	/*SCI_VOL	0xC00B*/
#else
	.uword 0x0c0c	/*SCI_VOL	0xC00B*/
#endif /*VOL_VAL !defined*/
	.uword 0	/*SCI_AICTRL0	0xC00C*/ /* file to play */
	.uword 0	/*SCI_AICTRL1	0xC00D*/
#ifdef BASS_VAL
	.uword BASS_VAL	/*SCI_AICTRL2	0xC00E -- loudness value for non-sci */
#else
	.uword 0x33d9	/*SCI_AICTRL2	0xC00E -- loudness value for non-sci */
#endif
#if 1
	.uword 0x0000	/*SCI_AICTRL3	0xC00F*/
#else
	.uword 0x0004	/*SCI_AICTRL3	0xC00F pause before play */
#endif

#ifdef ENABLE_WATCHDOG
#if 1 //ifndef RECORDER //14 words, disable from standalone.c also!
	.sect data_x,wdog
	.org WDOG_CONFIG
	.word 1000
	.word WDOG_RESET_VAL
#endif
#endif
#endif /*!SCI_UI*/

#if 0 /*
	Can not be installed like this in the version that is loaded
	through SCI or the hook can be called before the hook code is
	loaded.
       */
	.sect code,ramvectors
	.org 0
	.import _UserHook
	j _UserHook
	nop
#endif

	.sect code,MySdi
	.org 0x18		// space for 16 instructions
	.export _SciModeOr
_SciModeOr:
#ifdef ENABLE_LAYER12
	jr
	ldc (1<<SCIMB_SDI_NEWMODE)|(MODEORMASK)|(1<<SCIMB_ALLOW_LAYER12),a0
#else
	jr
	ldc (1<<SCIMB_SDI_NEWMODE)|(MODEORMASK),a0
#endif/*ENABLE_LAYER12*/
	.export _RecordMode
_RecordMode:
	jr	/*we don't need (1<<SCIMB_ADPCM) !*/
	ldc 0/*|(1<<SCIMB_ADPCM_HP)|(1<<SCIMB_LINE)*/,a0


	.import _UserHook
hooK:	j _UserHook


	.import __stack
	.sect code,startup
	.org 0x50

#ifdef SCI_UI
#define NO_START_DELAY
#endif

	.import _ReadFromProgramRam
	.import _WriteToProgramRam
#ifdef SCI_UI
#ifdef NO_START_DELAY
	// Install the idle hook routine 
	// WriteToProgramRamLong(0, ReadFromProgramRam(0x14));
	call _ReadFromProgramRam
	ldc hooK,i0
	call _WriteToProgramRam
	ldc 0,i0

	ldc 1,a1	// perform full init
#else
	ldc 0x48d0,LS	//0x0030  0x0012340e      LDC 0x48d0,LS 22.75ms
			//0x0030  0x003fff0e      LDC 0xfffc,LS	80.00ms
	loop LS,$0-1
	nop
	call _ReadFromProgramRam	//$48d0*(5+5+5) cycles = 22.75ms
	ldc hooK,i0
	call _WriteToProgramRam
	ldc 0,i0
	ldc 1,a1	// perform full init
$0:
#endif
#endif/*SCI_UI*/

	.import _MyMain
	.export _MyReset
	j _MyMain
_MyReset:
	ldc __stack+1,i6	//leave one for UART control
	j _MyMain
	ldc 0,a1	// perform partial init

#ifndef SCI_UI
	.sect code,hook
	.org 0
	j _UserHook
#endif


//#define GPIO_IDATA GPIO_DATA
#define SPI_xCS   1 /* GPIO */
#define SPI_CLK   8
#define SPI_MISO  4
#define SPI_MISO_SHIFT -3
#define SPI_xCS2  2
#define SPI_MOSI  1 /* DREQ */

	.sect code,SpiSendClocks
	.export _SpiSendClocks
_SpiSendClocks:
// auto void SpiSendClocks(void);
	stx a0,(i6)+1	; sty b0,(i6)
	stx ls,(i6)+1	; sty le,(i6)

	ldc 1,i5
	ldc SER_DREQ,i7
	stx i5,(i7)+(GPIO_ODATA-SER_DREQ) ; sty lc,(i6)	// DREQ=data out (=1)
	ldc 16-1,ls
	loop ls,$0-1
	nop

#ifdef RECORDER
	.import mysrc_int
	ldc mysrc_int,i5	//nop /*just pull in the imafix */
#else
	nop
#endif
	ldc SPI_CLK|SPI_xCS|SPI_xCS2,b0
	ldx (i7),a0
	or a0,b0,a0	//clk+xcs+xcs2 up
	stx a0,(i7)

	nop
	nop
	ldc SPI_CLK,b0
	xor a0,b0,a0	//clk down	//ldc SPI_xCS|SPI_xCS2,i5
	stx a0,(i7)	// clk down
	//nop	//VS1003 seems to require this
$0:
	ldy (i6)-1,lc
	ldx (i6)-1,ls	; ldy (i6),le
	jr
	ldx (i6)-1,a0	; ldy (i6),b0



	.sect code,SpiSendReceiveSpi
	.export _SpiSendReceiveSpi
_SpiSendReceiveSpi:
// auto u_int16 SpiSendReceiveSpi(register __a0 u_int16 dataTopAligned, register __a1 bits);
	stx d0,(i6)+1	; sty c0,(i6)
#if 1
	//Now saves the old state of other GPIO pins
	ldc GPIO_ODATA,i7
	ldx (i7),b0	; sty b0,(i6)
	ldc ~(SPI_CLK|SPI_xCS|SPI_xCS2),d0
	and b0,d0,b0
	ldc SPI_xCS2,c0	//SPI CLK up, SPI CS down, MMC CLK down
	j _SpiCommon
	ldc 0,d0	//SPI CLK down. SPI CS down, MMC CLK down
#else
	ldc SPI_xCS2,c0	//SPI CLK up, SPI CS down, MMC CLK down
	j _SpiCommon
	ldc 0,d0	//SPI CLK down. SPI CS down, MMC CLK down
#endif

	.sect code,SpiSendReceiveLcd
	.export _SpiSendReceiveLcd
_SpiSendReceiveLcd:
// auto u_int16 SpiSendReceiveLcd(register __a0 u_int16 dataTopAligned, register __a1 bits);
	stx d0,(i6)+1	; sty c0,(i6)
#if 1
	//Now saves the old state of other GPIO pins
	ldc GPIO_ODATA,i7
	ldx (i7),b0	; sty b0,(i6)
	ldc ~SPI_CLK,d0
	and b0,d0,b0
	ldc SPI_CLK,c0
	j _SpiCommon
	ldc 0,d0
#else
	ldc SPI_CLK|SPI_xCS,c0
	j _SpiCommon
	ldc SPI_xCS,d0
#endif

	.sect code,SpiSendReceiveMmc
	.export _SpiSendReceiveMmc16
	.export _SpiSendReceiveMmc
_SpiSendReceiveMmc16:
	ldc 16,A1
_SpiSendReceiveMmc:
// auto u_int16 SpiSendReceiveMmc(register __a0 u_int16 dataTopAligned, register __a1 bits);
	// A0 = 16-bit data to send, A0 = data read
	// I7, A1, D1 tmp regs
	stx d0,(i6)+1	; sty c0,(i6)
#if 1
	ldc GPIO_ODATA,i7
	ldx (i7),b0	; sty b0,(i6)
	ldc ~(SPI_CLK|SPI_xCS|SPI_xCS2),d0
	and b0,d0,b0
	ldc SPI_CLK|SPI_xCS,c0	//MMC CLK up, SPI CS up
	ldc SPI_xCS,d0		//MMC CLK down, SPI CS up
_SpiCommon:
	or c0,b0,c0
	or d0,b0,d0	; ldy (i6),b0
#else
	ldc SPI_CLK|SPI_xCS,c0	//MMC CLK up, SPI CS up
	ldc SPI_xCS,d0		//MMC CLK down, SPI CS up
_SpiCommon:
#endif
	stx lc,(i6)+1	; sty c1,(i6)
	add a1,ones,c1	; stx ls,(i6)
	lsl a,a		; sty le,(i6)
	ldc SER_DREQ,i7

	loop c1,$0-1
	ldc SPI_MISO_SHIFT,c1
$1:
	// PLL2_0  66/33% clock 4.1 MHz
	//=2.0*12.288/6 = 4.096
	// 2.0*12.288/7 = 3.511

	// PLL3_5  55/45% clock 4.8 MHz
	// 3.5*12.288/7 = 6.144
	// 3.5*12.288/8 = 5.376
	//=3.5*12.288/9 = 4.779
	// 3.5*12.288/10 = 4.3008

#ifdef PLL3_5
	nop
	nop // as much delay between clk down and data i/o as possible
	stx a1,(i7)+(GPIO_IDATA-SER_DREQ)	//data out
#else
	nop // as much delay between clk down and data i/o as possible
	stx a1,(i7)+(GPIO_IDATA-SER_DREQ)	//data out
#endif
	ldx (i7)+(GPIO_ODATA-GPIO_IDATA),a1	//data in, note pipeline!
	stx c0,(i7)+(GPIO_ODATA-GPIO_ODATA) // clk up   ODATA
	ashl a1,c1,a1
#ifdef PLL3_5
	nop
	nop
#else
#endif
	lslc a,a	; stx d0,(i7)+(SER_DREQ-GPIO_ODATA)	// clk down
$0:
	ldx (i6)-1,ls	; ldy (i6),le
	ldx (i6)-1,lc	; ldy (i6),c1
	jr
	ldx (i6)-1,d0	; ldy (i6),c0

// DO DI Clkup Clkdwn



// auto u_int16 GetByte(register __c0 u_int16 n) {
//     return (stream_buffer[n>>1] >> (((n^1)&1)<<3)) & 0xff;

	.sect code,GetByte	// 28 words -> 11
	.export _GetByte
_GetByte:
	stx lr0,(i6)+1	; sty c1,(i6)	// 11->6 words
	call _GetWord
	ldc 0xff,c1
	ldx (i6),lr0
	jr
	and c1,a0,a0	; ldy (i6)-1,c1

//auto u_int16 GetWord(register u_int16 n) {
//    return GetByte(n) | (GetByte(n+1)<<8);

// auto u_int32 GetLong(register __c0 u_int16 n) {
//     return GetWord(n) | ((u_int32)GetWord(n+2)<<16);

	.sect code,GetLong	// 22 words -> 9 -> 6 -> 5
	.export _GetLong
	.export _GetWord
_GetLong:
	sub c0,ones,a1	; sty lr0,(i6)
	call _GetWord
	sub a1,ones,c0	; stx c0,(i6)+1
	ldy (i6),lr0
	//j _GetWord
	add a0,null,a1	; ldx (i6),c0
_GetWord:			// 22 words -> 16
	.import _stream_buffer
	ldc _stream_buffer,i5
	lsr c0,a0	; stx i4,(i6)
	mv a0,i4
	ldx (i5)*,null	; sty a1,(i6)
	ldx (i5)+1,a1		// abcd
	ldc 8,c0
	jcc $0
	ldx (i5),a0		// abcd efgh

	ashl a,c0,a		// cdef gh00
$0:
	ldc 0,a2
	sub null,c0,c0	; mv a2,a0	//8 -> -8
	ashl a,c0,a	; ldx (i6),i4	// 0 00cd ef00
	jr
	or a1,a0,a0	; ldy (i6)-1,a1	//        efcd




	.sect data_y,bss_y
	.export _fileName
_fileName:
	.bss 6


#ifdef UART_UI
	.sect code,rxvector
	.org 0x25
	jmpi _MyRxInt,(i6)+1	// RX	0x25

/*
    0xxxxxxx -> var = (var<<7) + xxxxxxx
    1000yyyy -> SCI_MODE+yyyy = var
*/


	.sect code,RxInt
	.export _MyRxInt
_MyRxInt:
	stx mr0,(i6)+1	; sty i7,(i6)
	stx b0,(i6)+1	; sty a0,(i6)
	ldc UART_DATA,i7
	ldx (i7),a0
	ldc 0x80,b0
	and a0,b0,b0	; stx a0,(i7)	//Echo received byte
	ldc SCI_MODE-0x80,b0
	jzs $1
	ldc __stack,i7
	
	add a0,b0,b0	; ldx (i7),a0
	mv b0,i7
	j $0
	stx a0,(i7)	; ldy (i6)-1,null

$1:	ldx (i7),b0	; sty c0,(i6)
	ldc 7,c0
	ashl b0,c0,b0
	add a0,b0,b0
	stx b0,(i7)	; ldy (i6)-1,c0

$0:	ldx (i6)-1,b0	; ldy (i6),a0
	ldc INT_GLOB_ENA,i7
	ldx (i6),mr0
	reti
	stx i7,(i7)	; ldy (i6)-1,i7

/*
	10 0000000 0000000 = 0x8000
	00 0001000 0000100	
*/

/*
<- 0x65 'e' song/recoding ended
<- 0x70 'p' song paused
<- 0x63 'c' play continued
<- 0x6c 'l' song looped
<- 0x72 'r' recording started

*/


	
#endif

	.sect code,GetI6
	.export _GetI6
_GetI6:
	jr
	mv I6, A0
	
	
	.end
