#include "fat.h"
#include "standalone.h"

/*
  TODO: iterate only upto last cluster, not upto total size.
  TODO: use cluster count to determine FAT12.
  TODO: support FAT12?
 */

s_int16 FatIterateOverFreeSectors(freeSectorCallback callBackFunction,
				  void *private) {
    s_int32 fatCluster = 0;
    __y u_int16 offset;
    __y u_int32 start = 0;
    register __reg_d u_int32 size = 0;

    if (FATINFO_SIZE != sizeof(fatInfo)) {
	FATINFO_SIZE_IS_NOT_SIZEOF_FATINFO(100);
    }

    /* If FAT12, nothing can be done.. */
    if (!fatInfo.IS_FAT_32 && fatInfo.FilSysType == 0x3231)
      return 0;

    goto read;
    while (1) {
	{
	    register u_int32 t;
	    if (fatInfo.IS_FAT_32) {
		t = GetLong(offset) & 0x0fffffffUL;
		offset += 4;
	    } else {
		t = GetWord(offset);
		offset += 2;
	    }
#if 0
	    printf("%08ld %08ld %03d t %08lx\n",
		   fatCluster, fatInfo.currentSector, offset, t);
#endif
	    if (t == 0 /* free */) {
		if (size == 0) {
		    start = fatCluster * fatInfo.fatSectorsPerCluster +
			fatInfo.dataStart;
		}
		size += fatInfo.fatSectorsPerCluster;
	    } else if (size) {
	        if (callBackFunction(private, start, size))
		    return 1;
		size = 0;
	    }
	}
	++fatCluster;
	/*TODO: calculate the actual number of clusters and stop there! */
	if (fatCluster * fatInfo.fatSectorsPerCluster
	    + fatInfo.dataStart + 1 >= fatInfo.totSize) {
	    if (size) {
	        if (callBackFunction(private, start, size))
		    return 1;
	    }
	    return 0;
	}
	offset &= 511;
	if (offset != 0)
	    continue;
    read:
	/* If FAT page is not already in memory, load it. */
	if (fatInfo.IS_FAT_32) {
	    offset = ((u_int16)fatCluster & 0x7F) << 2;
	    ReadDiskSector(fatInfo.currentSector =
			   (fatCluster >> 7) + fatInfo.fatStart);
	} else {
	    offset = ((u_int16)fatCluster & 0xff) << 1;
	    ReadDiskSector(fatInfo.currentSector =
			   (fatCluster >> 8) + fatInfo.fatStart);
	}
    }
}

