#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "fat.h"
#include "standalone.h"

#define DEBUG_LEVEL 0

/*
  Can be used for allocating a range of clusters (sectors),
  and rewriting old links.
 */
void FsFatAllocate2(u_int32 start, u_int32 length, u_int32 link, u_int16 free){
    register u_int32 fatSector;
    register u_int16 fatLine;
    length = (length + fatInfo.fatSectorsPerCluster - 1)
	/ fatInfo.fatSectorsPerCluster;
    start = (start - fatInfo.dataStart) / fatInfo.fatSectorsPerCluster;
    if (fatInfo.IS_FAT_32) {
	fatSector = fatInfo.fatStart + ((s_int32)start >> 7);
	fatLine   = ((u_int16)start << 2);
    } else {
	fatSector = fatInfo.fatStart + ((s_int32)start >> 8);
	fatLine   = ((u_int16)start << 1);
    }
    fatLine &= 511;

#if DEBUG_LEVEL > 0
    puthex(length);
    puts("=clusters");
    puthex(start>>16);
    puthex(start);
    puts("=start cluster");
    puthex(fatSector);
    putchar(' ');
    puthex(fatLine);
    puts("=fat sector,line");
#endif
    goto read;
    while (length) {
	/* no need to read old link, we do not do sanity checks anymore */
#if DEBUG_LEVEL > 3
	puthex(start);
	puthex(fatLine);
	puts("");
#endif
	{
	    register u_int32 t = ++start; /* points to next cluster here */
	    if (--length == 0)
		t = link; /* last one: 0x0fffffffUL for end or next chain */
	    if (free)
		t = 0; /* Free it.. */
	    stream_buffer[fatLine/2] = SwapWord(t);
	    fatLine += 2;
	    if (fatInfo.IS_FAT_32) {
		/*fatLine has been added by 2, so use fatLine/2 again! */
		stream_buffer[fatLine/2] = SwapWord(t>>16);
		fatLine += 2; /*another 2 makes 4 total*/
	    }
	}
	fatLine &= 511;
	if (fatLine == 0 || length == 0) {
#if DEBUG_LEVEL > 0
	    puthex(fatSector);
	    puts("=fatSector Wr");
#endif
	    MmcWrite(fatSector, stream_buffer);
#if DEBUG_LEVEL > 0
	    FsPrintSector(fatSector);
#endif
	}
	if (fatLine != 0)
	    continue;
	fatSector++;
    read:
	ReadDiskSector(fatInfo.currentSector = fatSector);
#if DEBUG_LEVEL > 0
	puthex(fatSector);
	puts("=fatSector Rd");
	FsPrintSector(fatSector);
#endif
    }
}

