#ifndef TEDAX_BOOK_TO_VSDSP_H
#define TEDAX_BOOK_TO_VSDSP_H

/* Note: following number is in 32-bit mixed-endian representation. */
#define BOOK_IDENTIFIER 0x524a6769
/* Binary version number:
   First 2 digits: Major release number, not backwards compatible.
   Second 2 digits: Minor relase number, backwards compatible. */
#define BOOK_VERSION_NUMBER 0x0100

#define MAX_TEDAX_LEVELS 9
#define MAX_TEDAX_LINE_LENGTH 512
/* Note: Number of level items limited by 16-bit unsigned integers.
   If parentIdx, subLevelIdx (and potentially) subLevelSize are
   expanded to 32 bits, this limitation can be removed. */
#define MAX_TEDAX_LEVEL_ITEMS 65534

#ifdef __VSDSP__
  #include <vstypes.h>
#else
typedef unsigned short u_int16;
typedef short s_int16;
typedef unsigned int u_int32;
typedef int s_int32;
#endif


struct TedaxBook {
  char name[MAX_TEDAX_LINE_LENGTH];
  char levelName[MAX_TEDAX_LEVELS+1][MAX_TEDAX_LINE_LENGTH];
};

struct TedaxLevelItem {
  s_int16 level;                        /* 1 for highest level */
  u_int16 parentIdx;                    /* Parent level idx, 0xffff = end */
  u_int16 subLevelIdx;                  /* If non-zero, link to next level */
  u_int16 subLevelSize;                 /* Next level size */
  char ident[MAX_TEDAX_LINE_LENGTH];    /* Identifier */
  char fullName[MAX_TEDAX_LINE_LENGTH]; /* Full name */
  char shortName[MAX_TEDAX_LINE_LENGTH];/* Short name */
  char text[MAX_TEDAX_LINE_LENGTH];     /* Book text for the relevant passage */
  char fileName[MAX_TEDAX_LINE_LENGTH]; /* file name, may include .mp3 suffix */
  s_int32 fileStartMS;                  /* Start point in  milliseconds. */
  s_int32 fileLenMS;                    /* File length in milliseconds. */
};

extern struct TedaxBook book;
extern struct TedaxLevelItem levelItem[MAX_TEDAX_LEVEL_ITEMS];
extern struct TedaxLevelItem *lastLevelItem[MAX_TEDAX_LEVELS+1];
extern int items;

#endif /* TEDAX_BOOK_TO_VSDSP_H */

