/**
   \file swap.c Word swap functions.
*/

#include <vstypes.h>
#include <swap.h>

/* Documented in swap.h */
#ifndef __VSDSP__
auto void Swap16N(register __i0 u_int16 *d, register __b0 u_int16 n) {
  Swap16NXX(d, d, n);
}

auto void Swap16NY(register __i0 u_int16 __mem_y *d, register __b0 u_int16 n) {
  Swap16NYY(d, d, n);
}

auto void Swap16NXX(register __i0 u_int16 *d, register __i2 u_int16 *s, register __b0 u_int16 n) {
  int i;
  for (i=0; i<n; i++) {
    *d++ = Swap16(*s++);
  }
}

auto void Swap16NYY(register __i0 u_int16 __mem_y *d, register __i2 u_int16 __mem_y *s, register __b0 u_int16 n) {
  int i;
  for (i=0; i<n; i++) {
    *d++ = Swap16(*s++);
  }
}

auto u_int16 Swap16(register __b0 u_int16 x) {
  return x << 8 | x >> 8;
}

/* Documented in swap.h */
auto u_int32 Swap32Mix(register __reg_d u_int32 x) {
  return ((x >> 8) & 0x00FF00FFUL) | ((x & 0x00FF00FFUL) << 8);
}
auto void Swap32MixN(register __i0 u_int32 *d, register __b0 u_int16 n) {
  u_int16 i;
  for (i=0; i<n; i++) {
    *d = Swap32Mix(*d);
    d++;
  }
}

/* Documented in swap.h */
auto u_int32 Swap32(register __reg_d u_int32 x) {
  x = x << 16 | x >> 16;
  return ((x >> 8) & 0x00FF00FFUL) | ((x & 0x00FF00FFUL) << 8);
}
auto void Swap32N(register __i0 u_int32 *d, register __b0 u_int16 n) {
  u_int16 i;
  for (i=0; i<n; i++) {
    *d = Swap32(*d);
    d++;
  }
}


/* Documented in swap.h */
u_int32 Swap32Words(register __reg_a u_int32 x) {
  return x << 16 | x >> 16;
}
auto void Swap32WordsN(register __i0 u_int32 *d, register __b0 u_int16 n) {
  u_int16 i;
  for (i=0; i<n; i++) {
    *d = Swap32Words(*d);
    d++;
  }
}

#endif /* __VSDSP__ */
