#ifndef AUDIO_INFO_H
#define AUDIO_INFO_H

#include <vstypes.h>

struct AudioInfo {
  s_int32 fileBytes;
  s_int16 channels;
  s_int32 sampleRate;
  double seconds;
  char formatString[16];
};

#define GAIF_FAST 1

/* Gets audio info for given file. Returns 0 if it recognized a file format,
   non-0 if file didn't exist or was of unknown format.
   If outFile is not NULL, send verbose output to that file. */
int GetAudioInfo(register const char *fileName,
		 register struct AudioInfo *ai,
		 register FILE *outFile,
		 register u_int16 flags);

/* Gets audio info for given file pointer.
   Returns 0 if it recognized a file format,
   non-0 if file didn't exist or was of unknown format.
   If outFile is not NULL, send verbose output to that file.
   Doesn't change location in file. */
int GetAudioInfoFP(register FILE *fp,
		   register struct AudioInfo *ai,
		   register FILE *outFile,
		   register u_int16 flags);


#endif /* !AUDIO_INFO_H */
