#ifndef BOOK_H
#define BOOK_H

#include <vstypes.h>

#define BOOK_IDENTIFIER 0x524a6769
#define MAX_BOOK_LEVELS 9

/*
  Note:
  In VSDSP, basic datatypes are ordered as follows:
  - 16-bit numbers are big-endian: 0x1234 is in file 0x12 0x34
  - 32-bit numbers are mixed-endian: 0x12345678 is in file 0x56 0x78 0x12 0x34
 */

struct Book {           /* Size: 0x40 bytes */
  s_int32 identifier;   /* 0x00-0x03 */
  s_int16 version;      /* 0x04-0x05 */
  u_int16 levelItems;   /* 0x06-0x07 */
  s_int32 nameP;        /* 0x08-0x0b */
  s_int32 levelNameP[MAX_BOOK_LEVELS]; /* 0x0c-0x2f */
  s_int32 padding[4];   /* 0x30-0x3f: Pad to 64 bytes */
};

struct LevelItem {      /* Size: 0x20 bytes for each LevelItem */
  u_int16 parentIdx;    /* 0x00: Parent level idx, 0xffff = top level */
  u_int16 subLevelIdx;  /* 0x02: Index to first item at sublevel */
  u_int16 subLevelSize; /* 0x04: Number of items at sublevel */
  u_int16 fileLenS;     /* 0x06: File length in seconds */ 
  s_int32 identP;       /* 0x08: Ptr to identifier */
  s_int32 fullNameP;    /* 0x0c: Ptr to full name */
  s_int32 shortNameP;   /* 0x10: Ptr to short name */
  s_int32 textP;        /* 0x14: Ptr to text, if available */
  s_int32 fileNameP;    /* 0x18: Ptr to file name */
  s_int32 fileStartMS;  /* 0x1c-0x1f: Start point in file in milliseconds */
};

extern struct Book book;
extern struct LevelItem levelItem;

#endif /* !BOOK_H */
