// This code snippet is included directly into main.c


extern DEVICE usbFlash;
//DEVICE usbFlash;


u_int16 scsiCmdRead[17] = {
	0x5553, 0x4243, // 0,1: USBC
	0x1234, 0x5678, // 2,3: Tag
	0x0002, 0x0000, // 4,5: Data length 512 = 0x00000200
	0x8000, // 6: SCSI_DIR_IN
	0x0A28, // 7: READ(10)
	0x0000, // 8: LUN << 13 + LBA[31:24]
	0x0000, 0x0000, // 9,10: LBA[23:0] | reserved=0
	0x0001, // 11: 1 block(s)
	0,0,0   // 12-14: reserved + padding
};

u_int16 scsiCmdTest[17] = {
	0x5553, 0x4243, // 0,1: USBC
	0x1111, 0x2222, // 2,3: Tag
	0x0000, 0x0000, // 4,5: Data length 512 = 0x00000200
	0x0000, // 6: 0x0000=SCSI_DIR_OUT
	0x0600, // 7: (06)TEST_UNIT_READY
	0x0000, // 8: LUN << 13 + LBA[31:24]
	0x0000, 0x0000, // 9,10: LBA[23:0] | reserved=0
	0x0000, // 11: 1 block(s)
	0,0,0   // 12-14: reserved + padding
};

u_int16 scsiCmdInquiry[17] = {
	0x5553, 0x4243, // 0,1: USBC
	0x5555, 0x5555, // 2,3: Tag
	0x2400, 0x0000, // 4,5: Data length 36 bytes
	0x8000, // 6: 0x8000=SCSI_DIR_IN
	0x0612, // 7: (06)INQUIRY
	0x0000, // 8: LUN << 13 + LBA[31:24]
	0x0024, // 9: Allocation Length
	0x0000, // 10: reserved + padding
	0x0000, // 11: reserved + padding
	0,0,0   // 12-14: reserved + padding
};

u_int16 scsiCmdRequestSense[17] = {
	0x5553, 0x4243, // 0,1: USBC
	0x3333, 0x3333, // 2,3: Tag
	0x1200, 0x0000, // 4,5: Data length 0x12
	0x8000, // 6: 0x8000=SCSI_DIR_IN
	0x0C03, // 7: (12)REQUEST SENSE
	0x0000, // 8: LUN << 13 + LBA[31:24]
	0x0012, // 9: Allocation Length
	0x0000, // 10: reserved + padding
	0x0000, // 11: reserved + padding
	0,0,0   // 12-14: reserved + padding
};

u_int16 scsiCmdRequestCapacity[17] = {
	0x5553, 0x4243, // 0,1: USBC
	0x3333, 0x3333, // 2,3: Tag
	0x0800, 0x0000, // 4,5: Data length 0x12
	0x8000, // 6: 0x8000=SCSI_DIR_IN
	0x0A25, // 7: (12) READ CAPACITY
	0x0000, // 8: LUN, LBA(obsolete), obsolete..
};

u_int16 scsiCmdReadFormatCapacities[17] = {
	0x5553, 0x4243, // 0,1: USBC
	0xd271, 0x0900, // 2,3: Tag
	0xfc00, 0x0000, // 4,5: Data length 0x12
	0x8000, // 6: 0x8000=SCSI_DIR_IN
	0x0a23, // 7: (12) READ FORMAT CAPACITIES
	0x0000, // 8: LUN << 13
	0x0000, // 9: reserved
	0x0000, // 10: reserved + padding
	0x00fc, // 11: reserved + allocation length
	0,0,0   // 12-14: reserved + padding
};

u_int32 usbTotalSectors32 = 0;
u_int16 clearEpStall[] = {0x0201, 0x0000, 0x8100, 0x0000};
char deviceName[20] = {0};
u_int16 statusBuf[7]; 

ioresult ScsiCommand(register u_int16 *usbc) {
	ioresult r;
	if (usbTimeoutTicks < 500) usbTimeoutTicks = 500;
	tryagain:
	if (UsbSendData(&udp->ep[EP_OUT], HOST_TX_PID(PID_OUT), 31, usbc) < 0) return S_ERROR;
	r = UsbReceiveData(&udp->ep[EP_IN], 512, pktBuf);
	if (r == 13) return S_ERROR;
	if (r == E_STALLED) {
		clearEpStall[2] = 0x8000 | (udp->ep[EP_IN].addr_ep << 8);
		UsbControlTransfer(clearEpStall, 0, NULL);		
	}
	r = UsbReceiveData(&udp->ep[EP_IN], 13, statusBuf);
	if (r == E_STALLED) {
		clearEpStall[2] = 0x8000 | (udp->ep[EP_IN].addr_ep << 8);
		UsbControlTransfer(clearEpStall, 0, NULL);		
	}
	if (r < 0) return S_ERROR;
	return statusBuf[6]>>8; //Device returned command passed(0)/failed
}


ioresult MassStorageInit() {
	int i;
	int retries = 0;
	usbTotalSectors32 = 0;
	tryagain:
	
	if (++retries > 3) return S_ERROR;
	if ((i = UsbDeviceProbe()) < 0) {
		DelayL(10000000);
		goto tryagain;
	}
		

	usbTimeoutTicks = 3000;
	if (UsbControlTransfer(setAddress1, 0, NULL)) return E_NOTHING_DETECTED;
	udp->ep[0].addr_ep = USB_DEVICE_ENDPOINT(1,0);
	if ((i = UsbControlTransfer(getConfigurationDescriptor, 255, pktBuf)) < 32) return E_NOTHING_DETECTED;
	ParseConfigurationDescriptor(i);
	if (UsbControlTransfer(setConfiguration1, 0, NULL)) return E_NOTHING_DETECTED;
	UsbControlTransfer(getMaxLun, 1, pktBuf);
	
	usbTimeoutTicks = 3000;
	ScsiCommand(scsiCmdInquiry);
	usbTimeoutTicks = 3000;
	ScsiCommand(scsiCmdRequestSense);
	ScsiCommand(scsiCmdRequestCapacity);
	ScsiCommand(scsiCmdRequestSense);
	if (pktBuf[6] == 0x3a00) { //Medium Not Present
		DelayL(1+000000); //Give it time
		ScsiCommand(scsiCmdRequestSense);
	}
	//ScsiCommand(scsiCmdReadFormatCapacities); //Some card absolutely hates this request
	ScsiCommand(scsiCmdRequestCapacity);
	if (ScsiCommand(scsiCmdRequestCapacity) < 0) goto tryagain;
	
	usbTotalSectors32 = (((u_int32)(pktBuf[0]) << 16) | (pktBuf[1])) + 1;
	sprintf(deviceName,"%ldM USB store",usbTotalSectors32/2048);
	usbTimeoutTicks = 1000;

	return S_OK;

}



ioresult DevUsbBlockRead(register __i0 DEVICE *dev, u_int32 lba, u_int16 blocks, u_int16 *data){
	int r;
	memset(data, 0, 256);
	{
		u_int16 lo = (u_int16)lba;
		u_int16 hi = lba>>16;
		scsiCmdRead[8]  = (hi>>8)|(0<<13);
		scsiCmdRead[9]  = ((hi&0xFF)<<8)|(lo>>8);
		scsiCmdRead[10] = ((lo&0xFF)<<8)|0x0000;
	}
	if ((lba <= usbTotalSectors32) && (ScsiCommand(scsiCmdRead) == S_OK)) {
		memcpy(data, pktBuf, 256);
		return S_OK;
	}
	return S_ERROR;
	
}

const char *DevUsbFlashIdentify(register __i0 void *dev, char *buf, u_int16 bufsize) {
	return deviceName;
}

IOCTL_RESULT DevUsbFlashIoctl(register __i0 DEVICE *dev, s_int16 request, IOCTL_ARGUMENT arg) {
	switch (request) {
		case IOCTL_RESTART: {
			if (UsbDeviceProbe()) return S_ERROR;
			if (MassStorageInit()) {
				usbFlash.flags = __MASK_PRESENT;
				return S_ERROR;
			}
			usbFlash.flags = __MASK_PRESENT | __MASK_OPEN | __MASK_SEEKABLE | __MASK_READABLE;
			return StartFileSystem(dev, "0");
			break;
		}
		case IOCTL_GET_GEOMETRY:
		if (arg) {
			DiskGeometry *g = (DiskGeometry *)arg;
			g->sectorsPerBlock = 1;
			g->totalSectors = usbTotalSectors32;	/* size is in KiB, IOCTL asks for 512-byte blocks */
		}

	}
	return S_OK;
}

DEVICE usbFlash = {__MASK_PRESENT ,DevUsbFlashIdentify,0,0,DevUsbFlashIoctl,0,0,DevUsbBlockRead};
