
#ifndef DEV_SPIFLASH_H
#define DEV_SPIFLASH_H

#include <vsos.h>
#ifndef ASM

#define BUFFERED_WITH_ECC 0x18
#define CONTINUOUS_WITH_ECC 0x10

typedef struct {
	u_int16 addr_ep;				// device address and endpoint
	//u_int16 dev_toggle;    			// next expected data toggle from device
	u_int16 host_send_with_toggle;	// next data toggle to device
	//u_int16 num;                	// Endpoint number
	u_int16 size;               	// Endpoint size
	u_int16 stalled;
} EpInfo;
	
typedef struct UsbMscDeviceInfoStruct {
	u_int16 flags;
	int lun;
	EpInfo  ep[3];          // Hard coded endpoint numers 0 is CONTROL, 1 is IN, 2 is OUT
	u_int16 deviceDescriptor;
	u_int16 usbVersion;
	u_int16 usbClass;
	u_int16 protocol_packetSize;
	u_int16 vid;
	u_int16 pid;
	u_int16 bcdDevice;
	u_int16 iVendor_iProduct;
	u_int16 iSerial_nConfigurations;		
} UsbMscDeviceInfo;


typedef struct DevUsbFlashHardwareInfo {
	void *deviceDataPtr;
	u_int32 totalBlocks32;
 	
} USBFLASH_HWINFO;


ioresult DevUsbFlashCreate(register __i0 DEVICE *dev, const void *name, u_int16 extraInfo);
ioresult DevUsbFlashInput(register __i0 DEVICE *dev, u_int16 port, void *buf, u_int16 bytes);
ioresult DevUsbFlashOutput(register __i0 DEVICE *dev, u_int16 port, void *buf, u_int16 bytes);
ioresult DevUsbFlashBlockRead(register __i0 DEVICE *dev, u_int32 firstBlock, u_int16 blocks, u_int16 *data);
ioresult DevUsbFlashBlockWrite(register __i0 DEVICE *dev, u_int32 firstBlock, u_int16 blocks, u_int16 *data);
ioresult DevUsbFlashDelete(register __i0 DEVICE *dev);
const char* DevUsbFlashIdentify(register __i0 void *dev, char *buf, u_int16 bufsize);
IOCTL_RESULT DevUsbFlashIoctl(register __i0 DEVICE *dev, s_int16 request, IOCTL_ARGUMENT arg);
u_int16 SpiNandInit(register __i0 MEDIUM_DEVICE *ph) ;
void SingleCycleCommand(register __i0 MEDIUM_DEVICE *ph, u_int16 cmd);
void PrintStatus(register __i0 MEDIUM_DEVICE *ph) ;
void Erase128K (register __i0 DEVICE *ph, register u_int32 firstBlock);
void Program2K(register __i0 MEDIUM_DEVICE *ph, register u_int32 firstBlock, u_int16 *data);
void Program2K2(register __i0 MEDIUM_DEVICE *ph, register u_int32 firstBlock, u_int16 *data);

u_int16 SpiNandBlockRead(register __i0 MEDIUM_DEVICE *ph, register u_int32 firstBlock, u_int16 *data);

typedef struct CacheBlockStruct {
	u_int16 flags;
	u_int16 sector;
	u_int16 data[256];
} CacheBlock;
#define CB_NOT_PRESENT 0
#define CB_PRESENT 1
#define CB_DIRTY 2

//#define RESERVED_SECTORS (1*65536/512) // Reserve 64KB from the beginning of flash for boot code
extern DEVICE spiNandFlash;
u_int16 GetREMS(register __i0 MEDIUM_DEVICE *ph);

#endif /* !ASM */

#endif /* !DEV_SD_SD_H */
