#include <vo_stdio.h>
#include <volink.h>     // Linker directives like DLLENTRY
#include <apploader.h>  // RunLibraryFunction etc
#include <vs1010dRom.h>
#include <vo_gpio.h>
#include <vs1010c.h>
#include <playerinfo.h>
#include <string.h>
#include <protocol.h>
#include <spitv.h>
#include <lcd.h>

#include "src/I2C/i2c.h"

#define OLED_I2C_ADDRESS 0x78

#define OLED_RESET_PIN 0x28

#define OLED_COMMAND 0x80
#define OLED_DATA 0x40
#define ScreenPutCommand(a) ScreenPutCommandOrData(a, OLED_COMMAND)
#define ScreenPutData(a) ScreenPutCommandOrData(a, OLED_DATA)




// Init vector for ribbon cable facing upwards
const unsigned char oledInit1306[]={
	0xae, //Display OFF
	0x40, //Display start line is COM0
//	0x5f, //Display start line is COM31
	0x81, //Set Contrast Control
	0xcf,
	0x20, //Set addressing mode
	0x02, //Page addressing mode
	0xa0, //Segment remap (Horizontal direction)
//	0xa1, //Segment remap (Horizontal direction)
	0xa4, //Entire display 0n
	//0xa7, //Inversed display
	0xa6, //non-inversed display
	0xa8, //Set multiplex ratio
	0x3f, //1/64
	0xc0, //COM output scan direction
	//0xc8, //COM output scan direction
	0xd3, //Display offset
	0x01,
	0xd5, //Set clock divider/oscillator frequency
	0x80, //105 Hz
	0xd9, //Set precharge period
	0xf1,
	0xda, //Set COM pins hardware configuration
	0x12,
	0xdb, //Set VCOMH deselect level
	0x30, //0.83 * VCC
	0x8d, //Charge pump setting
	0x14, //Enable charge pump, VCC=7.5V
	0xaf, //Display ON
};

void ScreenPutCommandOrData(register u_int16 value, register u_int16 oled_cmd_or_data) {
	i2c_write8(OLED_I2C_ADDRESS,oled_cmd_or_data, value);
	
}


// Set x,y pointer of display controller
void ScreenLocate(register int x, register int y){
	y |= 0xB0;
	x += 32;
	ScreenPutCommand(y);
	ScreenPutCommand(x & 0x0f);
	ScreenPutCommand((x >> 4) | 0x0010);
}


void ScreenClear(){
	u_int16 x,y;
	for (y=0; y<8; y++){
		ScreenLocate(0,y);
		for (x=0; x<132; x++){
			ScreenPutData(0);
		}
	}
	ScreenLocate(0,0);
}



void OledPutBufferSingle(u_int16 *buf, u_int16 *nextWordAfter) {
	while (buf < nextWordAfter) ScreenPutData(*buf++);
}

#define TEXT_LATIN1 0
#define TEXT_SMALL 1
#define TEXT_UNIFONT 2

// Puts a string to column x, row y.
void OledPutStringXY(register u_int16 x, register u_int16 y, char *s) {
	u_int16 buf[64];
	u_int16 *next; //RenderChar, RenderString return ptr to next free pixelword after char or string
	ScreenLocate(x,y); //Column (0..63), Row(0..3)
	next = RenderString(s, buf, buf+sizeof(buf)); //in VS1010D ROM
	OledPutBufferSingle(buf, next); //Firstword, Lastword+1
}

void OLED_SetRotation(u_int16 x) {
  u_int16 rotation = x % 4;
  u_int16 t=0;
  switch(rotation) {
   case 0:  //0
		ScreenPutCommand(0xc0);
		ScreenPutCommand(0xa0);
		ScreenPutCommand(0x40);
		break;
   case 1:  //180
		ScreenPutCommand(0xc8); 
		ScreenPutCommand(0xa1);
		ScreenPutCommand(0x5f);
		
		break;
  }  
	

  
}



















