#ifndef I2C_H
#define I2C_H


#define I2C_SCL 0x1e
#define I2C_SDA 0x01

#define I2C_ACK_TIMEOUT 10000

// Transmit buffer length
#define TXMAXBUFLEN 8
// Receive buffer length
#define RXMAXBUFLEN 8

u_int16 i2cTransmitBuffer[TXMAXBUFLEN];
volatile u_int16 i2cReceiveBuffer[RXMAXBUFLEN];

extern void I2CStart();
extern void I2CStop();
extern void i2c_write8( u_int16 address, u_int16 reg,  u_int16 value);
extern u_int16 i2c_read8(register u_int16 address, register u_int16 reg);
extern u_int16 i2c_read16(register u_int16 address, register u_int16 reg );
extern u_int16 i2c_read16_LE(register u_int16 address, register u_int16 reg );
extern s_int16 i2c_readS16(register u_int16 address, register u_int16 reg );
extern s_int16 i2c_readS16_LE(register u_int16 address, register u_int16 reg );
extern u_int32 i2c_read24(register u_int16 address, register u_int16 reg );
extern s_int32 i2c_read24S(register u_int16 address, register u_int16 reg );
extern u_int32 i2c_read20_bme(register u_int16 address, register u_int16 reg );
extern ioresult i2c_transmitOctet(u_int16 data);
extern ioresult i2c_TransmitData(void *const TXdata,register u_int16 dataLen );
extern ioresult i2c_ReadData(void *const TXdata,register u_int16 dataLenSend, register u_int16 bytesToRead);


/*
struct i2cLowLevel {
	void (*I2CStart)();
	void (*I2CStop)();
	ioresult (*I2CPutOctet)(register u_int16 outdata);
	ioresult (*I2CGetOctet)(register u_int16 *result);
};
*/

#endif